/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xjnx.dc.service.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import kd.ebg.aqap.banks.gxnx.cmp.services.utils.SignUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;

public class SignUtils
extends AbstractImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SignUtils.class);
    private static SignUtil instance = new SignUtil();

    public static SignUtil getInstance() {
        return instance;
    }

    public String sendAndRecvMsg(String rqstStr) {
        String length;
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri("/servlet/ABC95599.Trans");
        String encoding = RequestContextUtils.getCharset();
        try {
            length = Integer.toString(rqstStr.getBytes(encoding).length);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        String Certificate_SN = RequestContextUtils.getBankParameterValue((String)"certificateSN");
        factory.setHttpHeader("Content-Type", "INFOSEC_SIGN/1.0");
        factory.setHttpHeader("Content-Length", length);
        factory.setHttpHeader("Certificate-SN", Certificate_SN);
        IConnection signConnection = factory.createSignConnection();
        String rspStr = "";
        if (!EBContext.getContext().isUnitTest()) {
            try {
                this.openConnection(signConnection);
                try (OutputStream os = this.getOutputStream(signConnection);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream(signConnection);){
                        rspStr = this.recv(is);
                        this.closeOutputStreamQuietly(os);
                        this.closeInputStreamQuietly(is);
                    }
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return rspStr;
    }
}

