/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.ecny.service.payment;

import kd.ebg.aqap.banks.cmb.ecny.BankBusinessConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentUtil {
    public static String getYurRef(PaymentInfo info) {
        String yurRef = info.getBankRefID();
        if (StringUtils.isEmpty((String)yurRef)) {
            yurRef = PaymentUtil.getBankDetailSeqId(info);
        }
        return yurRef;
    }

    public static String getBankDetailSeqId(PaymentInfo info) throws EBServiceException {
        String result = info.getBankDetailSeqId();
        kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
        result = BankBusinessConfig.isSaasCloud() ? "KINGDEEKD_" + result : "KD_" + result;
        info.setBankRefID(result);
        return result;
    }

    public static String getBankBatchSeqId(PaymentInfo[] infos) throws EBServiceException {
        String result = infos[0].getBankBatchSeqId();
        kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo[])infos);
        result = BankBusinessConfig.isSaasCloud() ? "KINGDEEKD_" + result : "KD_" + result;
        for (PaymentInfo info : infos) {
            info.setBankRefID(result);
        }
        return result;
    }

    public static String getBankBatchSeqId(PaymentInfo info) throws EBServiceException {
        String result = info.getBankBatchSeqId();
        kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)info);
        result = BankBusinessConfig.isSaasCloud() ? "KINGDEEKD_" + result : "KD_" + result;
        info.setBankRefID(result);
        return result;
    }

    public static String getSeqIdFromYurref(String yurref) {
        if (yurref.contains("KD_")) {
            return yurref.substring("KD_".length());
        }
        return yurref;
    }
}

