/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.helper.JDOMHelper;
import kd.ebg.aqap.banks.crcb.dc.helper.RequestPacker;
import kd.ebg.aqap.banks.crcb.dc.helper.ResponseParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest rqst) {
        return RequestPacker.getHistoryBalanceMessage(rqst);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String resp) {
        Map<String, Object> resBankMessage = JDOMHelper.getBodyData(resp);
        BalanceInfo balanceInfo = ResponseParser.parserBalanceMessage(resBankMessage, bankBalanceRequest, "CL0013");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=UTF-8");
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CL0013";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"HistoryBalanceImpl_0", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]);
    }

    public LocalDate limitDate() {
        return null;
    }

    public int queryDays() {
        return 1;
    }
}

