/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.helper.JDOMHelper;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ResponseParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ResponseParser.class);

    public static BalanceInfo parserBalanceMessage(Map<String, Object> map, BankBalanceRequest bankBalanceRequest, String reqNo) {
        block9: {
            if (!map.isEmpty()) {
                try {
                    String retCode = map.get("retCode") == null ? "" : map.get("retCode").toString();
                    if (StringUtils.equals((String)"00000000", (String)(map.get("retCode") == null ? "" : map.get("retCode").toString()))) {
                        int i;
                        List resList = (List)map.get("res");
                        if (!resList.isEmpty() && (i = 0) < resList.size()) {
                            Map r = (Map)resList.get(i);
                            BalanceInfo balanceInfo = new BalanceInfo();
                            if (StringUtils.equals((String)"CL0013", (String)reqNo)) {
                                String balance = r.get("balance") != null ? r.get("balance").toString() : "";
                                String currency = r.get("O1CRTP") != null ? r.get("O1CRTP").toString() : "01";
                                BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)balance);
                                BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)balance);
                                BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)currency);
                                BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (LocalDateTime)bankBalanceRequest.getStartDate().atTime(LocalTime.MIN));
                                BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (BankAcnt)bankBalanceRequest.getAcnt());
                            } else if (StringUtils.equals((String)"CL0003", (String)reqNo)) {
                                String accno = r.get("O1ACNO") != null ? r.get("O1ACNO").toString() : "";
                                String currency = r.get("O1CRTP") != null ? r.get("O1CRTP").toString() : "01";
                                String currentBal = r.get("O1ACBL") != null ? r.get("O1ACBL").toString() : "";
                                String available = r.get("O1KYYE") != null ? r.get("O1KYYE").toString() : "";
                                balanceInfo.setBalanceDateTime(LocalDateTime.now());
                                BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)currentBal);
                                BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)available);
                                BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)currency);
                                BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (LocalDateTime)LocalDateTime.now());
                                BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (List)bankBalanceRequest.getBankAcntList(), (String)accno);
                            }
                            return balanceInfo;
                        }
                        break block9;
                    }
                    logger.info("\u89e3\u6790\u4f59\u989dmap\u4e3a\u7a7a");
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)""));
                }
                catch (EBServiceException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    logger.info("\u89e3\u6790\u4f59\u989d\u62a5\u6587\u51fa\u9519", (Object)e);
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u4f59\u989d\u62a5\u6587\u51fa\u9519\u3002", (String)"ResponseParser_0", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static Map<String, Object> submitPaymentMessage(Map<String, Object> map) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (map != null) {
            try {
                if (StringUtils.equals((String)"00000000", (String)(map.get("retCode") == null ? "" : map.get("retCode").toString()))) {
                    List resList = (List)map.get("res");
                    if (resList != null) {
                        for (Map s : resList) {
                            resMap.put("balance", s.get("O1ZHYE") != null ? s.get("O1ZHYE") : "0");
                            resMap.put("respStatus", s.get("O1JYYD") != null ? s.get("O1JYYD") : "");
                            resMap.put("serialNo", s.get("O1TLSQ") != null ? s.get("O1TLSQ") : "");
                            resMap.put("status", s.get("O1JYZT") != null ? s.get("O1JYZT") : "");
                            resMap.put("remark", s.get("O1ZTMS") != null ? s.get("O1ZTMS") : "");
                            resMap.put("reasonContent", s.get("O1SBYY") != null ? s.get("O1SBYY") : "");
                        }
                    }
                } else {
                    logger.info("\u89e3\u6790\u4ed8\u6b3emap\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                logger.info("\u89e3\u6790\u4ed8\u6b3e\u62a5\u6587\u51fa\u9519", (Object)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u4ed8\u6b3e\u62a5\u6587\u51fa\u9519\u3002", (String)"ResponseParser_1", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
            }
            resMap.put("retCode", map.get("retCode"));
            resMap.put("errorMsg", map.get("errorMsg"));
        }
        return resMap;
    }

    public static Map<String, Object> queryPaymentMessage(Map<String, Object> map) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (map != null) {
            try {
                if (StringUtils.equals((String)"00000000", (String)(map.get("retCode") == null ? "" : map.get("retCode").toString()))) {
                    List resList = (List)map.get("res");
                    resMap.put("status", "99");
                    if (resList != null) {
                        for (Map s : resList) {
                            String value = "99";
                            for (Map.Entry entry : s.entrySet()) {
                                String propertyName = (String)entry.getKey();
                                if (!"O1STT".equalsIgnoreCase(propertyName)) continue;
                                value = entry.getValue();
                                break;
                            }
                            resMap.put("status", value);
                            resMap.put("remark", s.get("O1HTCD") != null ? s.get("O1HTCD") : "");
                            resMap.put("reasonContent", s.get("O1HTMG") != null ? s.get("O1HTMG") : "");
                        }
                    }
                } else {
                    logger.info("\u89e3\u6790\u67e5\u8be2\u4ed8\u6b3emap\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                logger.info("\u89e3\u6790\u67e5\u8be2\u4ed8\u6b3e\u62a5\u6587\u51fa\u9519", (Object)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u67e5\u8be2\u4ed8\u6b3e\u62a5\u6587\u51fa\u9519\u3002", (String)"ResponseParser_2", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
            }
            resMap.put("retCode", map.get("retCode"));
            resMap.put("errorMsg", map.get("errorMsg"));
        }
        return resMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<DetailInfo> parserDeatilsMessage(BankDetailRequest bqst, String rspStr) {
        if (rspStr.equals("") || rspStr.startsWith("-1")) {
            return new ArrayList<DetailInfo>();
        }
        Map<String, Object> map = JDOMHelper.getBodyData(rspStr);
        BankAcnt paramBankAcnt = bqst.getAcnt();
        logger.info("====map=======" + map.get("retCode").toString() + "===" + map.size());
        ArrayList<Object> infos = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (map != null) {
            try {
                List resList;
                logger.info("====retCode=======" + map.get("retCode").toString());
                if (!StringUtils.equals((String)"00000000", (String)map.get("retCode").toString()) || (resList = (List)map.get("res")).isEmpty()) return infos;
                for (Map r : resList) {
                    List resDatas = (List)r.get("resDatas");
                    if (resDatas == null) continue;
                    infos = new ArrayList(16);
                    for (int i = 0; i < resDatas.size(); ++i) {
                        Map d = (Map)resDatas.get(i);
                        DetailInfo info = new DetailInfo();
                        try {
                            String kdFlag;
                            String postscript;
                            info.setAccName(paramBankAcnt.getAccName());
                            info.setAccNo(paramBankAcnt.getAccNo());
                            info.setBankName(paramBankAcnt.getBankName());
                            info.setThirdBankName(d.get("O2REKH") != null ? d.get("O2REKH").toString() : "");
                            info.setOppAccName(d.get("O2RENM") != null ? d.get("O2RENM").toString() : "");
                            info.setOppAccNo(d.get("O2REAC") != null ? d.get("O2REAC").toString() : "");
                            info.setOppBankName(d.get("O2REKH") != null ? d.get("O2REKH").toString() : "");
                            info.setBankDetailNo(d.get("O2TLSQ") != null ? d.get("O2TLSQ").toString() : "");
                            if (d.get("O2AMCD") != null && StringUtils.equals((String)PropertiesConstants.getValue((String)"IMPORT"), (String)d.get("O2AMCD").toString().trim())) {
                                info.setCreditAmount(d.get("O2NGAM") != null ? new BigDecimal(d.get("O2NGAM").toString()) : new BigDecimal(0));
                                info.setDebitAmount(new BigDecimal(0));
                            } else {
                                if (d.get("O2AMCD") == null || !StringUtils.equals((String)PropertiesConstants.getValue((String)"EXPORT"), (String)d.get("O2AMCD").toString().trim())) throw new EBServiceException(ShowTipUtil.getDetailCDFlagErrorTips((String)(d.get("O2AMCD") == null ? ResManager.loadKDString((String)"\u6c47\u5165\u6c47\u51fa\u6807\u8bc6\u4e3a\u7a7a", (String)"ResponseParser_10", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]) : d.get("O2AMCD").toString())));
                                info.setDebitAmount(d.get("O2NGAM") != null ? new BigDecimal(d.get("O2NGAM").toString()) : new BigDecimal(0));
                                info.setCreditAmount(new BigDecimal(0));
                            }
                            info.setTransDate(LocalDate.parse(d.get("O2TRDT").toString(), DateTimeFormatter.ofPattern("yyyyMMdd")));
                            if (d.get("O2TRDT") != null && d.get("O2TRTM") != null) {
                                info.setTransTime(LocalDateTime.parse(d.get("O2TRDT").toString() + d.get("O2TRTM").toString(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            } else {
                                info.setTransTime(LocalDateTime.parse(d.get("O2TRDT").toString(), DateTimeFormatter.ofPattern("yyyyMMdd")));
                            }
                            String cyrrency = d.get("O2CYTP") != null ? d.get("O2CYTP").toString() : bqst.getBankCurrency();
                            info.setCurrency(cyrrency);
                            String bal = d.get("O2ACBL").toString();
                            info.setBalance(StringUtils.isNotEmpty((String)bal) ? new BigDecimal(d.get("O2ACBL").toString()) : null);
                            String desc = "";
                            desc = d.get("O2DESC") == null || d.get("O2DESC").toString().isEmpty() ? d.get("O2YOTU") + "" + d.get("O2SMCD") + "" : d.get("O2DESC").toString();
                            String O2SMCD = String.valueOf(d.get("O2SMCD"));
                            info.setThirdBankName(d.get("O2NUBR") == null ? "" : d.get("O2NUBR").toString());
                            String yotu = postscript = d.get("O2YOTU") != null ? d.get("O2YOTU").toString() : "";
                            postscript = desc;
                            if (!ResponseParser.isFee(O2SMCD) && !StringUtils.isEmpty((String)yotu) && yotu.contains("KD@")) {
                                Date trdt = DateUtil.string2Date((String)d.get("O2TRDT").toString(), (String)"yyyyMMdd");
                                Date spitDate = DateUtil.string2Date((String)"20210924000000", (String)"yyyyMMddHHmmss");
                                String[] descArr = desc.split("\uff0c");
                                String bankDetailSeqId = "";
                                if (trdt.before(spitDate) && descArr.length > 2) {
                                    bankDetailSeqId = descArr[1];
                                    System.out.println("========" + bankDetailSeqId);
                                } else {
                                    try {
                                        bankDetailSeqId = yotu.substring(yotu.indexOf("KD@") + 3);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                DetailSysFiled.set((DetailInfo)info, (String)"KDRetFlag", (String)bankDetailSeqId);
                            }
                            String string = kdFlag = d.get("O2CHNO") != null ? d.get("O2CHNO").toString() : "";
                            if (StringUtils.isNotEmpty((String)kdFlag)) {
                                DetailSysFiled.set((DetailInfo)info, (String)"KDRetFlag", (String)kdFlag);
                            }
                            info.setUseCn(postscript);
                            String explanation = desc;
                            if (explanation.contains("KD@")) {
                                explanation = explanation.replace("KD@", "");
                            }
                            info.setExplanation(explanation);
                            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)d));
                            jsonObject.put("O2TRDT", (Object)d.get("O2TRDT").toString());
                            jsonObject.put("UnionSeqNo", (Object)d.get("UnionSeqNo").toString());
                            jsonObject.put("O2NGAM", (Object)d.get("O2NGAM").toString());
                            info.setJsonMap(jsonObject.toString());
                            info.setBankDetailNo(d.get("UnionSeqNo").toString());
                            String jsonStr = jsonObject.toJSONString();
                            String accNo = bqst.getHeader().getAcnt().getAccNo();
                            String transDate = LocalDateUtil.formatDate((LocalDate)info.getTransDate());
                            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                            if (countMap.containsKey(receiptNo)) {
                                int count = (Integer)countMap.get(receiptNo) + 1;
                                countMap.put(receiptNo, count);
                                receiptNo = receiptNo + "-" + String.format("%04d", count);
                            } else {
                                countMap.put(receiptNo, 0);
                            }
                            info.setReceiptNo(receiptNo);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                            continue;
                        }
                        infos.add(info);
                    }
                }
                return infos;
            }
            catch (Exception e) {
                logger.info("\u89e3\u6790\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u51fa\u9519", (Object)e);
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)map.get("retCode").toString(), (String)map.get("errorMsg").toString()));
            }
        }
        logger.info("\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
        return infos;
    }

    private static boolean isFee(String O2SMCD) {
        String value = PropertiesConstants.getValue((String)"FEE");
        boolean isFee = StringUtils.isNotEmpty((String)O2SMCD) && O2SMCD.indexOf(value) >= 0;
        return isFee;
    }

    public static void parserPaymentMessage(PaymentInfo[] paymentInfoArray, String rps, Map<String, Object> map) {
        BankResponse response = new BankResponse();
        if (map != null) {
            response.setResponseCode((String)map.getOrDefault("retCode", ""));
            response.setResponseMessage((String)map.getOrDefault("errorMsg", ""));
        }
        PaymentInfo paymentInfo = paymentInfoArray[0];
        if (rps == null || rps.equals("-1")) {
            response.setResponseCode("-1");
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        if (paymentInfoArray.length > 0 && map != null && map.size() > 0) {
            paymentInfo = paymentInfoArray[0];
            if (map.get("retCode") != null && StringUtils.equals((String)"00000000", (String)map.get("retCode").toString())) {
                if (StringUtils.equals((String)"90", (String)map.get("status").toString())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"SUCCESS", (String)response.getResponseCode(), (String)response.getResponseMessage());
                } else if (StringUtils.equals((String)"50", (String)map.get("status").toString()) || StringUtils.equals((String)"00", (String)map.get("status").toString()) || StringUtils.equals((String)"10", (String)map.get("status").toString()) || StringUtils.equals((String)"20", (String)map.get("status").toString()) || StringUtils.equals((String)"21", (String)map.get("status").toString())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                } else if (StringUtils.equals((String)"94", (String)map.get("status").toString()) || StringUtils.equals((String)"91", (String)map.get("status").toString()) || StringUtils.equals((String)"93", (String)map.get("status").toString()) || StringUtils.equals((String)"01", (String)map.get("status").toString()) || StringUtils.equals((String)"11", (String)map.get("status").toString()) || StringUtils.equals((String)"12", (String)map.get("status").toString()) || StringUtils.equals((String)"52", (String)map.get("status").toString()) || StringUtils.equals((String)"51", (String)map.get("status").toString())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseMessage(), (String)response.getResponseCode(), (String)response.getResponseMessage());
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseMessage(), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        }
    }

    public static Map<String, Object> submitSalaryMessage(Map<String, Object> map) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (map != null) {
            if (StringUtils.equals((String)"00000000", (String)(map.get("retCode") == null ? "" : map.get("retCode").toString()))) {
                List resList = (List)map.get("res");
                if (resList != null) {
                    for (Map s : resList) {
                        resMap.put("respStatus", s.get("O1JYYD") != null ? s.get("O1JYYD") : "");
                        resMap.put("serialNo", s.get("O1TLSQ") != null ? s.get("O1TLSQ") : "");
                        resMap.put("status", s.get("O1JYZT") != null ? s.get("O1JYZT") : "");
                        resMap.put("remark", s.get("O1ZTMS") != null ? s.get("O1ZTMS") : "");
                        resMap.put("msg", s.get("O1SBYY") != null ? s.get("O1SBYY") : "");
                    }
                }
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u72b6\u6001\u7801\u3002", (String)"ResponseParser_4", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
            }
            resMap.put("retCode", map.get("retCode"));
            resMap.put("errorMsg", map.get("errorMsg"));
        }
        return resMap;
    }

    public static Map<String, Object> submitQuerySalaryMessage(Map<String, Object> map) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (map != null) {
            if (StringUtils.equals((String)"00000000", (String)(map.get("retCode") == null ? "" : map.get("retCode").toString()))) {
                List resList = (List)map.get("res");
                if (resList != null) {
                    for (Map s : resList) {
                        resMap.put("respStatus", s.get("O1BKRM") != null ? s.get("O1BKRM") : "");
                        resMap.put("serialNo", s.get("O2TLSQ") != null ? s.get("O2TLSQ") : "");
                        resMap.put("status", s.get("O2JYZT") != null ? s.get("O2JYZT") : "");
                        resMap.put("remark", s.get("O2STT") != null ? s.get("O2STT") : "");
                        resMap.put("msg", s.get("msg") != null ? s.get("msg") : "");
                    }
                }
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u72b6\u6001\u7801\u3002", (String)"ResponseParser_4", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
            }
            resMap.put("retCode", map.get("retCode"));
            resMap.put("errorMsg", map.get("errorMsg"));
            resMap.put("res", map.get("res"));
        }
        return resMap;
    }

    public static void parserSalaryMessage(PaymentInfo[] paymentInfoArray, String rps, Map<String, Object> map) {
        BankResponse response = new BankResponse();
        if (map != null) {
            response.setResponseCode((String)map.getOrDefault("retCode", ""));
            response.setResponseMessage((String)map.getOrDefault("errorMsg", ""));
        }
        if (rps == null || rps.equals("-1")) {
            for (PaymentInfo paymentInfo : paymentInfoArray) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
            return;
        }
        if (paymentInfoArray.length > 0 && map != null && map.size() > 0) {
            List resObj = (List)map.get("res");
            String retCode = map.get("retCode") + "";
            HashMap<String, String[]> payResMap = new HashMap<String, String[]>();
            String state = "99";
            String payMsg = "";
            boolean isPayQuery = false;
            if (resObj != null) {
                try {
                    for (Map map1 : resObj) {
                        if (map1.get("resDatas") == null) {
                            isPayQuery = true;
                            if (resObj == null || resObj.size() != 1) break;
                            state = map1.get("O1JYZT") + "";
                            payMsg = map1.get("O1ZTMS") + "";
                        }
                        List resDatas = (List)map1.get("resDatas");
                        for (Map resData : resDatas) {
                            System.out.println("======" + resData.toString());
                            String jyjg = (String)resData.get("O2JYJG");
                            String msg = (String)resData.get("msg");
                            String skzh = (String)resData.get("O2SKZH");
                            String jyje = (String)resData.get("O2JYJE");
                            String jybz = (String)resData.get("O2JYBZ");
                            if (jybz.contains("20210714") && jybz.split("pay").length > 0) {
                                jybz = jybz.split("pay")[0];
                            }
                            payResMap.put(skzh + jyje + jybz, new String[]{jyjg, msg});
                        }
                    }
                }
                catch (Exception e) {
                    logger.info("\u89e3\u6790\u4ed8\u6b3e\u7ed3\u679c\u62a5\u6587\u51fa\u9519", (Object)e);
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u4ed8\u6b3e\u7ed3\u679c\u62a5\u6587\u51fa\u9519\u3002", (String)"ResponseParser_5", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
                }
            } else {
                isPayQuery = true;
            }
            for (PaymentInfo paymentInfo : paymentInfoArray) {
                String key = paymentInfo.getIncomeAccNo() + paymentInfo.getAmount() + paymentInfo.getExplanation();
                System.out.println("====\u63d0\u53d6==key:" + key);
                if (payResMap.containsKey(key) && ((String[])payResMap.get(key)).length >= 2) {
                    String[] resArr = (String[])payResMap.get(key);
                    logger.info("================= status =========== " + resArr[0] + "," + resArr[1]);
                    if (StringUtils.equals((String)"91", (String)state)) {
                        response.setResponseCode(resArr[0]);
                        response.setResponseMessage(resArr[1]);
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    if (StringUtils.equals((String)"0", (String)resArr[0])) {
                        response.setResponseCode("0");
                        response.setResponseMessage("SUCCESS");
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"SUCCESS", (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    if (StringUtils.equals((String)"2", (String)resArr[0])) {
                        response.setResponseCode(resArr[0] + ":" + resArr[1]);
                        response.setResponseMessage(resArr[1]);
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    response.setResponseCode(resArr[0]);
                    response.setResponseMessage(resArr[1]);
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if (!isPayQuery) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if (StringUtils.equals((String)"EBCBE017", (String)retCode)) {
                    response.setResponseCode(retCode);
                    response.setResponseMessage(ResManager.loadKDString((String)"\u4ea4\u6613\u5e8f\u5217\u53f7\u4e0d\u5b58\u5728\u3002", (String)"ResponseParser_6", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if ("50".equals(state) || map.containsKey("status") && StringUtils.equals((String)"50", (String)map.get("status").toString())) {
                    response.setResponseCode(state);
                    response.setResponseMessage(payMsg);
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if (!"99".equals(state)) continue;
                response.setResponseCode("99");
                response.setResponseMessage(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ResponseParser_7", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        }
    }
}

