/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.amh.services.balance;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        String accno;
        MappingAcctService service = MappingAcctService.getInstance();
        if (service.isExist(accno = request.getHeader().getAcnt().getAccNo())) {
            String iso = CurrencyUtils.convert2Iso((String)request.getCurrency(), (String)request.getHeader().getBankVersionID(), (String)request.getHeader().getCustomerID());
            accno = service.mapping(accno, iso);
        }
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyyMMdd");
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLMTCQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accNo", (String)accno);
        JDomUtils.addChild((Element)root, (String)"startDate", (String)request.getStartDate().format(fmt));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)request.getStartDate().format(fmt));
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"10");
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage) || StringUtils.isEmpty((String)currentPage)) {
            currentPage = "1";
        }
        JDomUtils.addChild((Element)root, (String)"startRecord", (String)currentPage);
        JDomUtils.addChild((Element)root, (String)"cryType", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)root, (String)"msgType", (String)"AMH940");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        BankResponse rsp = new BankResponse(status, statusText);
        ParserUtils.checkRspCode((BankResponse)rsp, (String)"AAAAAAA");
        String totalNum = root.getChildTextTrim("totalNum");
        if (StringUtils.isEmpty((String)totalNum) || "0".equals(totalNum)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5386\u53f2\u4f59\u989d", (String)"HistoryBalanceImpl_8", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
        }
        Integer total = Integer.parseInt(totalNum);
        String currentPage = this.getCurrentPage();
        if (total > 10 && "1".equals(currentPage)) {
            this.setCurrentPage(HistoryBalanceImpl.calculateLastPageStartIndexFromOne(total, 10));
            return new EBBankBalanceResponse();
        }
        this.setLastPage(true);
        Element list = root.getChild("list");
        List rows = list.getChildren();
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String islastPage = element.getChildTextTrim("islastPage");
            if (!"Y".equals(islastPage)) continue;
            BalanceInfo balanceInfo = new BalanceInfo();
            String finalBalance = element.getChildTextTrim("finalBalance");
            String finalBalanceDate = element.getChildTextTrim("finalBalanceDate");
            String cryType = element.getChildTextTrim("cryType");
            this.setBankCurrency(balanceInfo, cryType);
            this.setBalanceDateTime(balanceInfo, this.parseDateTime(finalBalanceDate));
            this.setCurrentBalance(balanceInfo, finalBalance);
            this.setBankAcnt(balanceInfo, request.getAcnt());
            balances.add(balanceInfo);
            break;
        }
        return new EBBankBalanceResponse(balances);
    }

    public boolean match(BankBalanceRequest request) {
        return true;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLMTCQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d77\u5916\u8d26\u6237\u67e5\u8be2\u2014\u5f52\u96c6\u8d26\u5355\u67e5\u8be2", (String)"HistoryBalanceImpl_9", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]);
    }

    private LocalDateTime parseDateTime(String dateStr) {
        LocalDateTime localDateTime;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = formatter.parse(dateStr);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            localDateTime = LocalDateTime.ofInstant(instant, zone);
        }
        catch (Exception ex) {
            return null;
        }
        return localDateTime;
    }

    public void doBizWithPagePre(BankBalanceRequest request) {
        this.setCurrentPage("1");
        this.setLastPage(false);
    }

    public static int calculateLastPageStartIndexFromOne(int totalItems, int itemsPerPage) {
        int fullPages = totalItems / itemsPerPage;
        if (totalItems % itemsPerPage > 0) {
            ++fullPages;
        }
        int lastPageStartIndex = (fullPages - 1) * itemsPerPage + 1;
        return lastPageStartIndex;
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return true;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        long dayOff = ChronoUnit.DAYS.between(request.getStartDate(), request.getEndDate());
        if (dayOff > 6L) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u8be2\u65f6\u95f4\u95f4\u96947\u5929\u5185\u7684\u5386\u53f2\u4f59\u989d", (String)"HistoryBalanceImpl_5", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
        }
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        BankBalanceRequest bankBalanceRequest = new BankBalanceRequest();
        bankBalanceRequest.setCurrency(request.getCurrency());
        bankBalanceRequest.setStartDate(startDate);
        bankBalanceRequest.setEndDate(startDate);
        bankBalanceRequest.setHeader(request.getHeader());
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        do {
            try {
                EBBankBalanceResponse response = this.doBizPreDay(bankBalanceRequest);
                balances.addAll(response.getBalances());
            }
            catch (Exception e) {
                BalanceInfo balanceInfo = new BalanceInfo();
                if (e.getCause() != null) {
                    balanceInfo.setError(e.getCause().getCause().getMessage());
                } else {
                    balanceInfo.setError(e.getMessage());
                }
                balanceInfo.setBankAcnt(request.getAcnt());
                balanceInfo.setBalanceDateTime(startDate.atStartOfDay());
                balances.add(balanceInfo);
                if (PROCESS_CONNECTED == EBContext.getContext().getProcessFlag()) break;
            }
            startDate = startDate.plusDays(1L);
            bankBalanceRequest.setStartDate(startDate);
            bankBalanceRequest.setEndDate(startDate);
        } while (ChronoUnit.DAYS.between(startDate, endDate) >= 0L);
        return new EBBankBalanceResponse(balances);
    }

    public EBBankBalanceResponse doBizPreDay(BankBalanceRequest request) {
        ArrayList balances = new ArrayList(16);
        this.doBizWithPagePre(request);
        try {
            do {
                EBBankBalanceResponse response;
                if (!CollectionUtil.isNotEmpty((Collection)(response = this.process(request)).getBalances())) continue;
                balances.addAll(response.getBalances());
            } while (!this.isLastPage());
            return new EBBankBalanceResponse(balances);
        }
        catch (Exception var4) {
            throw EBExceiptionUtil.serviceException((Throwable)var4);
        }
    }
}

