/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.balance;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public String pack(BankBalanceRequest rqst) {
        String accNo = rqst.getAcnt().getAccNo();
        Element root = Packer.buildHead("00003020101A0008", Sequence.genSequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"currency", (String)rqst.getBankCurrency());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element dto = JDomUtils.getChildElement((Element)root, (String)"body").getChild("dto");
        String balance = dto.getChildTextTrim("bookBal");
        String use_balance = dto.getChildTextTrim("avaliableBal");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(rqst.getAcnt());
        balanceInfo.setBankCurrency(rqst.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, use_balance);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "00003020101A0008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]);
    }
}

