/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.payment.samebank;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.services.payment.query.OtherAndSameBankPaymentQueryImpl;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OtherAndSameBankPaymentQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead("00003020104B0210", paymentInfo.getBankBatchSeqId());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"rcvAsacName", (String)"");
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"payAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"payAsacNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"payAsacName", (String)"");
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"postRoad", (String)"");
        JDomUtils.addChild((Element)body, (String)"feeAmt", (String)"");
        JDomUtils.addChild((Element)body, (String)"voucherType", (String)"");
        JDomUtils.addChild((Element)body, (String)"voucherNo", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"referNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"rcvAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcvAcctName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcvAsacNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"tfrType", (String)"1");
        JDomUtils.addChild((Element)body, (String)"resTime", (String)"");
        JDomUtils.addChild((Element)body, (String)"mobile", (String)"");
        JDomUtils.addChild((Element)body, (String)"summary", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"rcvAcctKind", (String)"");
        JDomUtils.addChild((Element)body, (String)"saveAcct", (String)"");
        JDomUtils.addChild((Element)body, (String)"loadFlag", (String)"");
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return Parser.payResponse(bankPayRequest, s);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "00003020104B0210";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"00003020104B0210 \u884c\u5185\u8f6c\u8d26", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

