/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMBEBBankResponse;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayDetailParser {
    private static QueryPayDetailParser instance;

    public static synchronized QueryPayDetailParser getInstance() {
        if (instance == null) {
            instance = new QueryPayDetailParser();
        }
        return instance;
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public void parseQueryIndividualDetail(BankPayRequest request, String rspStr) {
        List<PaymentInfo> paymentInfos = request.getPaymentInfos();
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO(root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            List ntqatdqyz = root.getChildren("NTQATDQYZ");
            if (null != ntqatdqyz && ntqatdqyz.size() > 0) {
                paymentInfos = this.preBatchSameItemCheck(request);
                Map<String, CMBEBBankResponse> detailStatusMap = this.getIndividualDetailStatus(ntqatdqyz);
                for (PaymentInfo info : paymentInfos) {
                    String key = this.getKey(info.getIncomeAccNo(), info.getIncomeAccName(), info.getAmount().toPlainString());
                    CMBEBBankResponse bankResponse = detailStatusMap.get(key);
                    if (null == bankResponse) continue;
                    this.handlePayStatus(info, bankResponse.getResponseCode(), bankResponse.getResponseMessage());
                }
                this.processingBankItemDataHandler(ntqatdqyz);
                PayStatusMatchUtil.backBatchSameItemHandler(paymentInfos, (boolean)false, (boolean)false);
            } else {
                EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u5177\u4f53\u4fe1\u606f\u3002", (String)"CMB_DC_QueryPayParser_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentsWithoutStauts((List)paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002 ", (String)"CMB_DC_QueryPayParser_4", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    public void processingBankItemDataHandler(List<Element> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String stsCod = JDomUtils.getChildText((Element)element, (String)"STSCOD");
                    String errDsp = JDomUtils.getChildText((Element)element, (String)"ERRDSP");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, stsCod, errDsp);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private String getBankDataKey(Element node) {
        String accNbr = JDomUtils.getChildText((Element)node, (String)"ACCNBR");
        String cltNam = JDomUtils.getChildText((Element)node, (String)"CLTNAM");
        String trsAmt = JDomUtils.getChildText((Element)node, (String)"TRSAMT");
        String key = this.getKey(accNbr, cltNam, trsAmt);
        return key;
    }

    private Map<String, CMBEBBankResponse> getIndividualDetailStatus(List<Element> ntagprtnzs) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Element node : ntagprtnzs) {
            String key = this.getBankDataKey(node);
            String stsCod = JDomUtils.getChildText((Element)node, (String)"STSCOD");
            String errDsp = JDomUtils.getChildText((Element)node, (String)"ERRDSP");
            CMBEBBankResponse response = new CMBEBBankResponse();
            response.setResponseCode(stsCod);
            response.setResponseMessage(errDsp);
            result.put(key, response);
        }
        return result;
    }

    private String getKey(String incomeAccNo, String incomeName, String amount) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)amount)) {
            BigDecimal bigDecimal = new BigDecimal(amount).setScale(2);
            sb.append(incomeAccNo).append(incomeName).append(bigDecimal.toPlainString());
        }
        return sb.toString();
    }

    public PaymentInfo handlePayStatus(PaymentInfo tempInfo, String stsCod, String errDsp) {
        if ("S".equalsIgnoreCase(stsCod)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CMB_DC_QueryPayParser_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"CMB_DC_QueryPayParser_7", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)errDsp);
        } else if ("F".equals(stsCod)) {
            if (BankBusinessConfig.isAgentFailStatusToSuccess()) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CMB_DC_QueryPayParser_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)stsCod, (String)String.format(ResManager.loadKDString((String)"%s\uff0c\u94f6\u4f01\u5c06\u4ea4\u6613\u5931\u8d25\u4fee\u6539\u4e3a\u4ea4\u6613\u6210\u529f\u3002", (String)"CMB_DC_QueryPayParser_10", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), errDsp));
                PaymentInfoSysFiled.set((PaymentInfo)tempInfo, (String)"refund", (String)tempInfo.getBankDetailSeqId());
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CMB_DC_QueryPayParser_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)stsCod, (String)errDsp);
            }
        } else if ("I".equalsIgnoreCase(stsCod)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)errDsp);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)stsCod, (String)("C".equals(stsCod) ? ResManager.loadKDString((String)"\u64a4\u9500", (String)"CMB_DC_QueryPayParser_9", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]) : errDsp));
        }
        return tempInfo;
    }
}

