/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.agent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.agent.AgentPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AgentQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "NTAGPLST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getImplClassName().equalsIgnoreCase(AgentPayImpl.class.getName());
    }

    public String pack(BankPayRequest request) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = CMB_DC_Packer.packRoot("NTAGPLST");
        Element ntagplstx1 = JDomUtils.addChild((Element)root, (String)"NTAGPLSTX1");
        PaymentInfo info = paymentInfo;
        PaymentUtil.addDate(ntagplstx1, info);
        JDomUtils.addChild((Element)ntagplstx1, (String)"DATFLG", (String)"A");
        if (paymentInfos.size() == 1) {
            JDomUtils.addChild((Element)ntagplstx1, (String)"YURREF", (String)PaymentUtil.getYurRef(info));
        }
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = request.getPaymentInfos();
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if ("0".equalsIgnoreCase(headRsp.getResponseCode())) {
            List ntagplstz1 = root.getChildren("NTAGPLSTZ1");
            if (null != ntagplstz1 && ntagplstz1.size() > 0) {
                Map<String, BankResponse> detailStatusMap = this.getDetailStatus(ntagplstz1);
                for (PaymentInfo info : paymentInfos) {
                    String key = PaymentUtil.getYurRef(info);
                    BankResponse bankResponse = detailStatusMap.get(key);
                    if (null == bankResponse) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u4ece\u7ed3\u679c\u96c6\u4e2d\u5339\u914d\u8be5\u7b14\u660e\u7ec6\u72b6\u6001", (String)"AgentQueryPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
                        continue;
                    }
                    if ("FIN".equalsIgnoreCase(bankResponse.getResponseCode())) {
                        if ("S".equalsIgnoreCase(bankResponse.getResponseMessage())) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"AgentQueryPayImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"AgentQueryPayImpl_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseMessage());
                            continue;
                        }
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"AgentQueryPayImpl_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5931\u8d25", (String)"AgentQueryPayImpl_4", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseMessage());
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"AgentQueryPayImpl_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"AgentQueryPayImpl_6", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u67e5\u6216\u8054\u7cfb\u94f6\u884c\u8fdb\u884c\u67e5\u8bc1\u3002", (String)"AgentQueryPayImpl_7", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
                }
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u652f\u4ed8\u7ed3\u679c\u5931\u8d25\u3002", (String)"AgentQueryPayImpl_8", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"AgentQueryPayImpl_9", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private Map<String, BankResponse> getDetailStatus(List<Element> ntagprtnzs) {
        HashMap<String, BankResponse> result = new HashMap<String, BankResponse>(16);
        for (Element node : ntagprtnzs) {
            String yurref = JDomUtils.getChildText((Element)node, (String)"YURREF");
            String reqsts = JDomUtils.getChildText((Element)node, (String)"REQSTS");
            String rtnflg = JDomUtils.getChildText((Element)node, (String)"RTNFLG");
            BankResponse response = new BankResponse();
            response.setResponseCode(reqsts);
            response.setResponseMessage(rtnflg);
            result.put(yurref, response);
        }
        return result;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

