/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.company;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_PayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.company.ConfigHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "Payment";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u76f4\u63a5\u652f\u4ed8;\u4ea4\u6613\u7801\u662fPayment\uff0cN02031:\u76f4\u63a5\u652f\u4ed8\u3002", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.is2Individual() && BankBusinessConfig.isDividualToDirectPay() || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !paymentInfo.is2Individual() || "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType()) && (paymentInfo.is2SameBank() && BankBusinessConfig.isAllocationToCompanyPay() || !paymentInfo.is2SameBank());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String dbtbbk = ((PaymentInfo)paymentInfos.get(0)).getAreaCode();
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = CMB_DC_Packer.packRoot("Payment");
        Element sdkpayrqx = JDomUtils.addChild((Element)root, (String)"SDKPAYRQX");
        String BUSCOD = ConfigHelper.instance().isDirectGroupPayAcnt(((PaymentInfo)paymentInfos.get(0)).getAccNo()) ? "N02041" : "N02031";
        JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSCOD", (String)BUSCOD);
        String busmod = RequestContextUtils.getBankParameterValue((String)"BUSMOD4DirectPay");
        if (StringUtils.isNotEmpty((String)busmod)) {
            JDomUtils.addChild((Element)sdkpayrqx, (String)"BUSMOD", (String)busmod);
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            kd.ebg.aqap.business.payment.utils.PaymentUtil.setKdFlagIDByBankDetailSeqID((List)paymentInfos);
        }
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element sdkpaydtx = JDomUtils.addChild((Element)root, (String)"SDKPAYDTX");
            JDomUtils.addChild((Element)sdkpaydtx, (String)"YURREF", (String)PaymentUtil.setBankDetailRefID((PaymentInfo)paymentInfos.get(i)));
            if (null != ((PaymentInfo)paymentInfos.get(i)).getBookingTime() && ((PaymentInfo)paymentInfos.get(i)).getBookingTime().isAfter(LocalDateTime.now())) {
                JDomUtils.addChild((Element)sdkpaydtx, (String)"EPTDAT", (String)((PaymentInfo)paymentInfos.get(i)).getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                kd.ebg.aqap.business.payment.utils.PaymentUtil.setBookPayFlag((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            JDomUtils.addChild((Element)sdkpaydtx, (String)"DBTACC", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"DBTBBK", (String)dbtbbk);
            JDomUtils.addChild((Element)sdkpaydtx, (String)"TRSAMT", (String)((PaymentInfo)paymentInfos.get(i)).getAmount().toString());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CCYNBR", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            String stlchn = ((PaymentInfo)paymentInfos.get(i)).getUrgent() != false ? "F" : "N";
            JDomUtils.addChild((Element)sdkpaydtx, (String)"STLCHN", (String)stlchn);
            JDomUtils.addChild((Element)sdkpaydtx, (String)"NUSAGE", (String)StringUtils.substringChinese((String)((PaymentInfo)paymentInfos.get(i)).getExplanation(), (String)encoding, (int)62));
            JDomUtils.addChild((Element)sdkpaydtx, (String)"BUSNAR", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTACC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTNAM", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            if (!StringUtils.isEmpty((String)((PaymentInfo)paymentInfos.get(0)).getIncomeCnaps())) {
                JDomUtils.addChild((Element)sdkpaydtx, (String)"BRDNBR", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            }
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTBNK", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTPVC", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeProvince());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTCTY", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCity());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"NTFCH1", (String)((PaymentInfo)paymentInfos.get(i)).getEmails());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"NTFCH2", (String)((PaymentInfo)paymentInfos.get(i)).getMobiles());
            JDomUtils.addChild((Element)sdkpaydtx, (String)"CRTSQN", (String)"");
        }
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CMB_DC_PayParser.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

