/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.company;

import java.io.InputStream;
import java.util.Properties;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;

public class ConfigHelper {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ConfigHelper.class);
    private static ConfigHelper instance = null;
    private static Properties config = null;

    private ConfigHelper() {
        this.loadConfig();
    }

    public static synchronized ConfigHelper instance() {
        if (null == instance) {
            instance = new ConfigHelper();
        }
        return instance;
    }

    private void loadConfig() {
        try (InputStream inputStream = ConfigHelper.class.getResourceAsStream("cmb_dc.properties");){
            config = new Properties();
            config.load(inputStream);
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    public boolean isDirectGroupPayAcnt(String acnt) {
        if (StrUtil.isEmpty((String)acnt)) {
            return false;
        }
        String acntsLine = config.getProperty("direct_group_pay_acnts", "").trim();
        return acntsLine.contains(acnt);
    }
}

