/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service.payment.salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bjb.dc.service.PackerUtil;
import kd.ebg.aqap.banks.bjb.dc.service.ParserUtil;
import kd.ebg.aqap.banks.bjb.dc.service.login.LoginImpl;
import kd.ebg.aqap.banks.bjb.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        LoginImpl.getInstance().configFactoryForSession(factory, true);
    }

    public int getBatchSize() {
        return 60;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "CebankGZBatchPayNewOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44(\u65b0\u6a21\u5f0f)", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equals(paymentInfo.getSubBizType()) && !BankBusinessConfig.isCashPoolAcnt(paymentInfo.getAccNo());
    }

    public String pack(BankPayRequest request) {
        return PackerUtil.packSalary(request, "CebankGZBatchPayNewOp");
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return ParserUtil.parseSalaryResponse(request, responseStr);
    }
}

