/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.ecny.service.balance;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterprisePayQdcbalRequestV1;
import com.icbc.api.response.MybankEnterprisePayQdcbalResponseV1;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.ecny.service.balance.BalanceParser;
import kd.ebg.aqap.banks.icbc.ecny.service.util.GetStore;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "QDCBAL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u4e92\u8054\u6570\u5b57\u4eba\u6c11\u5e01\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse balance(BankBalanceRequest rqst) {
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/pay/qdcbal/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterprisePayQdcbalRequestV1.MybankEnterprisePayQdcbalRequestBizV1 bizContent = new MybankEnterprisePayQdcbalRequestV1.MybankEnterprisePayQdcbalRequestBizV1();
            Date date = new Date();
            bizContent.setTransCode("QDCBAL");
            String signDate4Test = RequestContextUtils.getBankParameterValue((String)"signDate4Test");
            if (StringUtils.isEmpty((String)signDate4Test)) {
                bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
            } else {
                bizContent.setTranDate(signDate4Test);
            }
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            bizContent.setTotalNum(Integer.valueOf(1));
            BankAcnt acnt = rqst.getAcnt();
            ArrayList<MybankEnterprisePayQdcbalRequestV1.MybankEnterprisePayQdcbalRequestRdV1> rds = new ArrayList<MybankEnterprisePayQdcbalRequestV1.MybankEnterprisePayQdcbalRequestRdV1>();
            MybankEnterprisePayQdcbalRequestV1.MybankEnterprisePayQdcbalRequestRdV1 rd = new MybankEnterprisePayQdcbalRequestV1.MybankEnterprisePayQdcbalRequestRdV1();
            rd.setAccountNo(acnt.getAccNo());
            rd.setCurrency(rqst.getBankCurrency());
            rd.setiSeqNo("1");
            rds.add(rd);
            bizContent.setRd(rds);
            MybankEnterprisePayQdcbalRequestV1 request = new MybankEnterprisePayQdcbalRequestV1();
            request.setServiceUrl(BASE_URL + URI);
            request.setBizContent((BizContent)bizContent);
            this.logger.info("\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
            MybankEnterprisePayQdcbalResponseV1 response = (MybankEnterprisePayQdcbalResponseV1)client.execute((IcbcRequest)request, Sequence.gen18Sequence());
            this.logger.info("\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            return new BalanceParser().parseTodayBalance(rqst, response);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }
}

