/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.apply.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.common.entity.biz.apply.ApplyRequest;
import kd.ebg.aqap.common.entity.biz.apply.CancelApplyRequest;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyFunItem;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ApplyConvert {
    public static BankApplyRequest convert(CancelApplyRequest paramRequest) {
        BankApplyRequest request = new BankApplyRequest();
        request.setZuID(EBContext.getContext().getCustomID());
        BankHeader header = new BankHeader();
        request.setHeader(header);
        String accNo = paramRequest.getBody().getAccNo();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        request.setBsnStr(ApplyConvert.buildBsnStr(paramRequest.getBody().getFunKey(), mainAcnt.getBankVersionId()));
        request.setIDNo("");
        header.setAcnt(mainAcnt);
        header.setBankLoginID(mainAcnt.getBankLoginId());
        header.setBankVersionID(mainAcnt.getBankVersionId());
        header.setBizType(paramRequest.getHeader().getBizType());
        header.setBizSeqID(paramRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(paramRequest.getHeader().getCustomId());
        header.setSubBizType(paramRequest.getHeader().getSubBizType());
        header.setClientName(paramRequest.getHeader().getClientName());
        header.setClientVersion(paramRequest.getHeader().getClientVersion());
        header.setExtData(paramRequest.getHeader().getExtData());
        return request;
    }

    public static BankApplyRequest convert(ApplyRequest paramRequest) {
        BankApplyRequest request = new BankApplyRequest();
        request.setZuID(EBContext.getContext().getCustomID());
        BankHeader header = new BankHeader();
        request.setHeader(header);
        String accNo = paramRequest.getBody().getAccNo();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        request.setBsnStr(ApplyConvert.buildBsnStr(paramRequest.getBody().getFunKey(), mainAcnt.getBankVersionId()));
        request.setIDNo(paramRequest.getBody().getUscCode());
        header.setAcnt(mainAcnt);
        header.setBankLoginID(mainAcnt.getBankLoginId());
        header.setBankVersionID(mainAcnt.getBankVersionId());
        header.setBizType(paramRequest.getHeader().getBizType());
        header.setBizSeqID(paramRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(paramRequest.getHeader().getCustomId());
        header.setSubBizType(paramRequest.getHeader().getSubBizType());
        header.setClientName(paramRequest.getHeader().getClientName());
        header.setClientVersion(paramRequest.getHeader().getClientVersion());
        header.setExtData(paramRequest.getHeader().getExtData());
        return request;
    }

    static String buildBsnStr(String funKey, String bankVersionID) {
        List bankPropertyFunItems = BankBundleManager.getInstance().getBankVersionInfo(bankVersionID).getBankPropertyFunItems();
        if (CollectionUtil.isNotEmpty((Collection)bankPropertyFunItems)) {
            StringBuilder result = new StringBuilder();
            String[] keys = funKey.split(",");
            Set keySet = Arrays.stream(keys).collect(Collectors.toSet());
            for (BankPropertyFunItem b : bankPropertyFunItems) {
                if (!keySet.contains(b.getKey())) continue;
                result.append(b.getFunStr()).append(",");
            }
            return StringUtils.isEmpty((String)result.toString()) ? result.toString() : result.substring(0, result.length() - 1);
        }
        return null;
    }
}

