/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation.utils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.ebg.aqap.business.balancereconciliation.task.BalanceStatementTask;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationSyncPeriod;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class StatementUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(StatementUtil.class);
    private static String CACHE_PREFIX = "balance_state";

    public static String getCacheKey(String accNo, String currency, String startMonthStr, String endMonthStr) {
        return CACHE_PREFIX + "_" + accNo + "_" + currency + "_" + startMonthStr + "_" + endMonthStr;
    }

    public void async(Map<String, List<ReconciliationSyncPeriod>> groupMap, String bankVersionID, String currency) {
        if (!groupMap.isEmpty()) {
            logger.info("\u5f53\u524d\u6709{}\u4e2a\u524d\u7f6e\u673a\u5b58\u5728\u8d26\u53f7\u9700\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u5f85\u529e\u8bb0\u5f55", (Object)groupMap.size());
            for (Map.Entry<String, List<ReconciliationSyncPeriod>> entry : groupMap.entrySet()) {
                this.submit(bankVersionID, entry.getKey(), currency, entry.getValue());
            }
        }
    }

    private void submit(String bankVersionID, String bankLoginID, String currency, List<ReconciliationSyncPeriod> details) {
        String bizType = "balanceStatement";
        String customId = RequestContext.get().getTenantId();
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u5f85\u529e\u8bb0\u5f55traceId\u4e3a" + traceId);
        EBContext oldContext = EBContext.getContext();
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID("").bizName(bizType).subBizName(bizType).bankVersionID(bankVersionID).bankLoginID(bankLoginID).bizSeqID(oldContext.getBizSeqID()).requestSeqID(oldContext.getRequestSeqID()).logBizSeqID(oldContext.getLogBizSeqID()).logRequestSeqID(oldContext.getLogRequestSeqID()).loggerBatchNo(oldContext.getLogger_batch_no()).loggerDetailNo(oldContext.getLogger_detail_no()).loggerBankNo(oldContext.getLogger_bank_no()).schedule(true).build();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo("");
        context.setBankAcnt(bankAcnt);
        logger.info(String.format("\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u5f85\u529e\u8bb0\u5f55\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customId, bankLoginID));
        EBThreadPools.getBalanceStatementThreadPool(customId, bankLoginID).submit((Callable)((Object)new BalanceStatementTask(details, context)));
        logger.info("\u63d0\u4ea4\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u5f85\u529e\u8bb0\u5f55\u7ebf\u7a0b\u6c60\u6210\u529f\uff08{},{}\uff09", new Object[]{customId, bankLoginID});
    }
}

