/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.cert;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.business.cert.utils.SMUtil;
import kd.ebg.aqap.common.entity.biz.cert.CertKeyValueInfo;
import kd.ebg.aqap.common.entity.biz.cert.CertRequest;
import kd.ebg.aqap.common.entity.biz.cert.CertResponse;
import kd.ebg.aqap.common.entity.biz.cert.CertResponseBody;
import kd.ebg.aqap.common.framework.bank.meta.template.OPAMetaDataTemplate;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.common.utils.gdbopa.GDBOpaSMUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.repository.bank.login.BankLoginConfigRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CertMethod
implements EBServiceMethod<CertRequest, CertResponse> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CertMethod.class);
    private BankLoginRepository bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
    private BankLoginConfigRepository bankLoginConfigRepository = (BankLoginConfigRepository)SpringContextUtil.getBean(BankLoginConfigRepository.class);
    private CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
    private UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
    private String cmb_rsa_key = "rsa_key";
    private String cmb_aes_key = "aes_key";

    public CertResponse executeClientRequest(CertRequest request, EBContext context) throws MalformedURLException {
        String bankLoginID = request.getBody().getBankLoginID();
        String customID = context.getCustomID();
        Preconditions.checkArgument((!StringUtils.isEmpty((String)bankLoginID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CertMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        String bankVersionID = bankLoginID.split("-")[0];
        if (!("CMB_OPA".equalsIgnoreCase(bankVersionID) || "GDB_OPA".equalsIgnoreCase(bankVersionID) || "CMB_ECNY".equalsIgnoreCase(bankVersionID))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u7248\u672c\u4e0d\u652f\u6301\u751f\u6210\u8bc1\u4e66\u3002", (String)"CertMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        BankLogin bankLogin = this.bankLoginRepository.findById(bankLoginID, customID);
        if (bankLogin == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5c5e\u4e8e\u5f53\u524d\u79df\u6237\uff01", (String)"CertMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        DynamicObject[] dynamicObjects = this.userCertRepository.getBankLoginCerDatas(bankLoginID, customID);
        List<CertKeyValueInfo> list = "CMB_OPA".equalsIgnoreCase(bankVersionID) || "CMB_ECNY".equalsIgnoreCase(bankVersionID) ? this.getCMBOPACert(request, dynamicObjects, bankVersionID, bankLoginID, customID) : this.getGDBOPACert(request, dynamicObjects, bankVersionID, bankLoginID, customID);
        CertResponse response = new CertResponse();
        CertResponseBody responseBody = new CertResponseBody();
        responseBody.setCertList(list);
        response.setBody(responseBody);
        return response;
    }

    List<CertKeyValueInfo> getGDBOPACert(CertRequest request, DynamicObject[] dynamicObjects, String bankVersionID, String bankLoginID, String customID) {
        ArrayList<CertKeyValueInfo> list = new ArrayList<CertKeyValueInfo>(16);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            if (!request.getBody().isCompelled()) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (!OPAMetaDataTemplate.PublicKey.equalsIgnoreCase(dynamicObject.getString("bank_config_id"))) continue;
                    list.add(new CertKeyValueInfo(OPAMetaDataTemplate.PublicKey, CertMethod.decryptCert(dynamicObject.getString("bank_config_value_tag"), dynamicObject.getString("custom_id"))));
                }
            } else {
                Map map = GDBOpaSMUtil.getSMKey();
                String publicKey = (String)map.get("publicKey");
                String privateKey = (String)map.get("privateKey");
                GDBOpaSMUtil.saveBankLoginCert((String)publicKey, (String)privateKey, (String)bankVersionID, (String)bankLoginID, (String)customID);
                list.add(new CertKeyValueInfo(OPAMetaDataTemplate.PublicKey, publicKey));
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6d41\u7a0b\u5f02\u5e38\uff0c\u8bf7\u5148\u7b7e\u7ea6\u518d\u83b7\u53d6\u79d8\u94a5\u3002", (String)"CertMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        return list;
    }

    List<CertKeyValueInfo> getCMBOPACert(CertRequest request, DynamicObject[] dynamicObjects, String bankVersionID, String bankLoginID, String customID) {
        DynamicObject oldAesDynamicObject = null;
        DynamicObject olRsaDynamicObject = null;
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            if (!request.getBody().isCompelled()) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8bc1\u4e66\u3002", (String)"CertMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                if ("aes_key".equalsIgnoreCase(dynamicObject.getString("bank_config_id"))) {
                    oldAesDynamicObject = dynamicObject;
                    continue;
                }
                if (!this.cmb_rsa_key.equalsIgnoreCase(dynamicObject.getString("bank_config_id"))) continue;
                olRsaDynamicObject = dynamicObject;
            }
        }
        String sm4key = SMUtil.gen16SM4Key();
        CertInfo certInfo = this.certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(bankVersionID, "plateForm_public_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884c\u516c\u94a5\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u8bc1\u4e66\u3002", (String)"CertMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])this.decode(certInfo.getFileContent()), (String)certInfo.getCustomID(), (int)this.getVersion(certInfo.getFileContent()), (String)certInfo.getCertID());
        String bankPublicKey = StringUtils.byteToString((byte[])fileContent);
        String aesEncryptKey = SMUtil.genSM4EncryptKey(sm4key, bankPublicKey);
        String rsaPublicKey = "";
        String rsaPrivateKey = "";
        try {
            Map keypair = SMUtil.CMBSM2KeyGen();
            byte[] publickey = (byte[])keypair.get("publickey");
            byte[] privatekey = (byte[])keypair.get("privatekey");
            rsaPublicKey = Base64.getEncoder().encodeToString(publickey);
            rsaPrivateKey = Base64.getEncoder().encodeToString(privatekey);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u56fd\u5bc6SM\u516c\u79c1\u94a5\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u56fd\u5bc6SM\u79d8\u94a5\u83b7\u53d6\u5931\u8d25\u3002", (String)"CertMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        String source = CertSource.SYSTEM.getSource() + "";
        String certType = CertTypeEnum.PLATEFORM.getType() + "";
        LocalDateTime dateTime = LocalDateTime.of(2099, 12, 30, 23, 59, 59);
        if (oldAesDynamicObject == null) {
            this.userCertRepository.addBankLoginCert(this.cmb_aes_key, ResManager.loadKDString((String)"\u52a0\u5bc6\u5bc6\u94a5", (String)"CertMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, CertMethod.encryptCert(sm4key, customID), "", source, certType);
        } else {
            this.userCertRepository.updateBankLoginCert(oldAesDynamicObject, this.cmb_aes_key, ResManager.loadKDString((String)"\u52a0\u5bc6\u5bc6\u94a5", (String)"CertMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, CertMethod.encryptCert(sm4key, customID), "", source, certType);
        }
        if (olRsaDynamicObject == null) {
            this.userCertRepository.addBankLoginCert(this.cmb_rsa_key, ResManager.loadKDString((String)"\u7b7e\u540d\u79c1\u94a5", (String)"CertMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, CertMethod.encryptCert(rsaPrivateKey, customID), "", source, certType);
        } else {
            this.userCertRepository.updateBankLoginCert(olRsaDynamicObject, this.cmb_rsa_key, ResManager.loadKDString((String)"\u7b7e\u540d\u79c1\u94a5", (String)"CertMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID, bankLoginID, customID, CertMethod.encryptCert(rsaPrivateKey, customID), "", source, certType);
        }
        this.updateSignType(bankLoginID, customID, bankVersionID);
        ArrayList<CertKeyValueInfo> list = new ArrayList<CertKeyValueInfo>(2);
        list.add(new CertKeyValueInfo(this.cmb_aes_key, aesEncryptKey));
        list.add(new CertKeyValueInfo(this.cmb_rsa_key, rsaPublicKey));
        return list;
    }

    void updateSignType(String bankLoginID, String customID, String bankVersionID) {
        DynamicObject signDynamicObject = this.bankLoginConfigRepository.loadByBankLoginIDAndCustomIDAndBankConfigID(bankLoginID, customID, "sign_type");
        if (signDynamicObject == null) {
            this.bankLoginConfigRepository.save("sign_type", ResManager.loadKDString((String)"\u52a0\u89e3\u5bc6\u7b97\u6cd5", (String)"CertMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]), false, false, bankLoginID, bankVersionID, "SM", customID, "ebg");
        } else {
            signDynamicObject.set("bank_config_value", (Object)"SM");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{signDynamicObject});
        }
    }

    static String encryptCert(String certValue, String customID) {
        AESCipherSecurity cipherSecurity = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        byte[] byteArray = certValue.getBytes();
        try {
            return cipherSecurity.encrypt(byteArray);
        }
        catch (Exception e) {
            logger.error("\u5bc6\u94a5\u52a0\u5bc6\u5b58\u5e93\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5bc6\u94a5\u52a0\u5bc6\u5b58\u5e93\u5f02\u5e38\u3002", (String)"CertMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }

    static String decryptCert(String pwdValue, String customID) {
        try {
            CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)pwdValue);
            byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)customID, (int)cipherInfo.getCipherVersion(), (String)"");
            return CipherInfoUtil.getKey((byte[])fileContent);
        }
        catch (Exception e) {
            logger.error("\u5bc6\u94a5\u89e3\u5bc6\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5bc6\u94a5\u89e3\u5bc6\u5f02\u5e38\u3002", (String)"CertMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }

    byte[] decode(String base64String) {
        byte[] data;
        int version = this.getVersion(base64String);
        if (version == 0) {
            data = Base64.getDecoder().decode(base64String);
        } else {
            String cipherData = base64String.split("\\|")[0];
            data = org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherData);
        }
        return data;
    }

    int getVersion(String base64String) {
        int version = 0;
        String[] str = base64String.split("\\|");
        try {
            if (str.length == 2) {
                version = Integer.parseInt(str[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "cert";
    }
}

