/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit;

import java.time.LocalDateTime;
import java.util.List;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.utils.string.StrUtil;

public class EBGCreditUtils {
    public static void setPaymentState(List<OpenCreditDetail> paymentInfos, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        for (OpenCreditDetail info : paymentInfos) {
            EBGCreditUtils.setPaymentState(info, state, errorMsg, bankStatus, bankMsg);
            EBGCreditUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentState(OpenCreditDetail paymentInfo, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        paymentInfo.setStatus(Integer.valueOf(state.getId()));
        paymentInfo.setStatusName(state.getEnName());
        paymentInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isNotBlank((CharSequence)errorMsg)) {
            if (errorMsg.length() > 250) {
                paymentInfo.setErrorMsg(errorMsg.substring(0, 250) + "...");
            } else {
                paymentInfo.setErrorMsg(errorMsg);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            paymentInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
            paymentInfo.setBankMsg(bankMsg);
        }
    }

    public static void setPaymentUpdateTimeAndStatus(OpenCreditDetail paymentInfos, LocalDateTime updateTime) {
        paymentInfos.setUpdateTime(updateTime);
    }

    public static void setPaymentUpdateTimeAndStatus(List<OpenCreditDetail> paymentInfos, LocalDateTime updateTime) {
        for (OpenCreditDetail info : paymentInfos) {
            info.setUpdateTime(updateTime);
            PaymentState state = PaymentState.getEnumById((int)info.getStatus());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
        }
    }

    public static void setPaymentState(List<OpenCreditDetail> paymentInfos, PaymentState state, String bankStatus, String bankMsg) {
        for (OpenCreditDetail info : paymentInfos) {
            EBGCreditUtils.setPaymentState(info, state, bankStatus, bankMsg);
            EBGCreditUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentState(OpenCreditDetail paymentInfo, PaymentState state, String bankStatus, String bankMsg) {
        paymentInfo.setStatus(Integer.valueOf(state.getId()));
        paymentInfo.setStatusName(state.getEnName());
        paymentInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            paymentInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
            paymentInfo.setBankMsg(bankMsg);
        }
    }
}

