/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.ebg.aqap.business.currentandfixed.CurAndFixedBizType;
import kd.ebg.aqap.business.currentandfixed.QueryCurAndFixedBizType;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixed;
import kd.ebg.aqap.business.currentandfixed.atomic.ICurAndFixedPretreat;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.cache.CacheCafStorage;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankCurAndFixedTask;
import kd.ebg.aqap.business.payment.task.BankQueryCurAndFixedTask;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

public class CAFUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CAFUtil.class);
    public static final Map<String, String> opTypMap = new HashMap<String, String>(4);

    public static void preTreatment(List<CurAndFixedInfo> infos, String bankVersionID) {
        for (CurAndFixedInfo info : infos) {
            CAFUtil.preTreatmentEach(info, bankVersionID);
        }
    }

    private static void preTreatmentEach(CurAndFixedInfo info, String bankVersionID) {
        ICurAndFixedPretreat pretreat = (ICurAndFixedPretreat)BankBundleManager.getInstance().getImpl(bankVersionID, ICurAndFixedPretreat.class, (Object)info);
        info.setBankVersion(bankVersionID);
        if (pretreat == null) {
            ICurAndFixed impl = (ICurAndFixed)BankBundleManager.getInstance().getImpl(bankVersionID, ICurAndFixed.class, (Object)new BankCurAndFixedRequest());
            info.setImplClassName(impl.getClass().getName());
        } else {
            pretreat.appendData(info);
        }
    }

    public static void insert(CurAndFixedInfo info) {
        CurAndFixedService.getInstance().save(info);
    }

    public static void insertAll(List<CurAndFixedInfo> infos) {
        LocalDateTime insertTime = LocalDateTime.now();
        infos.forEach(info -> {
            info.setInsertTime(insertTime);
            info.setSyncCount("0");
        });
        CurAndFixedService.getInstance().save(infos, true);
    }

    public static String getOpTyp(String name) {
        return opTypMap.get(name);
    }

    public static Set<List<CurAndFixedInfo>> packageCaf(List<CurAndFixedInfo> curAndFixedInfos) {
        List infos;
        String bankVersion = curAndFixedInfos.get(0).getBankVersion();
        HashSet<List<CurAndFixedInfo>> result = new HashSet<List<CurAndFixedInfo>>(1);
        HashMap maps = Maps.newHashMap();
        for (CurAndFixedInfo curAndFixedInfo : curAndFixedInfos) {
            String implClassName = curAndFixedInfo.getImplClassName();
            if (maps.containsKey(implClassName)) {
                infos = (List)maps.get(implClassName);
                infos.add(curAndFixedInfo);
                continue;
            }
            infos = Lists.newArrayList((Object[])new CurAndFixedInfo[]{curAndFixedInfo});
            maps.put(implClassName, infos);
        }
        for (Map.Entry entry : maps.entrySet()) {
            String implClass = (String)entry.getKey();
            infos = (List)entry.getValue();
            ICurAndFixed caf = (ICurAndFixed)BankBundleManager.getInstance().getImplByClassName(bankVersion, ICurAndFixed.class, implClass);
            int batchSize = caf.getBatchSize();
            if (batchSize < 1) {
                batchSize = 1;
            }
            if (infos.size() <= batchSize) {
                CAFUtil.addBankSeqID(bankVersion, infos);
                result.add(infos);
                continue;
            }
            for (int startIndex = 0; startIndex < infos.size(); startIndex += batchSize) {
                int endIndex = startIndex + batchSize;
                if (endIndex > infos.size()) {
                    endIndex = infos.size();
                }
                List<CurAndFixedInfo> temp = infos.subList(startIndex, endIndex);
                CAFUtil.addBankSeqID(bankVersion, temp);
                result.add(temp);
            }
        }
        return result;
    }

    public static void addBankSeqID(String bankVersionID, List<CurAndFixedInfo> curAndFixedInfos) {
        String bankDetailSeqID = "";
        String bankBatchSeqID = "";
        IBankBatchSeqIDCreator bankBatchSeqIDCreator = (IBankBatchSeqIDCreator)BankBundleManager.getInstance().getBatchSeqIdImplOrNull(bankVersionID);
        if (StringUtils.isEmpty((String)bankBatchSeqID)) {
            bankBatchSeqID = Objects.nonNull(bankBatchSeqIDCreator) ? bankBatchSeqIDCreator.getBankBatchSeqID() : Sequence.gen16Sequence();
            EBContext.getContext().setBizSeqID(bankBatchSeqID);
        }
        IBankDetailSeqIDCreator bankDetailSeqIDCreator = (IBankDetailSeqIDCreator)BankBundleManager.getInstance().getDetailSeqIdImplOrNull(bankVersionID);
        for (CurAndFixedInfo info : curAndFixedInfos) {
            info.setBankBatchSeqID(bankBatchSeqID);
            info.setStatus(Integer.valueOf(CurAndFixedState.PACKAGED.getId()));
            info.setStatusName(CurAndFixedState.PACKAGED.getEnName());
            info.setStatusMsg(CurAndFixedState.PACKAGED.getCnName());
            bankDetailSeqID = Objects.nonNull(bankDetailSeqIDCreator) ? bankDetailSeqIDCreator.getBankDetailSeqID() : Sequence.genSequence();
            info.setBankDetailSeqID(bankDetailSeqID);
        }
    }

    public static Set<List<CurAndFixedInfo>> packageCafQuery(List<CurAndFixedInfo> curAndFixedInfos) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)1);
        set.add(curAndFixedInfos);
        return set;
    }

    public static void async(Set<List<CurAndFixedInfo>> set, EBRequest cafRequset) {
        for (List<CurAndFixedInfo> infos : set) {
            BankCurAndFixedRequest request = CAFUtil.prepareBankCurAndFixedRequest(infos, cafRequset);
            CurAndFixedInfo curAndFixedInfo = infos.get(0);
            String bankVersion = curAndFixedInfo.getBankVersion();
            String bizType = "currentAndFixed";
            String customerId = curAndFixedInfo.getCustomId();
            String batchSeqId = curAndFixedInfo.getBatchSeqId();
            String requestSeqId = String.valueOf(cafRequset.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(System.currentTimeMillis());
            String logBizSeqId = String.valueOf(cafRequset.getHeader().getLogBizSeqID());
            String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
            String subBizType = cafRequset.getHeader().getSubBizType();
            logger.info("\u94f6\u884c\u4fe1\u606f, accNo\u4e3a{}", (Object)request.getHeader().getAcnt().getAccNo());
            logger.info("\u94f6\u884c\u7248\u672c\u4fe1\u606f, bankLoginId\u4e3a{}", (Object)bankLoginId);
            String loggerBankNo = curAndFixedInfo.getBankBatchSeqID();
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(curAndFixedInfo.getBankLoginId()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(loggerBankNo).loggerBankNo(loggerBankNo).build();
            context.setBankAcnt(request.getHeader().getAcnt());
            if (CacheCafStorage.checkRepeat(batchSeqId)) {
                logger.info("\u5f53\u524d\u5b9a\u5b58\u4e1a\u52a1\u6b63\u5728\u5904\u7406,\u6279\u6b21\u53f7{}", (Object)batchSeqId);
                continue;
            }
            EBThreadPools.getCurAndFixedThreadPool(customerId, bankLoginId).submit((Callable)((Object)new BankCurAndFixedTask(request, context)));
            logger.info("\u63d0\u4ea4CAF\u7ebf\u7a0b\u6c60\u6210\u529f");
        }
    }

    public static void asyncQuery(Set<List<CurAndFixedInfo>> set, EBRequest cafRequset) {
        String extDate = cafRequset.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<CurAndFixedInfo> infos : set) {
            BankCurAndFixedRequest request = CAFUtil.prepareBankQueryCurAndFixedRequest(infos, cafRequset);
            CurAndFixedInfo curAndFixedInfo = infos.get(0);
            String bankVersion = curAndFixedInfo.getBankVersion();
            String bizType = "queryCurrentAndFixed";
            String customerId = curAndFixedInfo.getCustomId();
            String batchSeqId = curAndFixedInfo.getBatchSeqId();
            String requestSeqId = String.valueOf(cafRequset.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(System.currentTimeMillis());
            String logBizSeqId = String.valueOf(cafRequset.getHeader().getLogBizSeqID());
            String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
            String subBizType = cafRequset.getHeader().getSubBizType();
            logger.info("\u94f6\u884c\u4fe1\u606f, accNo\u4e3a{}", (Object)request.getHeader().getAcnt().getAccNo());
            logger.info("\u94f6\u884c\u7248\u672c\u4fe1\u606f, bankLoginId\u4e3a{}", (Object)bankLoginId);
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(curAndFixedInfo.getBankLoginId()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(curAndFixedInfo.getBankBatchSeqID()).loggerBankNo(loggerBankNo).build();
            context.setBankAcnt(request.getHeader().getAcnt());
            EBThreadPools.getQueryCurAndFixedThreadPool(customerId, bankLoginId).submit((Callable)((Object)new BankQueryCurAndFixedTask(request, context)));
        }
    }

    private static BankCurAndFixedRequest prepareBankQueryCurAndFixedRequest(List<CurAndFixedInfo> curAndFixedInfos, EBRequest request) {
        BankCurAndFixedRequest bankCurAndFixedRequest = new BankCurAndFixedRequest();
        if (!curAndFixedInfos.isEmpty()) {
            CurAndFixedInfo curAndFixedInfo = curAndFixedInfos.get(0);
            bankCurAndFixedRequest.setCafInfos(curAndFixedInfos);
            bankCurAndFixedRequest.setBatchSeqId(curAndFixedInfo.getBatchSeqId());
            bankCurAndFixedRequest.setHeader(CAFUtil.getQueryHeader(curAndFixedInfo, request));
        }
        return bankCurAndFixedRequest;
    }

    private static BankCurAndFixedRequest prepareBankCurAndFixedRequest(List<CurAndFixedInfo> curAndFixedInfos, EBRequest request) {
        BankCurAndFixedRequest bankCurAndFixedRequest = new BankCurAndFixedRequest();
        if (!curAndFixedInfos.isEmpty()) {
            CurAndFixedInfo curAndFixedInfo = curAndFixedInfos.get(0);
            bankCurAndFixedRequest.setCafInfos(curAndFixedInfos);
            bankCurAndFixedRequest.setBatchSeqId(curAndFixedInfo.getBatchSeqId());
            bankCurAndFixedRequest.setHeader(CAFUtil.getHeader(curAndFixedInfo, request));
        }
        return bankCurAndFixedRequest;
    }

    private static BankHeader getHeader(CurAndFixedInfo curAndFixedInfo, EBRequest request) {
        BankHeader header = new BankHeader();
        String accNo = request.getHeader().getAccNo();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, curAndFixedInfo.getCustomId());
        String bankVersion = curAndFixedInfo.getBankVersion();
        String currency = curAndFixedInfo.getCurrency();
        String subBizType = curAndFixedInfo.getSubBizType();
        header.setBankVersionID(bankVersion);
        header.setBankCurrency(currency);
        header.setSubBizType(subBizType);
        header.setBizType("currentAndFixed");
        header.setClientName("ebc_bankCurAndFixedTask");
        header.setClientVersion("1.0");
        header.setAcnt(acnt);
        return header;
    }

    private static BankHeader getQueryHeader(CurAndFixedInfo curAndFixedInfo, EBRequest request) {
        BankHeader header = new BankHeader();
        String accNo = request.getHeader().getAccNo();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, curAndFixedInfo.getCustomId());
        String bankVersion = curAndFixedInfo.getBankVersion();
        String currency = curAndFixedInfo.getCurrency();
        String subBizType = request.getHeader().getSubBizType();
        header.setBankVersionID(bankVersion);
        header.setBankCurrency(currency);
        header.setSubBizType(subBizType);
        header.setBizType("queryCurrentAndFixed");
        header.setClientName("ebc_bankQueryCurAndFixedTask");
        header.setClientVersion("1.0");
        header.setAcnt(acnt);
        return header;
    }

    public static void setUpdateTimeAndStatus(CurAndFixedInfo curAndFixedInfo, LocalDateTime updateTime) {
        curAndFixedInfo.setUpdateTime(updateTime);
    }

    public static void setState(CurAndFixedInfo[] curAndFixedInfos, CurAndFixedState state, String errorMsg, String bankStatus, String bankMsg) {
        for (CurAndFixedInfo info : curAndFixedInfos) {
            CAFUtil.setState(info, state, errorMsg, bankStatus, bankMsg);
            CAFUtil.setUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setState(List<CurAndFixedInfo> CurAndFixedInfos, CurAndFixedState state, String errorMsg, String bankStatus, String bankMsg) {
        for (CurAndFixedInfo info : CurAndFixedInfos) {
            CAFUtil.setState(info, state, errorMsg, bankStatus, bankMsg);
            CAFUtil.setUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setState(CurAndFixedInfo curAndFixedInfo, CurAndFixedState state, String errorMsg, String bankStatus, String bankMsg) {
        String Lsignal = "<Check>";
        String Rsignal = "</Check>";
        String check = "";
        curAndFixedInfo.setStatus(Integer.valueOf(state.getId()));
        curAndFixedInfo.setStatusName(state.getEnName());
        curAndFixedInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isBlank((CharSequence)errorMsg)) {
            errorMsg = state.getCnName();
        } else if (errorMsg.contains(Lsignal)) {
            int left = errorMsg.indexOf(Lsignal);
            int right = errorMsg.indexOf(Rsignal);
            check = errorMsg.substring(left + Lsignal.length(), right);
        }
        if (errorMsg.length() > 250) {
            curAndFixedInfo.setErrorMsg(errorMsg.substring(0, 246) + "...");
        } else {
            curAndFixedInfo.setErrorMsg(errorMsg);
        }
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            curAndFixedInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
            curAndFixedInfo.setBankMsg(bankMsg);
            if (bankMsg.length() > 250) {
                curAndFixedInfo.setBankStatusMsg(bankMsg.substring(0, 246) + "...");
            } else {
                curAndFixedInfo.setBankStatusMsg(bankMsg);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)check)) {
            curAndFixedInfo.setStatusMsg(state.getCnName() + "," + check);
            curAndFixedInfo.setBankStatusMsg(check);
        }
    }

    public static String getQueryBizType(String biz) {
        String code = CurAndFixedBizType.findCodeByName(biz).getCode();
        return QueryCurAndFixedBizType.findNameByCode(code).getName();
    }

    public static void setCAFInfoUpdateTimeAndStatus(List<CurAndFixedInfo> curAndFixedInfos, LocalDateTime updateTime) {
        curAndFixedInfos.forEach(curAndFixedInfo -> curAndFixedInfo.setUpdateTime(updateTime));
    }

    static {
        opTypMap.put("currentToFixed", "CTF");
        opTypMap.put("fixedToCurrent", "FTC");
        opTypMap.put("currentToNotice", "CTA");
        opTypMap.put("noticeToCurrent", "ATC");
    }
}

