/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed.util;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.currentandfixed.CurAndFixedBizType;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.business.currentandfixed.util.CheckUtil;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurAndFixedReqDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurAndFixedRespDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedRespBody;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedResponse;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CancelNotificationReqDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CurrentAndFixedExRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CurrentAndFixedReqBody;
import kd.ebg.aqap.common.entity.biz.querycurandfixed.QueryCurAndFixedRequest;
import kd.ebg.aqap.common.entity.biz.querycurandfixed.QueryCurAndFixedRespBody;
import kd.ebg.aqap.common.entity.biz.querycurandfixed.QueryCurAndFixedResponse;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CurAndFixedConvert {
    public static List<CurAndFixedInfo> convert(CurrentAndFixedRequest request) {
        kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedReqBody requestBody = request.getBody();
        EBHeader requestHeader = request.getHeader();
        String subBizType = request.getHeader().getSubBizType();
        List details = request.getBody().getDetails();
        ArrayList<CurAndFixedInfo> infos = new ArrayList<CurAndFixedInfo>(1);
        EBContext context = EBContext.getContext();
        String code = CurAndFixedBizType.findCodeByName(subBizType).getCode();
        for (CurAndFixedReqDetail detail : details) {
            CurAndFixedInfo curAndFixedInfo = new CurAndFixedInfo();
            String accNo = detail.getAccNo();
            String accName = detail.getAccName();
            String acntBank = detail.getAcntBank();
            String fixedAccNo = detail.getFixedAccNo();
            String fixedAccName = detail.getFixedAccName();
            String fixedAcntBank = detail.getFixedAcntBank();
            String amount = detail.getAmount();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)accNo), (Object)MultiLang.getAccountEmptyTip());
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)accName), (Object)MultiLang.getAccountNameEmptyTip());
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)acntBank), (Object)MultiLang.getAccountCnapEmptyTip());
            if ("2".equalsIgnoreCase(code)) {
                String inftyp = detail.getInftyp();
                Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)inftyp), (Object)ResManager.loadKDString((String)"\u901a\u77e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CurAndFixedConvert_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument(("01".equalsIgnoreCase(inftyp) || "07".equalsIgnoreCase(inftyp) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u901a\u77e5\u7c7b\u578b\u6709\u8bef,\u4ec5\u652f\u6301\u4e00\u5929\u3001\u4e03\u5929\u901a\u77e5\u7c7b\u578b", (String)"CurAndFixedConvert_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            Preconditions.checkArgument((boolean)Objects.nonNull(amount), (Object)ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"CurAndFixedConvert_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)CheckUtil.checkNumber(accNo), (Object)String.format(ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u53f7\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002%s\u3002", (String)"CurAndFixedConvert_5", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo));
            curAndFixedInfo.setAmount(CheckUtil.checkBigDecimal(detail.getAmount(), ResManager.loadKDString((String)"\u8bf7\u6c42\u4e2d\u7684\u91d1\u989d", (String)"CurAndFixedConvert_4", (String)"ebg-aqap-business", (Object[])new Object[0])).toString());
            curAndFixedInfo.setErrorMsg("");
            curAndFixedInfo.setBackErrorMsg("");
            curAndFixedInfo.setBankMsg("");
            curAndFixedInfo.setCustomId(requestHeader.getCustomId());
            curAndFixedInfo.setBatchSeqId(requestBody.getBatchSeqId());
            curAndFixedInfo.setDetailSeqId(detail.getDetailSeqID());
            curAndFixedInfo.setDetailBizNo(detail.getDetailBizNo());
            if (StringUtils.isEmpty((String)detail.getReqNbr())) {
                curAndFixedInfo.setReqNbr("");
            } else {
                curAndFixedInfo.setReqNbr(detail.getReqNbr());
            }
            curAndFixedInfo.setBackBankStatus("");
            curAndFixedInfo.setBankVersion("");
            curAndFixedInfo.setBankLoginId(context.getBankLoginID());
            curAndFixedInfo.setSubBizType(requestHeader.getSubBizType());
            curAndFixedInfo.setFixedAccNo(detail.getFixedAccNo());
            curAndFixedInfo.setInftyp(detail.getInftyp());
            curAndFixedInfo.setAccNo(detail.getAccNo());
            curAndFixedInfo.setExplanation(detail.getExplanation());
            curAndFixedInfo.setDrawType(detail.getDrawType());
            curAndFixedInfo.setAccName(detail.getAccName());
            curAndFixedInfo.setAcntBank(detail.getAcntBank());
            curAndFixedInfo.setAcntBankNo(detail.getAcntBankNo());
            curAndFixedInfo.setFixedAccName(detail.getFixedAccName());
            curAndFixedInfo.setFixedAcntBank(detail.getFixedAcntBank());
            curAndFixedInfo.setFixedAcntBankNo(detail.getFixedAcntBankNo());
            curAndFixedInfo.setDepositTermValue(detail.getDepositTermValue());
            curAndFixedInfo.setNextDepositType(detail.getNextDepositType());
            curAndFixedInfo.setNextDepositTermValue(detail.getNextDepositTermValue());
            curAndFixedInfo.setOpenDate("");
            curAndFixedInfo.setCloseDate("");
            curAndFixedInfo.setRateDate("");
            curAndFixedInfo.setEndIntDate("");
            curAndFixedInfo.setEndDate("");
            curAndFixedInfo.setExpireOp("");
            curAndFixedInfo.setRate("");
            curAndFixedInfo.setFixInt("");
            curAndFixedInfo.setFixTaxInt("");
            curAndFixedInfo.setFixActInt("");
            curAndFixedInfo.setCloseInt("");
            curAndFixedInfo.setBankStatus("");
            curAndFixedInfo.setBankStatusMsg("");
            curAndFixedInfo.setTranDate(LocalDateTime.now());
            curAndFixedInfo.setTranTime(LocalDateTime.now());
            curAndFixedInfo.setPriceNo(detail.getPriceNo());
            String currency = detail.getCurrency();
            curAndFixedInfo.setCurrency(CurrencyUtils.convert2Bank((String)currency));
            infos.add(curAndFixedInfo);
        }
        return infos;
    }

    public static CurrentAndFixedResponse convert(EBBankCurAndFixedResponse response) {
        CurrentAndFixedResponse currentAndFixedResponse = new CurrentAndFixedResponse();
        List<CurAndFixedInfo> details = response.getDetails();
        String isoCurrency = response.getHeader().getBankCurrency();
        ArrayList<CurAndFixedRespDetail> res = new ArrayList<CurAndFixedRespDetail>(1);
        for (CurAndFixedInfo info : details) {
            CurAndFixedRespDetail rsp = new CurAndFixedRespDetail();
            rsp.setDetailSeqID(info.getDetailSeqId());
            rsp.setOpType(CAFUtil.getOpTyp(info.getSubBizType()));
            rsp.setAccNo(info.getAccNo());
            rsp.setAccName(info.getAccName());
            rsp.setAcntBank(info.getAcntBank());
            rsp.setAcntBankNo(info.getAcntBankNo());
            rsp.setFixedAcntBank(info.getFixedAcntBank());
            rsp.setFixedAcntBankNo(info.getFixedAcntBankNo());
            rsp.setCurrency(isoCurrency);
            rsp.setFixedNo(info.getInftyp());
            rsp.setAdvisef(info.getInftyp());
            rsp.setDepositTermValue(info.getDepositTermValue());
            rsp.setNextDepositTermValue(info.getNextDepositTermValue());
            rsp.setTranDate(info.getTranDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            rsp.setTranTime(info.getTranTime().format(DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss")));
            rsp.setOpenDate(info.getOpenDate());
            rsp.setCloseDate(info.getCloseDate());
            rsp.setCloseDate(info.getCloseDate());
            rsp.setRateDate(info.getRateDate());
            rsp.setEndDate(info.getEndDate());
            rsp.setRate(info.getRate());
            rsp.setFixInt(info.getFixInt());
            rsp.setFixTaxInt(info.getFixTaxInt());
            rsp.setFixActInt(info.getFixActInt());
            rsp.setCloseInt(info.getCloseInt());
            rsp.setStatus(String.valueOf(info.getStatus()));
            rsp.setStatusMsg(info.getStatusMsg());
            rsp.setBankStatus(info.getBankStatus());
            rsp.setBankStatusMsg(info.getBankStatusMsg());
            res.add(rsp);
        }
        CurrentAndFixedRespBody currentAndFixedRespBody = new CurrentAndFixedRespBody();
        currentAndFixedRespBody.setDetails(res);
        currentAndFixedRespBody.setTotalCount(res.size() + "");
        currentAndFixedRespBody.setBatchSeqId(response.getBatchSeqId());
        currentAndFixedResponse.setBody(currentAndFixedRespBody);
        return currentAndFixedResponse;
    }

    public static CurrentAndFixedResponse convertToResponse(List<CurAndFixedInfo> curAndFixedInfos, EBHeader ebHeader) {
        CurrentAndFixedResponse res = new CurrentAndFixedResponse();
        res.setHeader(ebHeader);
        CurrentAndFixedRespBody body = new CurrentAndFixedRespBody();
        ArrayList<CurAndFixedRespDetail> details = new ArrayList<CurAndFixedRespDetail>(1);
        for (CurAndFixedInfo info : curAndFixedInfos) {
            CurAndFixedRespDetail curAndFixedRespDetail = new CurAndFixedRespDetail();
            curAndFixedRespDetail.setReqNbr(info.getReqNbr());
            curAndFixedRespDetail.setBatchSeqID(info.getBatchSeqId());
            curAndFixedRespDetail.setDetailBizNo(info.getDetailBizNo());
            curAndFixedRespDetail.setDetailSeqID(info.getDetailSeqId());
            curAndFixedRespDetail.setOpType(CAFUtil.getOpTyp(info.getSubBizType()));
            curAndFixedRespDetail.setAccNo(info.getAccNo());
            curAndFixedRespDetail.setAccName(info.getAccName());
            curAndFixedRespDetail.setFixedAccNo(info.getFixedAccNo());
            curAndFixedRespDetail.setAcntBank(info.getAcntBank());
            curAndFixedRespDetail.setAcntBankNo(info.getAcntBankNo());
            curAndFixedRespDetail.setFixedAccName(info.getFixedAccName());
            curAndFixedRespDetail.setFixedAcntBank(info.getFixedAcntBank());
            curAndFixedRespDetail.setFixedAcntBankNo(info.getFixedAcntBankNo());
            curAndFixedRespDetail.setCurrency(res.getHeader().getCurrency());
            curAndFixedRespDetail.setFixedNo("");
            curAndFixedRespDetail.setAdviseAccNo(info.getFixedAccNo());
            curAndFixedRespDetail.setAdvisef(info.getInftyp());
            curAndFixedRespDetail.setDepositTermValue(info.getDepositTermValue());
            curAndFixedRespDetail.setNextDepositType(info.getNextDepositType());
            curAndFixedRespDetail.setNextDepositTermValue(info.getNextDepositTermValue());
            curAndFixedRespDetail.setTranDate(info.getTranDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            curAndFixedRespDetail.setTranTime(info.getTranTime().format(DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss")));
            curAndFixedRespDetail.setOpenDate(info.getOpenDate());
            curAndFixedRespDetail.setCloseDate(info.getCloseDate());
            curAndFixedRespDetail.setRateDate(info.getRateDate());
            curAndFixedRespDetail.setEndIntDate(info.getEndIntDate());
            curAndFixedRespDetail.setEndDate(info.getEndDate());
            curAndFixedRespDetail.setExpireOp(info.getExpireOp());
            curAndFixedRespDetail.setRate(info.getRate());
            curAndFixedRespDetail.setFixInt(info.getFixInt());
            curAndFixedRespDetail.setFixTaxInt(info.getFixTaxInt());
            curAndFixedRespDetail.setFixActInt(info.getFixActInt());
            curAndFixedRespDetail.setCloseInt(info.getCloseInt());
            curAndFixedRespDetail.setStatus(String.valueOf(EbStatus.convertBankState2EBG((CurAndFixedState)CurAndFixedState.getEnumById((int)info.getStatus()))));
            curAndFixedRespDetail.setStatusMsg(info.getStatusMsg());
            curAndFixedRespDetail.setBankStatus(info.getBankStatus());
            curAndFixedRespDetail.setBankStatusMsg(info.getBankStatusMsg());
            curAndFixedRespDetail.setAccBal(info.getAccBal());
            curAndFixedRespDetail.setAmount(info.getAmount());
            details.add(curAndFixedRespDetail);
        }
        body.setDetails(details);
        if (!details.isEmpty()) {
            body.setBatchSeqId(((CurAndFixedRespDetail)details.get(0)).getBatchSeqID());
            body.setBatchBizNo(((CurAndFixedRespDetail)details.get(0)).getBatchSeqID());
        }
        res.setBody(body);
        return res;
    }

    public static BankCurAndFixedRequest convert(QueryCurAndFixedRequest queryCurAndFixedRequest) {
        BankCurAndFixedRequest bankCurAndFixedRequest = new BankCurAndFixedRequest();
        String batchSeqId = queryCurAndFixedRequest.getBody().getBatchSeqId();
        String detailSeqID = queryCurAndFixedRequest.getBody().getDetailSeqID();
        bankCurAndFixedRequest.setBatchSeqId(batchSeqId);
        return bankCurAndFixedRequest;
    }

    public static QueryCurAndFixedResponse convertQuery(EBBankCurAndFixedResponse response) {
        QueryCurAndFixedResponse queryCurAndFixedResponse = new QueryCurAndFixedResponse();
        List<CurAndFixedInfo> details = response.getDetails();
        ArrayList<CurAndFixedRespDetail> res = new ArrayList<CurAndFixedRespDetail>(1);
        for (CurAndFixedInfo info : details) {
            CurAndFixedRespDetail rsp = new CurAndFixedRespDetail();
            rsp.setDetailSeqID(info.getDetailSeqId());
            rsp.setOpType(CAFUtil.getOpTyp(info.getSubBizType()));
            rsp.setReqNbr(info.getReqNbr());
            rsp.setAccNo(info.getAccNo());
            rsp.setAccName(info.getAccName());
            rsp.setAcntBank(info.getAcntBank());
            rsp.setAcntBankNo(info.getAcntBankNo());
            rsp.setFixedAccNo(info.getFixedAccNo());
            rsp.setFixedAcntBank(info.getFixedAcntBank());
            rsp.setFixedAcntBankNo(info.getFixedAcntBankNo());
            rsp.setCurrency(info.getCurrency());
            rsp.setAdvisef(info.getInftyp());
            rsp.setAdviseAccNo(info.getFixedAccNo());
            rsp.setDepositTermValue(info.getDepositTermValue());
            rsp.setNextDepositType(info.getNextDepositType());
            rsp.setNextDepositTermValue(info.getNextDepositTermValue());
            rsp.setExpireOp(info.getExpireOp());
            rsp.setTranDate(info.getTranDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            rsp.setTranTime(info.getTranTime().format(DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss")));
            rsp.setOpenDate(info.getOpenDate());
            rsp.setCloseDate(info.getCloseDate());
            rsp.setRateDate(info.getRateDate());
            rsp.setEndDate(info.getEndDate());
            rsp.setRate(info.getRate());
            rsp.setFixInt(info.getFixInt());
            rsp.setFixTaxInt(info.getFixTaxInt());
            rsp.setFixActInt(info.getFixActInt());
            rsp.setCloseInt(info.getCloseInt());
            rsp.setStatus(String.valueOf(EbStatus.convertBankState2EBG((CurAndFixedState)CurAndFixedState.getEnumById((int)info.getStatus()))));
            rsp.setStatusMsg(info.getStatusMsg());
            rsp.setBankStatus(info.getBankStatus());
            rsp.setBankStatusMsg(info.getBankStatusMsg());
            rsp.setAccBal(info.getAccBal());
            rsp.setAmount(info.getAmount());
            if (!StringUtils.isEmpty((String)info.getNotifyId())) {
                rsp.setNotifyId(info.getNotifyId());
            }
            res.add(rsp);
        }
        QueryCurAndFixedRespBody currentAndFixedRespBody = new QueryCurAndFixedRespBody();
        currentAndFixedRespBody.setDetails(res);
        currentAndFixedRespBody.setTotalCount(res.size() + "");
        currentAndFixedRespBody.setBatchSeqId(response.getBatchSeqId());
        queryCurAndFixedResponse.setBody(currentAndFixedRespBody);
        return queryCurAndFixedResponse;
    }

    public static BankCurAndFixedRequest convert(CurrentAndFixedExRequest request) {
        BankCurAndFixedRequest bankCurAndFixedRequest = new BankCurAndFixedRequest();
        CurrentAndFixedReqBody body = request.getBody();
        BankHeader header = new BankHeader();
        bankCurAndFixedRequest.setHeader(header);
        header.setBizType(request.getHeader().getBizType());
        header.setBizSeqID(request.getHeader().getLogBizSeqID());
        header.setCustomerID(request.getHeader().getCustomId());
        header.setSubBizType(request.getHeader().getSubBizType());
        header.setClientName(request.getHeader().getClientName());
        header.setClientVersion(request.getHeader().getClientVersion());
        List details = body.getDetails();
        ArrayList<CurAndFixedInfo> infos = new ArrayList<CurAndFixedInfo>(1);
        for (CancelNotificationReqDetail detail : details) {
            CurAndFixedInfo curAndFixedInfo = new CurAndFixedInfo();
            curAndFixedInfo.setFixedAccNo(detail.getFixedAccNo());
            curAndFixedInfo.setFixedAcntBank(detail.getFixedAcntBank());
            curAndFixedInfo.setFixedAcntBankNo(detail.getFixedAcntBankNo());
            curAndFixedInfo.setFixedAccName(detail.getFixedAccName());
            curAndFixedInfo.setNotifyId(detail.getNotifyId());
            infos.add(curAndFixedInfo);
        }
        bankCurAndFixedRequest.setHeader(header);
        bankCurAndFixedRequest.setCafInfos(infos);
        bankCurAndFixedRequest.setBatchSeqId(body.getBatchSeqId());
        return bankCurAndFixedRequest;
    }
}

