/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.business.detail.storage.DetailSyncService;
import kd.ebg.aqap.business.detail.utils.DetailConvert;
import kd.ebg.aqap.business.detail.utils.DetailUtil;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.detail.Detail;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequest;
import kd.ebg.aqap.common.entity.biz.detail.DetailResponse;
import kd.ebg.aqap.common.entity.biz.detail.DetailResponseBody;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailAsyncMethod
implements EBServiceMethod<DetailRequest, DetailResponse> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailAsyncMethod.class);
    private static final int PAGE_SIZE = 1000;
    private static final String FROM_PAGE = "FROM_COSMIC_EBG";
    DetailSyncService syncService;
    ObjectPropertyService objectPropertyService;

    public DetailResponse executeClientRequest(DetailRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed(context);
        this.syncService = (DetailSyncService)SpringContextUtil.getBean(DetailSyncService.class);
        this.objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
        String bankVersionID = context.getBankVersionID();
        String customID = context.getCustomID();
        String startDateStr = request.getBody().getStartDate();
        String endDateStr = request.getBody().getEndDate();
        BankAcnt bankAcnt = EBContext.getContext().getBankAcnt();
        String currency = request.getHeader().getCurrency();
        LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        boolean isFromEbgPage = "COSMIC-EBG".equalsIgnoreCase(request.getHeader().getClientName());
        if (!isFromEbgPage) {
            request.getBody().setIsKeyRepeat(Integer.valueOf(0));
        }
        String detailSerachDateStr = BankPropertyConfig.getBankDetailSearchDate((String)bankVersionID);
        String accnoSearchLimit = BankPropertyConfig.getAccnoSearchLimit((String)bankAcnt.getAccNo());
        int pageNum = request.getBody().getPageNum();
        int pageSize = request.getBody().getPageSize();
        if (pageNum <= 0) {
            pageNum = 1;
            request.getBody().setPageNum(1);
        }
        if (pageSize <= 0) {
            pageSize = 1000;
            request.getBody().setPageSize(1000);
        }
        if (StrUtil.isBlank((CharSequence)currency)) {
            currency = bankAcnt.getCurrency();
            request.getHeader().setCurrency(currency);
        }
        logger.info("\u5f02\u6b65\u67e5\u8be2\u5e10\u53f7 : {}, \u5e01\u79cd:{} \u4ece {} \u5230 {} \u7684\u660e\u7ec6", new Object[]{bankAcnt.getAccNo(), currency, startDateStr, endDateStr});
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.plusDays(-1L);
        long n = 3L;
        LocalDate preNMonth = endDate.plusMonths(-n);
        if (startDate.isAfter(endDate)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"DetailAsyncMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (BusinessPropertyConfig.isSearchFromFutureDate()) {
            if ((startDate.isBefore(today) || startDate.isEqual(today)) && endDate.isAfter(today)) {
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u67e5\u8be2\u672a\u6765\u65e5\u671f\u548c\u5386\u53f2\uff08\u6216\u5f53\u65e5\uff09\u65e5\u671f\u3002", (String)"DetailAsyncMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        } else {
            if (today.isBefore(endDate) && today.isBefore(startDate)) {
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u90fd\u5927\u4e8e\u4eca\u5929\u3002", (String)"DetailAsyncMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            if (today.isBefore(endDate)) {
                logger.info("\u4e0d\u5141\u8bb8\u67e5\u8be2\u672a\u6765\u65e5\u671f\uff0c\u6240\u4ee5\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u4eca\u5929,\u4fee\u6539\u7ed3\u675f\u65e5\u671f\u4e3a\u4eca\u5929\u3002");
                endDate = today;
            }
        }
        if (startDate.isBefore(preNMonth)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc7 %s\u4e2a\u6708\u3002", (String)"DetailAsyncMethod_15", (String)"ebg-aqap-business", (Object[])new Object[0]), n));
        }
        Date monthLater = DateUtil.preMonth((Date)new Date(), (int)3);
        if (DateUtil.isBefore((Date)LocalDateUtil.localDate2Date((LocalDate)startDate), (Date)monthLater)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5141\u8bb8\u67e5\u8be23\u4e2a\u6708\u4e4b\u524d\u7684\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailAsyncMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)detailSerachDateStr) && "false".equals(accnoSearchLimit)) {
            LocalDate detailSearchDate = LocalDate.parse(detailSerachDateStr.replace("-", ""), DateTimeFormatter.BASIC_ISO_DATE);
            if (endDate.isBefore(detailSearchDate)) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5728\u4ea4\u6613\u660e\u7ec6\u9650\u5236\u67e5\u8be2\u65e5\u671f[%s]\u4e4b\u524d\u3002", (String)"DetailAsyncMethod_16", (String)"ebg-aqap-business", (Object[])new Object[0]), detailSerachDateStr));
            }
            if (startDate.isBefore(detailSearchDate)) {
                startDate = detailSearchDate;
                logger.info("\u5f00\u59cb\u65e5\u671f\u5728\u4ea4\u6613\u660e\u7ec6\u9650\u5236\u65e5\u671f{}\u4e4b\u524d\uff0c\u4fee\u6539\u5f00\u59cb\u65e5\u671f\u4e3a\u4ea4\u6613\u660e\u7ec6\u9650\u5236\u65e5\u671f{}", new Object[]{detailSerachDateStr, detailSerachDateStr});
            }
        }
        boolean isToday = false;
        if (startDate.isEqual(LocalDate.now()) && endDate.isEqual(LocalDate.now())) {
            isToday = true;
        }
        if (request.getBody().isDownloadFromBank() && !isToday) {
            int days = (int)(endDate.toEpochDay() - startDate.toEpochDay()) + 1;
            int maxNum = this.getSearchFromBankMaxNum();
            DetailSyncRecordRepository detailSyncRecordRepository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
            if (days == detailSyncRecordRepository.countByCustomIDAndAccNoAndSyncDateBetween(customID, bankAcnt.getAccNo(), currency, startDate, endDate) && 0 == detailSyncRecordRepository.countByCustomIDAndAccNoAndSyncDateBetweenAndSyncCountLessThan(customID, bankAcnt.getAccNo(), currency, startDate, endDate, maxNum)) {
                throw EBExceiptionUtil.preCheckException((String)(String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u3010%s\u3011", (String)"DetailAsyncMethod_17", (String)"ebg-aqap-business", (Object[])new Object[0]), bankAcnt.getAccNo()) + String.format(ResManager.loadKDString((String)"\u5728\u3010%s\u3011", (String)"DetailAsyncMethod_18", (String)"ebg-aqap-business", (Object[])new Object[0]), startDate.toString()) + String.format(ResManager.loadKDString((String)"\u81f3\u3010%s\u3011", (String)"DetailAsyncMethod_19", (String)"ebg-aqap-business", (Object[])new Object[0]), endDate.toString()) + String.format(ResManager.loadKDString((String)"\u8054\u673a\u67e5\u8be2\u6b21\u6570\u5df2\u8fbe\u5230\u6700\u5927\u6b21\u6570%s\uff0c\u8bf7\u5230\u3010\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u3011\u9875\u9762->\u3010\u4ea4\u6613\u660e\u7ec6\u5141\u8bb8\u8054\u673a\u67e5\u8be2\u7684\u6700\u5927\u6b21\u6570\u3011\u914d\u7f6e\u9879\u8c03\u5927\u6216\u8005\u4f7f\u7528\u666e\u901a\u67e5\u8be2\u64cd\u4f5c", (String)"DetailAsyncMethod_20", (String)"ebg-aqap-business", (Object[])new Object[0]), maxNum)));
            }
            detailSyncRecordRepository.deleteByCustomIDAndAccNoAndSyncDateBetween(customID, bankAcnt.getAccNo(), currency, startDate, endDate);
        }
        if (pageNum <= 1) {
            this.validTimeScope();
        }
        long totalElements = 0L;
        int totalPages = 0;
        boolean lastPage = true;
        List detailInfos = Collections.emptyList();
        String key = "eb_detailFlag__" + customID + "_" + bankVersionID + "_" + bankAcnt.getAccNo() + "_" + startDate.toString() + "_" + endDate.toString() + "_" + currency;
        String handleFlag = CosmicCache.get((String)key);
        if (StringUtils.isEmpty((String)handleFlag) || StringUtils.equals((String)handleFlag, (String)"2") || isFromEbgPage) {
            DetailUtil.async(request, context);
        } else {
            Object page;
            Integer isKeyRepeat = request.getBody().getIsKeyRepeat();
            if (isFromEbgPage && CosmicCache.putIfAbsentWithExpire((String)"eb_detailFlag_FROM_COSMIC_EBG", (String)FROM_PAGE, (int)5, (TimeUnit)TimeUnit.MINUTES) != null) {
                logger.info("Request frequently");
            }
            if (startDate.isBefore(LocalDate.now()) || startDate.isAfter(LocalDate.now())) {
                logger.info("\u67e5\u8be2\u6570\u636e\u5e93\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u7ed3\u679c");
                page = DetailInfoService.getInstance().selectForPage(customID, bankVersionID, bankAcnt.getAccNo(), currency, startDate, endDate, pageNum, pageSize, isFromEbgPage, isKeyRepeat);
                detailInfos = page.getContent();
                totalElements = page.getTotalElements();
                totalPages = page.getTotalPages();
                lastPage = page.isLast();
            } else if (isToday) {
                logger.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u7ed3\u679c");
                detailInfos = this.syncService.getPagingDetail(bankAcnt.getAccNo(), today.toString(), currency, isKeyRepeat, pageNum, pageSize);
                totalElements = this.syncService.getPagingTotalNum(bankAcnt.getAccNo(), today.toString(), currency, isKeyRepeat).intValue();
                if (CollectionUtil.isEmpty(detailInfos) && totalElements > 0L) {
                    logger.info("\u4ece\u7f13\u5b58\u4e2d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u6539\u4e3a\u67e5\u8be2\u6570\u636e\u5e93\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u7ed3\u679c");
                    page = DetailInfoService.getInstance().selectForPage(customID, bankVersionID, bankAcnt.getAccNo(), currency, startDate, endDate, pageNum, pageSize, isFromEbgPage, isKeyRepeat);
                    detailInfos = page.getContent();
                    totalElements = page.getTotalElements();
                }
                totalPages = totalElements % (long)pageSize == 0L ? (int)totalElements / pageSize : (int)totalElements / pageSize + 1;
                lastPage = pageNum == totalPages || totalElements == 0L;
            }
        }
        logger.info("\u9875\u603b\u6570 = {}", (Object)totalPages);
        logger.info("\u603b\u4ea4\u6613\u660e\u7ec6\u6570 = {}", (Object)totalElements);
        logger.info("\u67e5\u8be2\u5230\u7684\u4ea4\u6613\u660e\u7ec6\u7b14\u6570 = {}", (Object)detailInfos.size());
        logger.info("\u6bcf\u9875\u5927\u5c0f = {}", (Object)pageSize);
        logger.info("\u672c\u6b21\u67e5\u8be2\u7684\u9875\u7801 = {}", (Object)pageNum);
        logger.info("\u662f\u5426\u662f\u6700\u540e\u4e00\u9875 = {}", (Object)lastPage);
        ArrayList<Detail> details = new ArrayList<Detail>(detailInfos.size());
        for (DetailInfo info : detailInfos) {
            details.add(DetailConvert.convert(info));
        }
        DetailResponse detailResponse = new DetailResponse();
        DetailResponseBody body = new DetailResponseBody();
        detailResponse.setBody(body);
        body.setLastPage(lastPage);
        body.setTotalCount((int)totalElements);
        body.setPageNum(pageNum);
        body.setPageSize(pageSize);
        body.setDetails(details);
        if (CollectionUtils.isEmpty(details) && (StringUtils.isEmpty((String)handleFlag) || StringUtils.equals((String)handleFlag, (String)"0") || StringUtils.equals((String)handleFlag, (String)"2"))) {
            body.setProgress(0);
        } else {
            body.setProgress(1);
        }
        return detailResponse;
    }

    private boolean validTimeScope() {
        int time = BusinessPropertyConfig.getDetailSearchRestrictScope();
        if (time != 0) {
            Calendar c = Calendar.getInstance();
            Date date = new Date();
            c.setTime(date);
            int hour = c.get(11);
            if (hour > 12) {
                c.set(5, c.get(5) + 1);
            }
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(12, time);
            Date endDate = c.getTime();
            c.set(12, c.get(12) - time * 2);
            Date startDate = c.getTime();
            if (date.after(startDate) && date.before(endDate)) {
                String startDateStr = DateUtil.formatDate((Date)startDate, (String)"HH:mm");
                String endDateStr = DateUtil.formatDate((Date)endDate, (String)"HH:mm");
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e%1$s~%2$s\u65f6\u95f4\u8303\u56f4\u5185\u4e0d\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u3010\u67e5\u8be2\u4e0e\u652f\u4ed8\u3011-\u3010\u94f6\u4f01\u5168\u5c40\u53c2\u6570\u914d\u7f6e\u3011\u4e0b\u53c2\u6570\u96f6\u70b9\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u63a7\u5236", (String)"DetailAsyncMethod_21", (String)"ebg-aqap-business", (Object[])new Object[0]), startDateStr, endDateStr));
            }
        }
        return true;
    }

    int getSearchFromBankMaxNum() {
        ObjectProperties objectProperties = ((ObjectPropertiesRepository)SpringContextUtil.getBean(ObjectPropertiesRepository.class)).findByAttrKeyAndObjectNameAndObjectID("search_from_bank_max_num", "ebg", "common_business");
        if (objectProperties == null) {
            return BusinessPropertyConfig.getSearchFromBankMaxNumDefualtValue();
        }
        return Integer.parseInt(objectProperties.getAttrValue());
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "hisDetail";
    }
}

