/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.business.detail.utils.DetailCompensation;
import kd.ebg.aqap.business.detail.utils.SyncPeriod;
import kd.ebg.aqap.common.constant.SyncDetailTypeEnum;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.DetailSyncRecord;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.model.repository.SyncDetailRepository;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class DetailSyncKit {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailSyncKit.class);
    private static final int NOT_SYNC_MINUTES = 3;
    private static final int SYNC_DATE_MERGE_LENGTH = 1;
    @Autowired
    private DetailSyncRecordRepository detailSyncRecordRepository;
    @Autowired
    private BankAcntRepository bankAcntRepository;
    @Autowired
    private SyncDetailRepository syncDetailRepository;

    private boolean isInsert(DetailSyncRecord record, String accNo, String customId, LocalDate date, int maxNum) {
        try {
            if (Objects.isNull(record)) {
                return true;
            }
            if (0 == record.getEnable()) {
                if (record.getSyncCount() == null || record.getSyncCount() < maxNum) {
                    return true;
                }
                this.log.info("\u5e10\u53f7 : {} \u65e5\u671f : {} \u5df2\u7ecf\u8fbe\u5230\u6b21\u6570{}\uff0c\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u5927\u6b21\u6570{}\uff0c\u4e0d\u518d\u67e5\u8be2", new Object[]{accNo, date.toString(), record.getSyncCount(), maxNum});
                return false;
            }
            if (CosmicConstants.DETAIL_RECORD_NOT_COMPLETED.equals(record.getIsCompleted())) {
                this.log.info("\u5e10\u53f7 : {} \u65e5\u671f : {} \u6ca1\u6709\u8054\u67e5\u6210\u529f\u8fc7\uff0c\u672c\u6b21\u4ecd\u7136\u8054\u67e5\u94f6\u884c", new Object[]{accNo, date.toString()});
                return true;
            }
            if (!EBContext.getContext().isForceQueryDetail()) {
                this.log.info("\u5e10\u53f7 : {} \u65e5\u671f : {} \u5df2\u7ecf\u67e5\u8be2\u8fc7\uff0c\u4e0d\u518d\u67e5\u8be2", new Object[]{accNo, date.toString()});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.info("\u63d2\u5165\u6216\u8005\u66f4\u65b0\u540c\u6b65\u8bb0\u5f55\u5931\u8d25", (Object)e);
            return false;
        }
    }

    public boolean insert_sync_detail_record(String accNo, String customId, LocalDate date) {
        if (this.detailSyncRecordRepository.findByCustomIDAndAccNoAndSyncDate(customId, accNo, date).size() == 0) {
            try {
                if (LocalDate.now().isAfter(date)) {
                    DetailSyncRecord toInsert = new DetailSyncRecord();
                    toInsert.setAccNo(accNo);
                    toInsert.setCustomID(customId);
                    toInsert.setId(Sequence.genSequence());
                    toInsert.setSyncDate(date);
                    toInsert.setDetailCount(Integer.valueOf(1));
                    this.detailSyncRecordRepository.save(toInsert);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void insertSyncDetailRecord(List<DetailInfo> detailInfos, String accNo, String bankName, String customId, LocalDate startDate, LocalDate endDate, String currency, boolean isSearchFromBankSuccess) {
        this.insertSyncDetailRecord(detailInfos, accNo, bankName, customId, startDate, endDate, currency, false, isSearchFromBankSuccess);
    }

    public void insertSyncDetailRecord(List<DetailInfo> detailInfos, String accNo, String bankName, String customId, LocalDate startDate, LocalDate endDate, String currency, boolean isCompensation, boolean isSearchFromBankSuccess) {
        int diffDays = (int)(endDate.toEpochDay() - startDate.toEpochDay()) + 1;
        int[] detailCountArray = new int[diffDays];
        if (!CollectionUtils.isEmpty(detailInfos)) {
            detailInfos.stream().forEach(detailInfo -> {
                int diffDay;
                int n = diffDay = (int)(detailInfo.getTransDate().toEpochDay() - startDate.toEpochDay());
                detailCountArray[n] = detailCountArray[n] + 1;
            });
        }
        DynamicObject[] detailSyncRecords = this.detailSyncRecordRepository.loadByCustomIDAndAccNoAndCurrencyAndSyncDateBetween(customId, accNo, currency, startDate, endDate);
        HashMap<LocalDate, DynamicObject> dateMap = new HashMap<LocalDate, DynamicObject>(1);
        if (detailSyncRecords != null && detailSyncRecords.length > 0) {
            for (DynamicObject detailSyncRecord : detailSyncRecords) {
                dateMap.put(LocalDateUtil.date2LocalDate((Date)detailSyncRecord.getDate("sync_date")), detailSyncRecord);
            }
        }
        LocalDate temp = LocalDate.from(startDate);
        int updCount = detailSyncRecords == null ? 0 : detailSyncRecords.length;
        DynamicObject[] updDatas = new DynamicObject[updCount];
        DynamicObject[] insertDatas = new DynamicObject[diffDays - updCount];
        int updNum = 0;
        int insertNum = 0;
        boolean isDoWhile = false;
        while ((temp.isBefore(endDate) || temp.isEqual(endDate)) && LocalDate.now().isAfter(temp)) {
            DynamicObject detailSyncRecord;
            isDoWhile = true;
            int detailCount = detailCountArray[(int)(temp.toEpochDay() - startDate.toEpochDay())];
            if (dateMap.get(temp) != null) {
                int syncCount;
                detailSyncRecord = (DynamicObject)dateMap.get(temp);
                detailSyncRecord.set("enable", (Object)1);
                detailSyncRecord.set("detail_count", (Object)detailCount);
                detailSyncRecord.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
                int n = syncCount = detailSyncRecord.getInt("sync_count") == 0 ? 1 : detailSyncRecord.getInt("sync_count");
                if (isCompensation) {
                    detailSyncRecord.set("compensation_count", (Object)(detailSyncRecord.getInt("compensation_count") + 1));
                } else if (isSearchFromBankSuccess) {
                    ++syncCount;
                }
                detailSyncRecord.set("sync_count", (Object)syncCount);
                detailSyncRecord.set("currency", (Object)currency);
                detailSyncRecord.set("bank_name", (Object)bankName);
                if (isSearchFromBankSuccess) {
                    detailSyncRecord.set("is_completed", (Object)(isCompensation ? CosmicConstants.DETAIL_RECORD_BC_COMPLETED : CosmicConstants.DETAIL_RECORD_IS_COMPLETED));
                    detailSyncRecord.set("compensation_detail", (Object)"");
                } else {
                    String exceptionMsg = EBContext.getContext().getExceptionMsg();
                    if (StringUtils.isNotEmpty((String)exceptionMsg)) {
                        detailSyncRecord.set("compensation_detail", (Object)(exceptionMsg.length() > 256 ? exceptionMsg.substring(0, 256) : exceptionMsg));
                    }
                }
                updDatas[updNum] = detailSyncRecord;
                ++updNum;
            } else {
                detailSyncRecord = BusinessDataServiceHelper.newDynamicObject((String)"aqap_detail_sync_record");
                Date insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                detailSyncRecord.set("id", (Object)Sequence.genSequence());
                detailSyncRecord.set("createtime", (Object)insertTime);
                detailSyncRecord.set("modifytime", (Object)insertTime);
                detailSyncRecord.set("acc_no", (Object)accNo);
                detailSyncRecord.set("custom_id", (Object)customId);
                Date syncDate = Date.from(temp.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                detailSyncRecord.set("sync_date", (Object)syncDate);
                detailSyncRecord.set("detail_count", (Object)detailCount);
                detailSyncRecord.set("bank_name", (Object)bankName);
                detailSyncRecord.set("enable", (Object)1);
                detailSyncRecord.set("currency", (Object)currency);
                if (isSearchFromBankSuccess) {
                    detailSyncRecord.set("is_completed", (Object)(isCompensation ? CosmicConstants.DETAIL_RECORD_BC_COMPLETED : CosmicConstants.DETAIL_RECORD_IS_COMPLETED));
                } else {
                    detailSyncRecord.set("is_completed", (Object)CosmicConstants.DETAIL_RECORD_NOT_COMPLETED);
                    String exceptionMsg = EBContext.getContext().getExceptionMsg();
                    if (StringUtils.isNotEmpty((String)exceptionMsg)) {
                        detailSyncRecord.set("compensation_detail", (Object)(exceptionMsg.length() > 256 ? exceptionMsg.substring(0, 256) : exceptionMsg));
                    }
                }
                if (isCompensation) {
                    detailSyncRecord.set("compensation_count", (Object)1);
                    detailSyncRecord.set("sync_count", (Object)0);
                } else {
                    detailSyncRecord.set("compensation_count", (Object)0);
                    if (isSearchFromBankSuccess) {
                        detailSyncRecord.set("sync_count", (Object)1);
                    } else {
                        detailSyncRecord.set("sync_count", (Object)0);
                    }
                }
                insertDatas[insertNum] = detailSyncRecord;
                ++insertNum;
            }
            temp = temp.plusDays(1L);
        }
        if (updDatas.length > 0) {
            SaveServiceHelper.save((DynamicObject[])updDatas);
        }
        if (insertDatas.length > 0 && isDoWhile) {
            SaveServiceHelper.save((DynamicObject[])insertDatas);
        }
    }

    public boolean insert_sync_detail(String accNo, String customId, LocalDate startDate, LocalDate endDate, long takeUpTime) {
        try {
            DynamicObject acnt = this.bankAcntRepository.loadSingleByAccno(accNo);
            this.syncDetailRepository.save(acnt, customId, startDate, endDate, SyncDetailTypeEnum.SEARCH_DETAIL.getType(), takeUpTime);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean canSync(String accNo, LocalDate date, boolean isDetailSupportMultiCurrency, String currency, String customId) {
        List byCustomIDAndAccNoAndSyncDate = isDetailSupportMultiCurrency ? this.detailSyncRecordRepository.findByCustomIDAndAccNoAndCurrencyAndSyncDate(customId, accNo, currency, date) : this.detailSyncRecordRepository.findByCustomIDAndAccNoAndSyncDate(customId, accNo, date);
        DetailSyncRecord record = byCustomIDAndAccNoAndSyncDate.isEmpty() ? null : (DetailSyncRecord)byCustomIDAndAccNoAndSyncDate.get(0);
        int maxNum = BusinessPropertyConfig.getSearchFromBankMaxNum();
        return this.isInsert(record, accNo, customId, date, maxNum);
    }

    public List<SyncPeriod> getSyncPeriods(String accNo, LocalDate startDate, LocalDate endDate, boolean isDetailSupportMultiCurrency, String currency, String customID) {
        List<LocalDate> syncDates = this.getSyncDates(accNo, startDate, endDate, isDetailSupportMultiCurrency, currency, customID);
        return this.calculateSyncPeriod(syncDates);
    }

    public List<DetailCompensation> getDetailCompensations(List<LocalDate> syncDates, BankAcnt bankAcnt) {
        ArrayList<DetailCompensation> result = new ArrayList<DetailCompensation>(16);
        if (CollectionUtils.isEmpty(syncDates)) {
            return result;
        }
        List<SyncPeriod> syncPeriods = this.calculateSyncPeriod(syncDates);
        for (SyncPeriod syncPeriod : syncPeriods) {
            this.log.info("\u8d26\u53f7{}\u672c\u6b21\u9700\u8981\u8865\u507f\u7684\u65e5\u671f\u4e3a{}-{}", new Object[]{bankAcnt.getAccNo(), syncPeriod.getStartDate().toString(), syncPeriod.getEndDate().toString()});
            result.add(new DetailCompensation(bankAcnt, syncPeriod.getStartDate(), syncPeriod.getEndDate()));
        }
        return result;
    }

    private List<SyncPeriod> calculateSyncPeriod(List<LocalDate> date2Sync) {
        if (date2Sync.isEmpty()) {
            return new ArrayList<SyncPeriod>(1);
        }
        date2Sync.sort((d1, d2) -> {
            if (d1.isBefore((ChronoLocalDate)d2)) {
                return -1;
            }
            if (d1.isAfter((ChronoLocalDate)d2)) {
                return 1;
            }
            return 0;
        });
        ArrayList<SyncPeriod> result = new ArrayList<SyncPeriod>(1);
        SyncPeriod tempPeriod = new SyncPeriod();
        tempPeriod.setStartDate(date2Sync.get(0));
        tempPeriod.setEndDate(date2Sync.get(0).plusDays(1L));
        for (LocalDate localDate : date2Sync) {
            if (localDate.isAfter(tempPeriod.getEndDate())) {
                tempPeriod.setEndDate(tempPeriod.getEndDate().minusDays(1L));
                result.add(tempPeriod);
                tempPeriod = new SyncPeriod();
                tempPeriod.setStartDate(localDate);
                tempPeriod.setEndDate(localDate.plusDays(1L));
                continue;
            }
            tempPeriod.setEndDate(localDate.plusDays(1L));
        }
        LocalDate lastInDate2Sync = date2Sync.get(date2Sync.size() - 1);
        if (tempPeriod.getEndDate().isAfter(lastInDate2Sync)) {
            tempPeriod.setEndDate(lastInDate2Sync);
        }
        result.add(tempPeriod);
        return result;
    }

    public List<LocalDate> getSyncDates(String accNo, LocalDate startDate, LocalDate endDate, boolean isDetailSupportMultiCurrency, String currency, String customID) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(1);
        List records = isDetailSupportMultiCurrency ? this.detailSyncRecordRepository.findByCustomIDAndAccNoAndCurrencyAndSyncDateBetween(customID, accNo, currency, startDate, endDate) : this.detailSyncRecordRepository.findByCustomIDAndAccNoAndSyncDateBetween(customID, accNo, startDate, endDate);
        LocalDate temp = LocalDate.from(startDate);
        int maxNum = BusinessPropertyConfig.getSearchFromBankMaxNum();
        while (temp.isBefore(endDate) || temp.isEqual(endDate)) {
            DetailSyncRecord inDB = null;
            for (DetailSyncRecord record : records) {
                if (!record.getAccNo().equalsIgnoreCase(accNo) || !record.getSyncDate().equals(temp)) continue;
                inDB = record;
                break;
            }
            if (this.isInsert(inDB, accNo, customID, temp, maxNum)) {
                dates.add(temp);
            }
            temp = temp.plusDays(1L);
        }
        return dates;
    }

    private boolean syncRecently(DetailSyncRecord record) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime latestTime = now.minusMinutes(3L);
        LocalDateTime lastUpdateTime = record.getUpdateTime();
        return lastUpdateTime.isAfter(latestTime);
    }
}

