/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.file;

import com.alibaba.fastjson.JSONObject;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.ebg.aqap.business.file.OpenApiUtil;
import kd.ebg.aqap.business.file.atomic.IUpload;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.PayAttachment;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public abstract class AbstractAttachmentImpl
extends AbstractBankXmlImpl
implements IUpload {
    EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractAttachmentImpl.class);
    public final String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36";

    public abstract String pack(PayAttachment var1);

    public abstract void parse(PayAttachment var1, String var2);

    protected ChannelSftp getChannelSftp() {
        ChannelSftp channelSftp = null;
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String ftpIP = parameter.getBankParameter("upload_sftp_ip");
        String ftpPortStr = parameter.getBankParameter("upload_sftp_port");
        String ftpCertPath = parameter.getBankParameter("upload_sftp_cert_path");
        String ftpUserName = parameter.getBankParameter("upload_sftp_user");
        String ftpPassword = parameter.getBankParameter("upload_sftp_cipher");
        int ftpPort = Integer.parseInt(ftpPortStr);
        try {
            channelSftp = this.startConnect(ftpIP, ftpPort, ftpUserName, ftpPassword, ftpCertPath, "");
        }
        catch (JSchException | IOException e) {
            this.logger.error("sftp\u8fde\u63a5\u5f02\u5e38", e);
        }
        return channelSftp;
    }

    public ChannelSftp startConnect(String host, int port, String username, String ftpPassword, String ftpCertFileName, String ftpCertPassword) throws JSchException, IOException {
        String ftpCert;
        JSch jsch = new JSch();
        this.logger.info("\u51c6\u5907\u5efa\u7acbSFTP\u8fde\u63a5\u3002");
        if (!StringUtils.isEmpty((String)ftpCertFileName) && StringUtils.isNotEmpty((String)(ftpCert = this.getFtpCert()))) {
            File cert = FileCommonUtils.getFileByPath((String)this.getFtpCertPath(), (String)ftpCertFileName);
            String ftpCertPath = this.getFtpCertPath() + File.separator + ftpCertFileName;
            File certFile = new File(this.getFtpCertPath() + File.separator, FilenameUtils.getName((String)ftpCertFileName));
            if (!cert.exists()) {
                this.logger.info("\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u4fdd\u5b58\u5230\u5bf9\u5e94\u76ee\u5f55:" + ftpCertPath);
                FileUtils.write((File)certFile, (CharSequence)ftpCert, (Charset)StandardCharsets.UTF_8);
                File fileByPath = FileCommonUtils.getFileByPath((String)ftpCertPath);
                if (fileByPath.exists()) {
                    this.logger.info("\u8bc1\u4e66\u4fdd\u5b58\u6210\u529f");
                }
            }
            if (StringUtils.isEmpty((String)ftpCertPassword)) {
                jsch.addIdentity(ftpCertPath);
            } else {
                jsch.addIdentity(ftpCertPath, ftpCertPassword);
            }
        }
        Session session = jsch.getSession(username, host, port);
        session.setConfig("StrictHostKeyChecking", "no");
        session.setTimeout(600000);
        if (!StringUtils.isEmpty((String)ftpPassword)) {
            session.setPassword(ftpPassword);
        }
        session.connect(30000);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftp = (ChannelSftp)channel;
        this.logger.info("Connected to " + host + ".");
        return sftp;
    }

    private String getFtpCert() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("ftp_cert_path", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            return null;
        }
        CipherInfo cipherInfo = this.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return this.getKey(fileContent);
    }

    private CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }

    private String getFtpCertPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        String storageRootPath = System.getProperty("user.dir");
        this.checkAndCreatePath(storageRootPath + File.separator + "cert" + File.separator + customID);
        return storageRootPath + File.separator + "cert" + File.separator + customID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean uploadToBankBySFTP(ChannelSftp channelSftp, String overseaAttachmentPath, String fileName, String uploadDirectory) {
        try {
            channelSftp.cd(uploadDirectory);
            try (FileInputStream fis = new FileInputStream(overseaAttachmentPath + File.separator + fileName);){
                try {
                    channelSftp.put((InputStream)fis, fileName);
                    this.logger.info(String.format("\u4e0a\u4f20\u6587\u4ef6%s\u6210\u529f!", fileName));
                }
                catch (Exception e) {
                    this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                    boolean bl2 = false;
                    if (fis == null) return bl2;
                    if (throwable == null) {
                        fis.close();
                        return bl2;
                    }
                    try {
                        fis.close();
                        return bl2;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return bl2;
                    }
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.logger.error("\u627e\u4e0d\u5230\u5f85\u4e0a\u4f20\u6587\u4ef6" + overseaAttachmentPath, (Throwable)e);
            return false;
        }
        catch (SftpException e) {
            this.logger.error("SFTP\u4e0a\u4f20\u5f02\u5e38\u3002", (Throwable)e);
            return false;
        }
    }

    protected void prepareAttachment(List<PayAttachment> attachments) {
        boolean isUseOpenApi = OpenApiUtil.isUseOpenApi();
        attachments.forEach(payAttachment -> {
            String fileName = payAttachment.getFileName();
            String overseaAttachmentPath = this.getOverseaAttachmentPath(payAttachment.getBankVersionID());
            File file = FileCommonUtils.getFileByPath((String)overseaAttachmentPath, (String)fileName);
            if (!file.exists()) {
                this.downloadFileFromFileServer((PayAttachment)payAttachment, isUseOpenApi);
            }
        });
    }

    protected String getOverseaAttachmentPath(String bankVersionID) {
        return this.getPath(this.getStorageRootPath(), "attachment", bankVersionID);
    }

    private String getStorageRootPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        this.checkAndCreatePath(File.separator + "oversea" + File.separator + customID);
        return File.separator + "oversea" + File.separator + customID;
    }

    private String getPath(String rootPath, String path, String bankVersionID) {
        StringBuilder sb = new StringBuilder();
        sb.append(rootPath).append(File.separator).append(bankVersionID).append(File.separator).append(path);
        String fixedPath = sb.toString();
        this.checkAndCreatePath(fixedPath);
        return fixedPath;
    }

    private void checkAndCreatePath(String path) {
        File file = FileCommonUtils.getFileByPath((String)path);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception var3) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8def\u5f84: %s\u53d1\u751f\u5f02\u5e38\u3002", (String)"AbstractAttachmentImpl_10", (String)"ebg-aqap-business", (Object[])new Object[0]), path), (Throwable)var3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String uploadToBankByHttp(String requestUrl, String localFilePath, String fileName, String binaryBodyName, Map<String, String> body) {
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)requestUrl);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(requestUrl);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody(binaryBodyName, FileUtils.getFile((String[])new String[]{localFilePath + File.separator + fileName}), ContentType.MULTIPART_FORM_DATA, fileName);
            ContentType contentType = ContentType.create((String)"multipart/form-data", (Charset)Charset.forName("UTF-8"));
            for (Map.Entry<String, String> entry : body.entrySet()) {
                builder.addTextBody(entry.getKey(), entry.getValue(), contentType);
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity responseEntity = response.getEntity();
                String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
                this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u54cd\u5e94\u62a5\u6587\uff1a" + responseStr);
                String string = responseStr;
                return string;
            }
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + statusCode);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56dehttp\u72b6\u6001\u7801%s", (String)"AbstractAttachmentImpl_3", (String)"ebg-aqap-business", (Object[])new Object[0]), statusCode));
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"AbstractAttachmentImpl_4", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String uploadToBankByHttp(String requestUrl, byte[] fileByte, String fileName, String binaryBodyName, Map<String, String> body) {
        this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)requestUrl);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(requestUrl);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody(binaryBodyName, fileByte, ContentType.MULTIPART_FORM_DATA, fileName);
            ContentType contentType = ContentType.create((String)"multipart/form-data", (Charset)Charset.forName("UTF-8"));
            for (Map.Entry<String, String> entry : body.entrySet()) {
                builder.addTextBody(entry.getKey(), entry.getValue(), contentType);
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity responseEntity = response.getEntity();
                String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
                this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u54cd\u5e94\u62a5\u6587\uff1a" + responseStr);
                String string = responseStr;
                return string;
            }
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + statusCode);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56dehttp\u72b6\u6001\u7801%s", (String)"AbstractAttachmentImpl_3", (String)"ebg-aqap-business", (Object[])new Object[0]), statusCode));
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"AbstractAttachmentImpl_4", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private void downloadFileFromFileServer(PayAttachment payAttachment, boolean isUseOpenApi) {
        String path = payAttachment.getFilePath();
        String fileName = payAttachment.getFileName();
        String overseaAttachmentPath = this.getOverseaAttachmentPath(payAttachment.getBankVersionID());
        if (isUseOpenApi) {
            try {
                String customID = EBContext.getContext().getCustomID();
                String accessToken = this.getAccessToken(customID, this.getAppToken(customID));
                StringBuilder requestUrlBuilder = new StringBuilder();
                requestUrlBuilder.append(payAttachment.getDownloadUrl());
                requestUrlBuilder.append("&access_token=");
                requestUrlBuilder.append(accessToken);
                this.logger.info("openapi\u4e0b\u8f7d\u9644\u4ef6\u8bf7\u6c42url\uff1a{}", (Object)requestUrlBuilder.toString());
                OpenApiUtil.download(requestUrlBuilder.toString(), fileName, overseaAttachmentPath);
                this.logger.info("openapi\u4e0b\u8f7d\u9644\u4ef6\u6210\u529f,\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84:" + overseaAttachmentPath + File.separator + fileName);
            }
            catch (Throwable e) {
                this.logger.error("\u901a\u8fc7openapi\u4e0b\u8f7d\u9644\u4ef6\u5f02\u5e38", e);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u901a\u8fc7openapi\u4e0b\u8f7d\u9644\u4ef6\u5f02\u5e38%s", (String)"AbstractAttachmentImpl_5", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String orignalPath = path;
        if (!path.contains(".")) {
            orignalPath = fs.getFileServiceExt().getRealPath(path);
            this.logger.info(String.format("\u9644\u4ef6\u8def\u5f84%s\u662f\u52a0\u5bc6\u7684\uff0c\u8f6c\u6362\u540e\u83b7\u5f97\u539f\u59cb\u8def\u5f84\uff1a%s", path, orignalPath));
            fileName = orignalPath.substring(orignalPath.lastIndexOf("/") + 1);
            payAttachment.setFilePath(orignalPath);
            payAttachment.setFileName(fileName);
        }
        try (FileOutputStream out = new FileOutputStream(overseaAttachmentPath + File.separator + fileName);){
            fs.download(orignalPath, (OutputStream)out, "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36");
            this.logger.info("\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84" + overseaAttachmentPath + File.separator + fileName);
        }
        catch (Throwable e) {
            this.logger.error("\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u901a\u8fc7\u5fae\u670d\u52a1\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38%s", (String)"AbstractAttachmentImpl_6", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private String getAppToken(String customNo) {
        String appToken;
        block20: {
            String appTokenKey = customNo + "_aqap_app_token";
            try {
                appToken = CosmicCache.get((String)appTokenKey);
                this.logger.info("\u4eceredis\u83b7\u5f97\u7684apptoken\uff1a" + appToken);
                if (!StringUtils.isEmpty((String)appToken)) break block20;
                this.logger.info("\u9700\u8981\u53d1\u8bf7\u6c42\u83b7\u53d6apptoken");
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    HttpPost httpPost = new HttpPost(OpenApiUtil.getAppTokenUrlFromCosmic());
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("appId", (Object)OpenApiUtil.getAppIdCangqiong());
                    jsonObject.put("appSecuret", (Object)OpenApiUtil.getAppSecuretCangqiong());
                    String accountId = OpenApiUtil.getCosmicAccountId();
                    if (Objects.nonNull(accountId)) {
                        jsonObject.put("accountId", (Object)accountId);
                    } else {
                        jsonObject.put("accountId", (Object)RequestContext.get().getAccountId());
                    }
                    StringEntity entity = new StringEntity(jsonObject.toString());
                    entity.setContentEncoding("utf-8");
                    entity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)entity);
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AppToken-\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonObject.toJSONString());
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AppToken\uff1a" + httpPost.getURI());
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    this.logger.info("\u83b7\u53d6AppToken\u54cd\u5e94\u62a5\u6587\uff1a" + result);
                    JSONObject responseJson = JSONObject.parseObject((String)result);
                    JSONObject data = (JSONObject)responseJson.get((Object)"data");
                    if (data != null) {
                        appToken = data.get((Object)"app_token").toString();
                        CosmicCache.putIfAbsentWithExpire((String)appTokenKey, (String)appToken, (int)60, (TimeUnit)TimeUnit.MINUTES);
                        if (StringUtils.isEmpty((String)appToken)) {
                            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6apptoken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"AbstractAttachmentImpl_1", (String)"ebg-aqap-business", (Object[])new Object[0]), result));
                        }
                        break block20;
                    }
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587\u6ca1data\u6570\u636e %s\u3002", (String)"AbstractAttachmentImpl_2", (String)"ebg-aqap-business", (Object[])new Object[0]), responseJson));
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6apptoken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6apptoken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"AbstractAttachmentImpl_1", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6apptoken\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return appToken;
    }

    private String getAccessToken(String customNo, String appToken) {
        String accessToken;
        block21: {
            if (StringUtils.isEmpty((String)appToken)) {
                this.getAppToken(customNo);
            }
            String accessTokenKey = customNo + "_aqap_access_token";
            try {
                accessToken = CosmicCache.get((String)accessTokenKey);
                this.logger.info("\u4eceredis\u83b7\u5f97\u7684accessToken\uff1a" + accessToken);
                if (!StringUtils.isEmpty((String)accessToken)) break block21;
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    HttpPost httpPost = new HttpPost(OpenApiUtil.getAccessTokenUrlCangqiong());
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("user", OpenApiUtil.getUserCangqiong());
                    jsonObject.put("apptoken", (Object)appToken);
                    String accountId = OpenApiUtil.getCosmicAccountId();
                    if (Objects.nonNull(accountId)) {
                        jsonObject.put("accountId", (Object)accountId);
                    } else {
                        jsonObject.put("accountId", (Object)RequestContext.get().getAccountId());
                    }
                    StringEntity entity = new StringEntity(jsonObject.toString());
                    entity.setContentEncoding("utf-8");
                    entity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)entity);
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AccessToken-\u8bf7\u6c42\u62a5\u6587\uff1a" + jsonObject.toJSONString());
                    this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AccessToken\uff1a" + httpPost.getURI());
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    this.logger.info("\u83b7\u53d6AccessToken\u54cd\u5e94\u62a5\u6587\uff1a" + result);
                    JSONObject responseJson = JSONObject.parseObject((String)result);
                    JSONObject data = (JSONObject)responseJson.get((Object)"data");
                    if (data != null) {
                        accessToken = data.get((Object)"access_token").toString();
                        CosmicCache.putIfAbsentWithExpire((String)accessTokenKey, (String)accessToken, (int)1800, (TimeUnit)TimeUnit.SECONDS);
                        if (StringUtils.isEmpty((String)accessToken)) {
                            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6apptoken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"AbstractAttachmentImpl_1", (String)"ebg-aqap-business", (Object[])new Object[0]), result));
                        }
                        break block21;
                    }
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587\u6ca1data\u6570\u636e %s\u3002", (String)"AbstractAttachmentImpl_2", (String)"ebg-aqap-business", (Object[])new Object[0]), result));
                }
                catch (Exception e) {
                    this.logger.error("getAccessToken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6apptoken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"AbstractAttachmentImpl_1", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6accesstoken\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return accessToken;
    }

    protected void setUploadStatus(PayAttachment payAttachment, AttachmentState attachmentState, String bankStatus, String bankMsg) {
        payAttachment.setStatus(Integer.valueOf(attachmentState.getId()));
        payAttachment.setStatusName(attachmentState.getEnName());
        payAttachment.setStatusMsg(attachmentState.getCnName());
        payAttachment.setBankStatus(bankStatus);
        payAttachment.setBankMsg(bankMsg);
    }

    protected void setUploadStatus(List<PayAttachment> payAttachments, AttachmentState attachmentState, String bankStatus, String bankMsg) {
        payAttachments.forEach(payAttachment -> {
            payAttachment.setStatus(Integer.valueOf(attachmentState.getId()));
            payAttachment.setStatusName(attachmentState.getEnName());
            payAttachment.setStatusMsg(attachmentState.getCnName());
            payAttachment.setBankStatus(bankStatus);
            payAttachment.setBankMsg(bankMsg);
        });
    }

    /*
     * Exception decompiling
     */
    protected String sendAndRecvMsg(String rqstStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

