/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing.util;

import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.Callable;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankFinancingTask;
import kd.ebg.aqap.business.payment.task.BankQueryFinancingTask;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import net.sf.json.JSONObject;

public class FinancingUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FinancingUtil.class);

    public static void async(List<FinancingInfo> infos, BankFinancingRequest request) {
        FinancingInfo info = infos.get(0);
        String bankVersion = info.getBankVersionID();
        String customId = info.getCustomId();
        String batchSeqId = info.getBatchSeqId();
        String bankLoginId = info.getBankLoginID();
        String requestSeqId = String.valueOf(request.getHeader().getRequestSeqID());
        String bizType = request.getHeader().getBizType();
        String subBizType = request.getHeader().getSubBizType();
        logger.info("\u94f6\u884c\u4fe1\u606f, accNo\u4e3a{}", (Object)info.getAccNo());
        logger.info("\u94f6\u884c\u7248\u672c\u4fe1\u606f, bankLoginId\u4e3a{}", (Object)bankLoginId);
        EBContext ebContext = EBContext.getContext();
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID(requestSeqId).bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(info.getBankLoginID()).logRequestSeqID(ebContext.getLogRequestSeqID()).logBizSeqID(ebContext.getLogBizSeqID()).loggerBatchNo(ebContext.getLogger_batch_no()).loggerDetailNo(infos.get(0).getBankBatchSeqId()).loggerBankNo(ebContext.getLogger_bank_no()).build();
        context.setBankAcnt(request.getHeader().getAcnt());
        EBThreadPools.getFinancingThreadPool(customId, bankLoginId).submit((Callable)((Object)new BankFinancingTask(request, context)));
    }

    public static void asyncQuery(List<FinancingInfo> infos, BankFinancingRequest request) {
        String extDate = request.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        FinancingInfo info = infos.get(0);
        String bankVersion = info.getBankVersionID();
        String customId = info.getCustomId();
        String batchSeqId = info.getBatchSeqId();
        String bankLoginId = info.getBankLoginID();
        String requestSeqId = String.valueOf(request.getHeader().getRequestSeqID());
        String bizType = request.getHeader().getBizType();
        String subBizType = request.getHeader().getSubBizType();
        logger.info("\u94f6\u884c\u4fe1\u606f, accNo\u4e3a{}", (Object)info.getAccNo());
        logger.info("\u94f6\u884c\u7248\u672c\u4fe1\u606f, bankLoginId\u4e3a{}", (Object)bankLoginId);
        logger.info("BankBatchSeqId", (Object)infos.get(0).getBankBatchSeqId());
        EBContext ebContext = EBContext.getContext();
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID(requestSeqId).bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(info.getBankLoginID()).logRequestSeqID(ebContext.getLogRequestSeqID()).logBizSeqID(ebContext.getLogBizSeqID()).loggerBatchNo(batchSeqId).loggerDetailNo(infos.get(0).getBankBatchSeqId()).loggerBankNo(loggerBankNo).build();
        context.setBankAcnt(request.getHeader().getAcnt());
        EBThreadPools.getQueryFinancingThreadPool(customId, bankLoginId).submit((Callable)((Object)new BankQueryFinancingTask(request, context)));
    }

    public static void setState(List<FinancingInfo> FinancingInfos, FinancingState state, String errorMsg, String bankStatus, String bankMsg) {
        for (FinancingInfo info : FinancingInfos) {
            FinancingUtil.setState(info, state, errorMsg, bankStatus, bankMsg);
            FinancingUtil.setUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setState(FinancingInfo info, FinancingState state, String errorMsg, String bankStatus, String bankMsg) {
        String Lsignal = "<Check>";
        String Rsignal = "</Check>";
        String check = "";
        info.setStatus(Integer.valueOf(state.getId()));
        info.setStatusName(state.getEnName());
        info.setStatusMsg(state.getCnName());
        if (StrUtil.isBlank((CharSequence)errorMsg)) {
            errorMsg = state.getCnName();
        } else if (errorMsg.contains(Lsignal)) {
            int left = errorMsg.indexOf(Lsignal);
            int right = errorMsg.indexOf(Rsignal);
            check = errorMsg.substring(left + Lsignal.length(), right);
        }
        if (errorMsg.length() > 250) {
            info.setErrorMsg(errorMsg.substring(0, 246) + "...");
        } else {
            info.setErrorMsg(errorMsg);
        }
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            info.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
            info.setBankMsg(bankMsg);
        }
        if (StrUtil.isNotBlank((CharSequence)check)) {
            info.setStatusMsg(state.getCnName() + "," + check);
        }
    }

    public static void setUpdateTimeAndStatus(FinancingInfo info, LocalDateTime updateTime) {
        info.setUpdateTime(updateTime);
    }
}

