/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.junit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.unittest.AbstractJunitNoDependenciesTest;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.junit.BaseBizParam;
import kd.ebg.aqap.business.junit.InitPaymentUnitTest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ClassPathFileUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.EBBankResponse;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.framework.conf.ParameterImpl;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.lang.ObjectUtils;
import org.jdom2.Element;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEBGJunitTest
extends AbstractJunitNoDependenciesTest {
    private Logger logger = LoggerFactory.getLogger(AbstractEBGJunitTest.class);
    private MockedStatic<kd.ebg.aqap.common.core.utils.Sequence> sequenceMockedStatic;
    private MockedStatic<ResManager> resManagerMockedStatic;
    private MockedStatic<kd.ebg.egf.common.framework.frame.Sequence> sequenceStatic;
    private MockedStatic<Sequence> sequenceStatic1;
    private MockedStatic<MatchRule> matchRuleMockedStatic;
    MockedStatic<CurrencyUtils> currencyUtilsMockedStatic;

    public abstract String getBankVersion();

    public abstract String getBankLogin();

    @Before
    public void init() {
        this.sequenceMockedStatic = Mockito.mockStatic(kd.ebg.aqap.common.core.utils.Sequence.class);
        this.sequenceMockedStatic.when(kd.ebg.aqap.common.core.utils.Sequence::gen18Sequence).thenReturn((Object)"121342131213421363");
        this.sequenceMockedStatic.when(kd.ebg.aqap.common.core.utils.Sequence::gen8Sequence).thenReturn((Object)"33134213");
        this.sequenceMockedStatic.when(kd.ebg.aqap.common.core.utils.Sequence::genSequence).thenReturn((Object)"3313421311");
        this.sequenceMockedStatic.when(kd.ebg.aqap.common.core.utils.Sequence::gen14Sequence).thenReturn((Object)"3313421311333");
        this.sequenceMockedStatic.when(kd.ebg.aqap.common.core.utils.Sequence::gen16Sequence).thenReturn((Object)"3313421311333222");
        this.sequenceStatic = Mockito.mockStatic(kd.ebg.egf.common.framework.frame.Sequence.class);
        this.sequenceStatic.when(kd.ebg.egf.common.framework.frame.Sequence::gen18Sequence).thenReturn((Object)"121342131213421363");
        this.sequenceStatic.when(kd.ebg.egf.common.framework.frame.Sequence::gen8Sequence).thenReturn((Object)"33134213");
        this.sequenceStatic.when(kd.ebg.egf.common.framework.frame.Sequence::genSequence).thenReturn((Object)"3313421311");
        this.sequenceStatic.when(kd.ebg.egf.common.framework.frame.Sequence::gen14Sequence).thenReturn((Object)"3313421311333");
        this.sequenceStatic.when(kd.ebg.egf.common.framework.frame.Sequence::gen16Sequence).thenReturn((Object)"3313421311333222");
        this.sequenceStatic.when(kd.ebg.egf.common.framework.frame.Sequence::genSequence).thenReturn((Object)"3313421311333222");
        this.sequenceStatic1 = Mockito.mockStatic(Sequence.class);
        this.sequenceStatic1.when(Sequence::gen18Sequence).thenReturn((Object)"121342131213421363");
        this.sequenceStatic1.when(Sequence::gen8Sequence).thenReturn((Object)"33134213");
        this.sequenceStatic1.when(Sequence::genSequence).thenReturn((Object)"3313421311");
        this.sequenceStatic1.when(Sequence::gen14Sequence).thenReturn((Object)"3313421311333");
        this.sequenceStatic1.when(Sequence::gen16Sequence).thenReturn((Object)"3313421311333222");
        this.sequenceStatic1.when(Sequence::genSequence).thenReturn((Object)"3313421311333222");
        this.resManagerMockedStatic = Mockito.mockStatic(ResManager.class);
        ArgumentCaptor sac1 = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor sac2 = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor sac3 = ArgumentCaptor.forClass(String.class);
        this.resManagerMockedStatic.when(() -> ResManager.loadKDString((String)((String)sac1.capture()), (String)((String)sac2.capture()), (String)((String)sac3.capture()), (Object[])new Object[0])).thenAnswer(invocationOnMock -> (String)invocationOnMock.getArgument(0, String.class));
        this.matchRuleMockedStatic = Mockito.mockStatic(MatchRule.class);
        MatchRule matchRule = (MatchRule)Mockito.mock(MatchRule.class);
        Mockito.when((Object)MatchRule.getInstance()).thenReturn((Object)matchRule);
        Mockito.when((Object)matchRule.getReceiptNo(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)"123");
        Mockito.when((Object)matchRule.getDetailJsonWithStructuredData((Element)Mockito.any())).thenCallRealMethod();
        this.currencyUtilsMockedStatic = Mockito.mockStatic(CurrencyUtils.class);
        this.currencyUtilsMockedStatic.when(() -> CurrencyUtils.isISOCurrency((String)((String)ArgumentMatchers.any()))).thenReturn((Object)true);
        this.currencyUtilsMockedStatic.when(() -> CurrencyUtils.convert2Iso((String)Mockito.anyString())).thenReturn((Object)"CNY");
        this.currencyUtilsMockedStatic.when(() -> CurrencyUtils.convert2Bank((String)Mockito.anyString(), (String)Mockito.anyString(), (String)Mockito.anyString())).thenReturn((Object)"CNY");
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID("tenant_devfi_dev").logRequestSeqID("123").bizName("bizName").subBizName("subBizName").logBizSeqID("234").bizSeqID(kd.ebg.aqap.common.core.utils.Sequence.gen18Sequence()).requestSeqID(kd.ebg.aqap.common.core.utils.Sequence.genSequence()).bankVersionID(this.getBankVersion()).bankLoginID(this.getBankLogin()).build();
        context.setUnitTest(true);
        ParameterImpl parameter = new ParameterImpl();
        parameter.setBankParameter("exchangeProtocol", "HTTP");
        parameter.setBankParameter("signProtocol", "HTTP");
        parameter.setBankParameter("front_proxy_port", "8888");
        parameter.setBankParameter("frontProxyProtocol", "HTTP");
        parameter.setBankParameter("frontProxy_Port", "8888");
        parameter.setBankParameter("charset", "UTF-8");
        context.setParameter((IParameter)parameter);
        context.setCharsetName("UTF-8");
        EBContext.setContext((EBContext)context);
    }

    @After
    public void close() {
        if (this.sequenceMockedStatic != null) {
            this.sequenceMockedStatic.close();
        }
        if (this.resManagerMockedStatic != null) {
            this.resManagerMockedStatic.close();
        }
        if (this.sequenceStatic != null) {
            this.sequenceStatic.close();
        }
        if (this.matchRuleMockedStatic != null) {
            this.matchRuleMockedStatic.close();
        }
        if (this.currencyUtilsMockedStatic != null) {
            this.currencyUtilsMockedStatic.close();
        }
        if (this.sequenceStatic1 != null) {
            this.sequenceStatic1.close();
        }
    }

    public void beginTest(String className) {
        this.beginTest(className, "", "", "");
    }

    public void beginTest(String className, String rspFileName, String srcContent, String rspReplace) {
        HashMap<String, Method> emptyParamMethod = new HashMap<String, Method>(5);
        HashMap<String, Method> packParseMethod = new HashMap<String, Method>(2);
        HashMap<String, Method> otherMethod = new HashMap<String, Method>(5);
        try {
            Class<?> aClass = Class.forName(className);
            Object o = aClass.newInstance();
            Method[] declaredMethods = aClass.getDeclaredMethods();
            for (Method method : declaredMethods) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length == 0) {
                    emptyParamMethod.put(method.getName(), method);
                    continue;
                }
                if (method.getName().equalsIgnoreCase("pack") || method.getName().equalsIgnoreCase("parse")) {
                    packParseMethod.put(method.getName(), method);
                    continue;
                }
                otherMethod.put(method.getName(), method);
            }
            if (!emptyParamMethod.isEmpty()) {
                for (Map.Entry entry : emptyParamMethod.entrySet()) {
                    Method method = (Method)entry.getValue();
                    ReflectionUtils.makeAccessible((Method)method);
                    method.invoke(o, new Object[0]);
                }
            }
            if (!otherMethod.isEmpty()) {
                for (Map.Entry entry : otherMethod.entrySet()) {
                    Method method = (Method)entry.getValue();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    Object[] params = new Object[parameterTypes.length];
                    boolean skip = false;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        Class<?> parameterType = parameterTypes[i];
                        if (Modifier.isAbstract(parameterType.getModifiers()) || Modifier.isInterface(parameterType.getModifiers())) {
                            skip = true;
                            continue;
                        }
                        if (parameterType.getName().equalsIgnoreCase("java.lang.Object")) {
                            skip = true;
                            continue;
                        }
                        if (parameterType.getName().equalsIgnoreCase("kd.ebg.aqap.common.model.PaymentInfo") || "org.jdom2.Element".equalsIgnoreCase(parameterType.getName())) {
                            skip = true;
                            continue;
                        }
                        params[i] = AbstractEBGJunitTest.initBean(parameterType);
                    }
                    if (skip) continue;
                    ReflectionUtils.makeAccessible((Method)method);
                    try {
                        method.invoke(o, params);
                    }
                    catch (Throwable t) {
                        this.logger.error("", t.getCause());
                    }
                }
            }
            if (!packParseMethod.isEmpty()) {
                for (Map.Entry entry : packParseMethod.entrySet()) {
                    Class<?> parameterType;
                    Method method = (Method)entry.getValue();
                    ReflectionUtils.makeAccessible((Method)method);
                    if ("pack".equalsIgnoreCase((String)entry.getKey())) {
                        parameterType = method.getParameterTypes()[0];
                        String invoke = (String)method.invoke(o, this.getRequest(parameterType));
                        Assert.assertNotNull((Object)invoke);
                        continue;
                    }
                    if (!"parse".equalsIgnoreCase((String)entry.getKey())) continue;
                    parameterType = method.getParameterTypes()[0];
                    String charsetName = EBContext.getContext().getCharsetName();
                    String content = StringUtils.isEmpty((String)charsetName) ? ClassPathFileUtil.readFile((String)rspFileName) : ClassPathFileUtil.readFile((String)rspFileName, (String)charsetName);
                    if (StringUtils.isNotEmpty((String)rspReplace) && StringUtils.isNotEmpty((String)content)) {
                        content = content.replaceAll(srcContent, rspReplace);
                    }
                    EBBankResponse ebBankResponse = (EBBankResponse)method.invoke(o, this.getRequest(parameterType), content);
                    this.verifyResponse(ebBankResponse);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("", e.getCause());
        }
        catch (IllegalAccessException e) {
            this.logger.error("", e.getCause());
        }
        catch (InstantiationException e) {
            this.logger.error("", e.getCause());
        }
        catch (InvocationTargetException e) {
            this.logger.error("", e.getCause());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("", e.getCause());
        }
    }

    public void beginTest(String className, String rspFileName) {
        this.beginTest(className, rspFileName, "", "");
    }

    public void beginTestRoute(String className, String metaClassName, String routeFileName) {
        try {
            String routeContent = ClassPathFileUtil.readFile((String)routeFileName);
            JSONArray objects = JSON.parseArray((String)routeContent);
            Class<?> metaClass = Class.forName(metaClassName);
            Method getBizImplClassesMethod = metaClass.getDeclaredMethod("getBizImplClasses", new Class[0]);
            Object instance = metaClass.newInstance();
            List bizImplClasses = (List)getBizImplClassesMethod.invoke(instance, new Object[0]);
            ArrayList classList = new ArrayList(bizImplClasses.size());
            bizImplClasses.forEach(bizClass -> classList.add(bizClass.getName()));
            boolean pass = true;
            for (int i = 0; i < objects.size(); ++i) {
                JSONObject jsonObject = objects.getJSONObject(i);
                String bank_version = jsonObject.getString("bank_version");
                String sub_biz_type = jsonObject.getString("sub_biz_type");
                String individual = jsonObject.getString("individual");
                String use_cn = jsonObject.getString("use_cn");
                String same_bank = jsonObject.getString("same_bank");
                String single = jsonObject.getString("single");
                String merge = jsonObject.getString("merge");
                String urgent = jsonObject.getString("urgent");
                String busconf = jsonObject.getString("busconf");
                String impl = jsonObject.getString("impl");
                String amount = jsonObject.getString("amount");
                PaymentInfo paymentInfo = new PaymentInfo();
                paymentInfo.setSubBizType(sub_biz_type);
                paymentInfo.setBankVersionID(bank_version);
                paymentInfo.setUseCode("-1");
                paymentInfo.setIndividual(Boolean.valueOf(Boolean.parseBoolean(individual)));
                paymentInfo.setSameBank(Boolean.valueOf(Boolean.parseBoolean(same_bank)));
                paymentInfo.setMerge(Boolean.valueOf(Boolean.parseBoolean(merge)));
                paymentInfo.setUrgent(Boolean.valueOf(Boolean.parseBoolean(urgent)));
                if (StringUtils.isNotEmpty((String)amount)) {
                    paymentInfo.setAmount(new BigDecimal(amount));
                }
                if (StringUtils.isNotEmpty((String)use_cn)) {
                    use_cn = use_cn.split("/")[0];
                }
                paymentInfo.setUseCN(use_cn);
                InitPaymentUnitTest.getInstance().updatePaymentInfoSysFiled(paymentInfo);
                JSONObject object = JSON.parseObject((String)busconf);
                MockedStatic globalPropertyConfigMockedStatic = Mockito.mockStatic(GlobalPropertyConfig.class);
                GlobalPropertyConfig mock = (GlobalPropertyConfig)Mockito.mock(GlobalPropertyConfig.class);
                Mockito.when((Object)GlobalPropertyConfig.getInstance()).thenReturn((Object)mock);
                ArgumentCaptor sac1 = ArgumentCaptor.forClass(PropertyConfigItem.class);
                Mockito.when((Object)mock.getConfigValue((PropertyConfigItem)sac1.capture())).then(invocationOnMock -> {
                    PropertyConfigItem propertyConfigItem = (PropertyConfigItem)invocationOnMock.getArgument(0);
                    String key = propertyConfigItem.getKey();
                    if (object != null) {
                        Set sets = object.keySet();
                        for (String set : sets) {
                            if (!StringUtils.equalsIgnoreCase((String)set, (String)key)) continue;
                            return object.getString(key);
                        }
                    }
                    return "false";
                });
                Class<?> aClass = Class.forName(className);
                Object o = aClass.newInstance();
                Method method = aClass.getDeclaredMethod("appendData", PaymentInfo.class);
                method.invoke(o, paymentInfo);
                globalPropertyConfigMockedStatic.close();
                try {
                    AbstractJunitNoDependenciesTest.assertEquals((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531\u56fe\u4e0e\u4ee3\u7801\u8def\u7531\u4e0d\u5339\u914d,\u5bf9\u5e94\u8def\u7531\u56fe:%1$s", (String)"AbstractEBGJunitTest_0", (String)"ebg-aqap-business", (Object[])new Object[0]), jsonObject), (String)impl, (String)paymentInfo.getImplClassName());
                }
                catch (Throwable e) {
                    this.logger.error("", e);
                    pass = false;
                }
                try {
                    AbstractJunitNoDependenciesTest.assertTrue((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5b9e\u73b0\u7c7b%1$s\u5728\u5143\u6570\u636e\u4e2d\u672a\u52a0\u8f7d", (String)"AbstractEBGJunitTest_1", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getImplClassName()), (boolean)classList.contains(paymentInfo.getImplClassName()));
                    continue;
                }
                catch (Throwable e) {
                    this.logger.error("", e);
                    pass = false;
                }
            }
            if (!pass) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531\u6d4b\u8bd5\u672a\u901a\u8fc7", (String)"AbstractEBGJunitTest_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
        catch (IOException e) {
            this.logger.error("", e.getCause());
        }
        catch (IllegalAccessException e) {
            this.logger.error("", e.getCause());
        }
        catch (InstantiationException e) {
            this.logger.error("", e.getCause());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("", e.getCause());
        }
        catch (NoSuchMethodException e) {
            this.logger.error("", e.getCause());
        }
        catch (InvocationTargetException e) {
            this.logger.error("", e.getCause());
        }
    }

    public static <T> T initBean(Class<T> requiredType) throws IllegalAccessException, InstantiationException {
        if ("java.lang.Integer".equalsIgnoreCase(requiredType.getName())) {
            return (T)Integer.valueOf("1");
        }
        if ("java.lang.Long".equalsIgnoreCase(requiredType.getName())) {
            return (T)Long.valueOf("1");
        }
        if ("java.lang.Boolean".equalsIgnoreCase(requiredType.getName())) {
            return (T)Long.valueOf("1");
        }
        if ("java.time.LocalDateTime".equalsIgnoreCase(requiredType.getName())) {
            return (T)LocalDateTime.now();
        }
        if ("java.time.LocalDate".equalsIgnoreCase(requiredType.getName())) {
            return (T)LocalDate.now();
        }
        if ("java.math.BigDecimal".equalsIgnoreCase(requiredType.getName())) {
            return (T)new BigDecimal("10");
        }
        if ("java.lang.String".equalsIgnoreCase(requiredType.getName())) {
            return (T)"1";
        }
        T t = requiredType.newInstance();
        return t;
    }

    private void verifyResponse(EBBankResponse ebBankResponse) {
        if (ebBankResponse instanceof EBBankBalanceResponse) {
            this.verifyBalance((EBBankBalanceResponse)ebBankResponse);
        } else if (ebBankResponse instanceof EBBankDetailResponse) {
            this.verifyDetail((EBBankDetailResponse)ebBankResponse);
        } else if (ebBankResponse instanceof EBBankPayResponse) {
            this.verifyPay((EBBankPayResponse)ebBankResponse);
        }
    }

    private void verifyPay(EBBankPayResponse ebBankResponse) {
        Assert.assertNotNull((Object)((Object)ebBankResponse));
    }

    private void verifyDetail(EBBankDetailResponse ebBankDetailResponse) {
        Assert.assertNotNull((Object)((Object)ebBankDetailResponse));
        List<DetailInfo> details = ebBankDetailResponse.getDetails();
        details.forEach(detailInfo -> {
            Assert.assertNotNull((Object)detailInfo.getAccNo());
            Assert.assertNotNull((Object)detailInfo.getTransDate());
            Assert.assertNotNull((Object)detailInfo.getTransTime());
        });
    }

    private void verifyBalance(EBBankBalanceResponse balanceResponse) {
        Assert.assertNotNull((Object)((Object)balanceResponse));
        List<BalanceInfo> balances = balanceResponse.getBalances();
        balances.forEach(balanceInfo -> Assert.assertNotNull((Object)balanceInfo.getCurrentBalance()));
    }

    private <T> T getRequest(Class<T> parameterType) {
        if (parameterType.getName().contains("BankBalanceRequest")) {
            return (T)((Object)this.buildBalanceRequest());
        }
        if (parameterType.getName().contains("BankDetailRequest")) {
            return (T)((Object)this.buildDetailRequest());
        }
        if (parameterType.getName().contains("BankPayRequest")) {
            return (T)((Object)this.buildPayRequest());
        }
        if (parameterType.getName().contains("BankBalanceReconciliationRequest")) {
            return (T)((Object)this.buildBankBalanceReconciliationRequest());
        }
        if (parameterType.getName().contains("BankBalanceStatementRequest")) {
            return (T)((Object)this.buildBankBalanceStatementRequest());
        }
        if (parameterType.getName().contains("BankCurAndFixedRequest")) {
            return (T)((Object)this.buildBankCurAndFixedRequest());
        }
        return (T)ObjectUtils.NULL;
    }

    private BankCurAndFixedRequest buildBankCurAndFixedRequest() {
        BankCurAndFixedRequest request = new BankCurAndFixedRequest();
        CurAndFixedInfo curAndFixedInfo = new CurAndFixedInfo();
        curAndFixedInfo.setPriceNo("");
        curAndFixedInfo.setNotifyId("");
        curAndFixedInfo.setBackStatus(Integer.valueOf(0));
        curAndFixedInfo.setBackStatusMsg("");
        curAndFixedInfo.setErrorMsg("");
        curAndFixedInfo.setBackErrorMsg("");
        curAndFixedInfo.setBankMsg("");
        curAndFixedInfo.setVersion(Integer.valueOf(0));
        curAndFixedInfo.setUpdateTime(LocalDateTime.now());
        curAndFixedInfo.setId("");
        curAndFixedInfo.setCustomId("");
        curAndFixedInfo.setBatchSeqId("aslkhdakjdi");
        curAndFixedInfo.setDetailSeqId("aslkhdakjdi");
        curAndFixedInfo.setDetailBizNo("aslkhdakjdi");
        curAndFixedInfo.setBackBankStatus("");
        curAndFixedInfo.setBankVersion("");
        curAndFixedInfo.setBankLoginId("");
        curAndFixedInfo.setSubBizType("");
        curAndFixedInfo.setImplClassName("");
        curAndFixedInfo.setFixedAccNo("");
        curAndFixedInfo.setInftyp("01");
        curAndFixedInfo.setAccBal("");
        curAndFixedInfo.setAmount("500000.00");
        curAndFixedInfo.setCurrency("");
        curAndFixedInfo.setExplanation("");
        curAndFixedInfo.setDrawType("");
        curAndFixedInfo.setDepositTermValue("3");
        curAndFixedInfo.setNextDepositType("");
        curAndFixedInfo.setNextDepositTermValue("");
        curAndFixedInfo.setTranDate(LocalDateTime.now());
        curAndFixedInfo.setTranTime(LocalDateTime.now());
        curAndFixedInfo.setOpenDate("");
        curAndFixedInfo.setCloseDate("");
        curAndFixedInfo.setRateDate("");
        curAndFixedInfo.setEndIntDate("");
        curAndFixedInfo.setEndDate("");
        curAndFixedInfo.setExpireOp("");
        curAndFixedInfo.setRate("");
        curAndFixedInfo.setFixInt("");
        curAndFixedInfo.setFixTaxInt("");
        curAndFixedInfo.setFixActInt("");
        curAndFixedInfo.setCloseInt("");
        curAndFixedInfo.setStatus(Integer.valueOf(CurAndFixedState.SUCCESS.getId()));
        curAndFixedInfo.setStatusMsg("");
        curAndFixedInfo.setStatusName("");
        curAndFixedInfo.setBankStatus("");
        curAndFixedInfo.setBankStatusMsg("");
        curAndFixedInfo.setInsertTime(LocalDateTime.now());
        curAndFixedInfo.setSubmitSuccessTime(LocalDateTime.now());
        curAndFixedInfo.setReserved1("");
        curAndFixedInfo.setReserved3("");
        curAndFixedInfo.setReserved4("");
        curAndFixedInfo.setReserved5("");
        curAndFixedInfo.setReqNbr("RYU|KEN");
        curAndFixedInfo.setFixedAcntBankNo("75");
        curAndFixedInfo.setFixedAccNo("13456");
        curAndFixedInfo.setFixedAccName("66");
        curAndFixedInfo.setFixedAcntBank("CMBC");
        curAndFixedInfo.setAccName("cc");
        curAndFixedInfo.setAcntBank("CMBC");
        curAndFixedInfo.setAccNo("1234");
        curAndFixedInfo.setAcntBankNo("666");
        curAndFixedInfo.setSyncCount("0");
        curAndFixedInfo.put("bsnJrnlNo", "RYU|KEN");
        ArrayList curAndFixedInfos = Lists.newArrayList((Object[])new CurAndFixedInfo[]{curAndFixedInfo});
        BankHeader header = new BankHeader();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAreaCode("75");
        bankAcnt.setAccNo("57712345");
        header.setAcnt(bankAcnt);
        request.setHeader(header);
        request.setBatchSeqId("aslkhdakjdi");
        request.setCafInfos(curAndFixedInfos);
        return request;
    }

    public BankBalanceStatementRequest buildBankBalanceStatementRequest() {
        BankBalanceStatementRequest bankBalanceStatementRequest = new BankBalanceStatementRequest();
        bankBalanceStatementRequest.setAccNo("2222222");
        bankBalanceStatementRequest.setCurrency("CNY");
        bankBalanceStatementRequest.setStartMonth("202403");
        bankBalanceStatementRequest.setEndMonth("202404");
        BankHeader bankHeader = new BankHeader();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo("121212");
        bankHeader.setAcnt(bankAcnt);
        bankBalanceStatementRequest.setHeader(bankHeader);
        return bankBalanceStatementRequest;
    }

    public BankBalanceReconciliationRequest buildBankBalanceReconciliationRequest() {
        BankBalanceReconciliationRequest bankBalanceReconciliationRequest = new BankBalanceReconciliationRequest();
        BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
        detail.setCurrency("CNY");
        detail.setBalance("20000.000");
        detail.setCheckStatus("Y");
        detail.setAccNo("22222223");
        bankBalanceReconciliationRequest.setDetail(detail);
        BankHeader bankHeader = new BankHeader();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo("121212");
        bankHeader.setAcnt(bankAcnt);
        bankBalanceReconciliationRequest.setHeader(bankHeader);
        return bankBalanceReconciliationRequest;
    }

    public BankPayRequest buildPayRequest() {
        BankPayRequest bankPayRequest = new BankPayRequest();
        PaymentInfo paymentInfo = new PaymentInfo();
        paymentInfo.setAmount(new BigDecimal("1500.00"));
        paymentInfo.setTotalAmount(new BigDecimal("1500.00"));
        paymentInfo.setBatchSeqID(kd.ebg.aqap.common.core.utils.Sequence.gen18Sequence());
        paymentInfo.setDetailSeqID(kd.ebg.aqap.common.core.utils.Sequence.gen18Sequence());
        String bankDetailSeqID = RequestContextUtils.getRunningParam((String)"bankDetailSeqID");
        String bankBatchSeqID = RequestContextUtils.getRunningParam((String)"bankBatchSeqID");
        String bankRefID = RequestContextUtils.getRunningParam((String)"bankRefID");
        paymentInfo.setBankRefID(bankRefID);
        paymentInfo.setBankDetailSeqID(StringUtils.isNotEmpty((String)bankDetailSeqID) ? bankDetailSeqID : kd.ebg.aqap.common.core.utils.Sequence.gen18Sequence());
        paymentInfo.setBankBatchSeqID(StringUtils.isNotEmpty((String)bankBatchSeqID) ? bankBatchSeqID : kd.ebg.aqap.common.core.utils.Sequence.gen18Sequence());
        paymentInfo.setIncomeAccName("test");
        paymentInfo.setIncomeAccNo("1234123");
        paymentInfo.setIncomeAddress("shenzhen");
        paymentInfo.setIncomeBankName("boc");
        paymentInfo.setSameBank(Boolean.valueOf(true));
        paymentInfo.setUrgent(Boolean.valueOf(true));
        paymentInfo.setForce(Boolean.valueOf(true));
        paymentInfo.setMerge(Boolean.valueOf(false));
        paymentInfo.setIndividual(Boolean.valueOf(true));
        paymentInfo.setSameCity(Boolean.valueOf(true));
        paymentInfo.setIncomeCity("shenzhen");
        paymentInfo.setIncomeProvince("guangdong");
        paymentInfo.setExplanation("explanation");
        paymentInfo.setAccNo("2517026009022100782");
        paymentInfo.setUseCode("-1");
        paymentInfo.setUseCN(ResManager.loadKDString((String)"\u4e1a\u52a1\u652f\u4ed8", (String)"AbstractEBGJunitTest_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        paymentInfo.setImplClassName("000");
        paymentInfo.setAccCountry("CHN");
        paymentInfo.setIncomeCountry("CHN");
        paymentInfo.setRequestTime(LocalDateTime.now());
        paymentInfo.setSubmitSuccessTime(LocalDateTime.now());
        paymentInfo.setActualAmount(new BigDecimal("1500.00"));
        InitPaymentUnitTest.getInstance().updatePaymentInfoSysFiled(paymentInfo);
        ArrayList paymentInfos = Lists.newArrayList((Object[])new PaymentInfo[]{paymentInfo});
        bankPayRequest.setPaymentInfos(paymentInfos);
        bankPayRequest.setTotalAmount(new BigDecimal("1500.00"));
        bankPayRequest.setBankBatchSeqID(kd.ebg.aqap.common.core.utils.Sequence.gen18Sequence());
        return bankPayRequest;
    }

    public BankBalanceRequest buildBalanceRequest() {
        BankBalanceRequest bankBalanceRequest = new BankBalanceRequest();
        BankHeader bankHeader = new BankHeader();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo("121212");
        bankHeader.setAcnt(bankAcnt);
        bankHeader.setBankVersionID(this.getBankVersion());
        bankHeader.setBankLoginID(this.getBankLogin());
        bankBalanceRequest.setStartDate(LocalDate.now());
        bankBalanceRequest.setEndDate(LocalDate.now());
        bankBalanceRequest.setHeader(bankHeader);
        bankBalanceRequest.setCurrency(BaseBizParam.getInstance().getBankCurrency());
        bankBalanceRequest.setBankAcntList(Lists.newArrayList((Object[])new BankAcnt[]{bankAcnt}));
        return bankBalanceRequest;
    }

    public BankDetailRequest buildDetailRequest() {
        BankDetailRequest request = new BankDetailRequest();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo("91098765437");
        acnt.setAccName("AccName");
        BankHeader header = new BankHeader();
        header.setBankVersionID(this.getBankVersion());
        header.setBankLoginID(this.getBankLogin());
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setBankCurrency("01");
        request.setStartDate(LocalDate.now());
        request.setEndDate(LocalDate.now());
        return request;
    }

    public void testEmpty(String className) {
        HashMap<String, Method> emptyParamMethod = new HashMap<String, Method>(5);
        try {
            Class<?> aClass = Class.forName(className);
            Object o = aClass.newInstance();
            Method[] declaredMethods = aClass.getDeclaredMethods();
            for (Method method : declaredMethods) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 0) continue;
                emptyParamMethod.put(method.getName(), method);
            }
            if (!emptyParamMethod.isEmpty()) {
                for (Map.Entry entry : emptyParamMethod.entrySet()) {
                    Method method = (Method)entry.getValue();
                    ReflectionUtils.makeAccessible((Method)method);
                    method.invoke(o, new Object[0]);
                }
            }
        }
        catch (IllegalAccessException e) {
            this.logger.error("", e.getCause());
        }
        catch (InstantiationException e) {
            this.logger.error("", e.getCause());
        }
        catch (InvocationTargetException e) {
            this.logger.error("", e.getCause());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("", e.getCause());
        }
    }
}

