/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.ebg.aqap.business.other.info.PropertyConfigInfo;
import kd.ebg.aqap.business.other.info.PropertyConfigItemInfo;
import kd.ebg.aqap.business.other.service.InfoService;
import kd.ebg.aqap.common.entity.biz.BankAccType;
import kd.ebg.aqap.common.entity.biz.listbanklogin.ListBankLoginRequest;
import kd.ebg.aqap.common.entity.biz.listbanklogin.ListBankLoginRequestBody;
import kd.ebg.aqap.common.entity.biz.listbanklogin.ListBankLoginResponse;
import kd.ebg.aqap.common.entity.biz.listbanklogin.ListBankLoginResponseBody;
import kd.ebg.aqap.common.entity.biz.listbanklogin.LoginDetail;
import kd.ebg.aqap.common.framework.frame.Bank;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.frame.BankVersion;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;

public class ListBankLoginMethod
implements EBServiceMethod<ListBankLoginRequest, ListBankLoginResponse> {
    public ListBankLoginResponse executeClientRequest(ListBankLoginRequest request, EBContext context) {
        ListBankLoginRequestBody body = request.getBody();
        String customId = context.getCustomID();
        String bankShortName = body.getBankShortName();
        String keyWords = body.getBankKeyWords();
        ListBankLoginResponse response = new ListBankLoginResponse();
        ListBankLoginResponseBody responseBody = new ListBankLoginResponseBody();
        response.setBody(responseBody);
        BankLoginService bankLoginService = BankLoginService.getInstance();
        List logins = bankLoginService.getByCustomId(customId);
        if (CollectionUtil.isNotEmpty((Collection)logins)) {
            logins = logins.stream().filter(l -> "1".equals(l.getEnable())).filter(l -> "0".equals(l.getConfigType())).collect(Collectors.toList());
        }
        if (StrUtil.isBlank((CharSequence)bankShortName) && StrUtil.isBlank((CharSequence)keyWords)) {
            responseBody.setDetails(ListBankLoginMethod.convert(logins));
        } else if (StrUtil.isNotBlank((CharSequence)bankShortName)) {
            List<BankLogin> filters = logins.stream().filter(l -> l.getBankVersionId() != null && l.getBankVersionId().contains(bankShortName)).collect(Collectors.toList());
            responseBody.setDetails(ListBankLoginMethod.convert(filters));
        } else {
            Collection banks = BankBundleManager.getInstance().getBanks();
            Bank selectedBank = null;
            block0: for (Bank bank : banks) {
                List bankKeyWords = bank.getBankNameKeyWords();
                for (int i = 0; i < bankKeyWords.size(); ++i) {
                    if (!keyWords.contains((CharSequence)bankKeyWords.get(i))) continue;
                    selectedBank = bank;
                    continue block0;
                }
            }
            if (selectedBank != null) {
                HashSet bankVersionIds = Sets.newHashSetWithExpectedSize((int)16);
                for (BankVersion version : selectedBank.getBankVersions()) {
                    bankVersionIds.add(version.getBankVersionID());
                }
                responseBody.setDetails(ListBankLoginMethod.convert(logins.stream().filter(l -> bankVersionIds.contains(l.getBankVersionId())).collect(Collectors.toList())));
            }
        }
        return response;
    }

    private static List<LoginDetail> convert(List<BankLogin> bankLogins) {
        if (Objects.nonNull(bankLogins) && bankLogins.size() > 0) {
            ArrayList<LoginDetail> details = new ArrayList<LoginDetail>(bankLogins.size());
            for (BankLogin login : bankLogins) {
                details.add(ListBankLoginMethod.convert(login));
            }
            return details;
        }
        return Collections.emptyList();
    }

    private static LoginDetail convert(BankLogin bankLogin) {
        LoginDetail detail = new LoginDetail();
        detail.setBankName(bankLogin.getBankName());
        detail.setBankVersionName(bankLogin.getBankVersionName());
        detail.setBankVersionID(bankLogin.getBankVersionId());
        detail.setLoginID(bankLogin.getKey().getBankLoginId());
        detail.setLoginAlias(bankLogin.getBankLoginAlias());
        detail.setBankShortName(BankBundleManager.getInstance().getBankShortName(bankLogin.getBankVersionId()));
        String bankLoginName = bankLogin.getBankLoginName() == null ? "" : bankLogin.getBankLoginName();
        detail.setDescription(String.format(ResManager.loadKDString((String)"%1$s-\u767b\u5f55\u7528\u6237-%2$s%3$s\u3002", (String)"ListBankLoginMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]), bankLogin.getBankVersionName(), bankLogin.getKey().getBankLoginId(), bankLoginName));
        List<BankAccType> bankAccTypes = ListBankLoginMethod.getBankAccTypes(bankLogin.getBankVersionId());
        detail.setBankAccTypes(bankAccTypes);
        return detail;
    }

    private static List<BankAccType> getBankAccTypes(String bankVersionId) {
        List bank_accType;
        InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
        PropertyConfigInfo bankAcntConfig = infoService.getBankAcntConfig(bankVersionId);
        ArrayList list = Lists.newArrayList();
        if (bankAcntConfig != null && CollectionUtil.isNotEmpty(bank_accType = bankAcntConfig.getConfigItems().stream().filter(configItemInfo -> configItemInfo.getKey().equalsIgnoreCase("bank_accType")).collect(Collectors.toList()))) {
            PropertyConfigItemInfo propertyConfigItemInfo = (PropertyConfigItemInfo)bank_accType.get(0);
            List<MultiLangEnumBridge> mlSourceNames = propertyConfigItemInfo.getMlSourceNames();
            List<String> sourceValues = propertyConfigItemInfo.getSourceValues();
            for (int i = 0; i < sourceValues.size(); ++i) {
                BankAccType bankAccType = new BankAccType();
                bankAccType.setType(sourceValues.get(i));
                bankAccType.setTypeName(mlSourceNames.get(i).getDescription());
                Lang lang = Lang.get();
                if (lang.getLangTag().equalsIgnoreCase("en-US")) {
                    bankAccType.setTypeName(sourceValues.get(i));
                }
                list.add(bankAccType);
            }
        }
        return list;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "listLogin";
    }
}

