/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.register.RegisterBody;
import kd.ebg.aqap.common.entity.biz.register.RegisterRequest;
import kd.ebg.aqap.common.entity.biz.register.RegisterResponse;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.model.tenant.TenantGroup;
import kd.ebg.egf.common.model.tenant.Tenants;
import kd.ebg.egf.common.repository.tenant.TenantRespository;
import kd.ebg.egf.common.repository.tenant.TenantsGroupRepository;
import kd.ebg.egf.common.utils.string.StringUtils;

public class RegisterMethod
implements EBServiceMethod<RegisterRequest, RegisterResponse> {
    private static final String BANK_FRAMEWORK_INFO_KEY = "eb_frameworkInfos";
    private TenantsGroupRepository tenantGroupRepository;
    private TenantRespository tenantRespository;

    public RegisterResponse executeClientRequest(RegisterRequest request, EBContext context) {
        RegisterResponse registerResponse;
        block6: {
            this.tenantGroupRepository = (TenantsGroupRepository)SpringContextUtil.getBean(TenantsGroupRepository.class);
            this.tenantRespository = (TenantRespository)SpringContextUtil.getBean(TenantRespository.class);
            registerResponse = new RegisterResponse();
            registerResponse.setHeader(request.getHeader());
            registerResponse.setErrorCode("success");
            registerResponse.setErrorMsg("");
            RegisterBody body = request.getBody();
            boolean modify = body.isModify();
            try {
                String customID = request.getHeader().getCustomId();
                Tenants tenant = this.tenantRespository.findByCustomNo(customID);
                if (tenant == null) {
                    tenant = new Tenants();
                    tenant.setGroupId(this.getTenantGroup());
                    tenant.setInsertTime(LocalDateTime.now());
                    tenant.setUpdateTime(LocalDateTime.now());
                    tenant.setCustomNo(customID);
                    if (StringUtils.isEmpty((String)body.getBizSystem())) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u6ce8\u518c\u79df\u6237\u7684\u4e1a\u52a1\u7aef\u6807\u8bc6\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u4e1a\u52a1\u7aef\u7c7b\u578b\u6807\u8bc6\u3002", (String)"RegisterMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    }
                    tenant.setBizSystem(body.getBizSystem());
                    if (StringUtils.isEmpty((String)body.getCustomName())) {
                        body.setCustomName(this.autoGenerateCustomName(body.getBizSystem()));
                    }
                    tenant.setName(body.getCustomName());
                    tenant.setPhone(body.getPhone());
                    tenant.setEmail(body.getEmail());
                    this.tenantRespository.save(tenant);
                    break block6;
                }
                if (modify) {
                    tenant.setPhone(body.getPhone());
                    tenant.setEmail(body.getEmail());
                    tenant.setName(body.getCustomName());
                    this.tenantRespository.save(tenant);
                    break block6;
                }
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u53f7[%s]\u5df2\u88ab\u6ce8\u518c\u4f7f\u7528\u3002", (String)"RegisterMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]), tenant.getCustomNo()));
            }
            catch (Exception e) {
                registerResponse.setErrorCode("fail");
                registerResponse.setErrorMsg(e.getMessage());
            }
        }
        return registerResponse;
    }

    public Long getTenantGroup() {
        Long id = 0L;
        List groups = this.tenantGroupRepository.findAll();
        if (groups != null && groups.size() > 0) {
            id = ((TenantGroup)groups.get(0)).getId();
        }
        return id;
    }

    private String autoGenerateCustomName(String bizSystemID) {
        String customName = "";
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bizSystemID});
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((String)"aqap_bd_biz_sys", (String)"", (QFilter[])filter.toArray());
        if (entity != null) {
            customName = entity.getString("name");
        }
        customName = customName + "_" + Sequence.genSequence();
        return customName;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "register";
    }
}

