/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.alibaba.fastjson.JSONObject;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.exception.IllegalPaymentResult;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.InfoConvertUtils;
import kd.ebg.aqap.business.payment.utils.LinkPayCacheFactory;
import kd.ebg.aqap.business.payment.utils.LinkPayUtils;
import kd.ebg.aqap.business.payment.utils.LinkPaymentConvert;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayDetail;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequest;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequestBody;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayResponse;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.LinkPayConfig;
import kd.ebg.aqap.common.framework.services.LinkPaymentInfoService;
import kd.ebg.aqap.common.model.LinkPayStepInfo;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.keywords.BankKeyWordsService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

public class LinkPayMethod
implements EBServiceMethod<LinkPayRequest, LinkPayResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(LinkPayMethod.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkPayResponse executeClientRequest(LinkPayRequest request, EBContext context) {
        String key = request.getHeader().getCustomId() + "_" + request.getBody().getBatchSeqID();
        boolean isBatchRollBack = PaymentUtil.isBatchPayRollBack((EBRequest)request);
        InvalidPaymentResult paymentResult = new InvalidPaymentResult(isBatchRollBack);
        try {
            Set<List<PaymentInfo>> set;
            List<LinkPaymentInfo> linkPaymentInfos;
            LinkedList<LinkPayStepInfo> filteredLinkPayInfos = new LinkedList<LinkPayStepInfo>();
            try {
                AccessUtils.checkPaymentAllowed(context);
                this.checkSameBank(request);
                this.checkExplanationSpecialCharPool(request, paymentResult);
                LinkPayRequestBody body = request.getBody();
                BankAcnt acnt = context.getAcnt();
                String bankName = acnt.getBankName();
                String bankVersionId = acnt.getBankVersionId();
                String batchSeqID = body.getBatchSeqID();
                long requestTimeStamp = request.getHeader().getRequestTime();
                LocalDateTime requestTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(requestTimeStamp), ZoneId.systemDefault());
                LinkPaymentInfoService linkPaymentInfoService = LinkPaymentInfoService.getInstance();
                if (linkPaymentInfoService.isExisted(batchSeqID)) {
                    throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u6279\u91cf\u6d41\u6c34\u53f7[%s]\u91cd\u590d\u3002", (String)"LinkPayMethod_12", (String)"ebg-aqap-business", (Object[])new Object[0]), batchSeqID));
                }
                this.checkBizNO(request);
                BankBundleManager bankBundleManager = BankBundleManager.getInstance();
                IPretreat iPretreat = (IPretreat)bankBundleManager.getImpl(bankVersionId, IPretreat.class, (Object)request);
                if (iPretreat == null) {
                    throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"%1$s%2$s\u63d2\u4ef6\u9519\u8bef,\u8bf7\u63d0\u4f9bIPretreat\u7684\u63a5\u53e3\u5b9e\u73b0", (String)"LinkPayMethod_13", (String)"ebg-aqap-business", (Object[])new Object[0]), bankName, bankVersionId));
                }
                PaymentInfo stepOnePaymentInfo = null;
                linkPaymentInfos = InfoConvertUtils.convertLinkPayRequest(request);
                if (CollectionUtil.isEmpty(linkPaymentInfos)) {
                    throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"LinkPayMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
                InfoConvertUtils.checkInvalidPayments(linkPaymentInfos, paymentResult);
                String linkPayConfig = InfoConvertUtils.getLinkPayConfig(bankVersionId);
                this.logger.info("\u8054\u52a8\u652f\u4ed8\u914d\u7f6elinkPayConfig = " + linkPayConfig);
                PaymentInfo nativeLinkPay = null;
                if (linkPayConfig.equalsIgnoreCase(LinkPayConfig.NATIVE_LINK_PAY.getKey()) && (nativeLinkPay = InfoConvertUtils.convert4NativeLinkPay(linkPaymentInfos.get(0))) != null) {
                    iPretreat.appendData(nativeLinkPay);
                    if (StringUtils.isNotBlank((CharSequence)nativeLinkPay.getImplClassName())) {
                        Class<?> nativeLinkPayImpl = null;
                        try {
                            nativeLinkPayImpl = this.getClass().getClassLoader().loadClass(nativeLinkPay.getImplClassName());
                        }
                        catch (ClassNotFoundException e) {
                            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"%s\u7c7b\u52a0\u8f7d\u5931\u8d25\u3002", (String)"LinkPayMethod_14", (String)"ebg-aqap-business", (Object[])new Object[0]), nativeLinkPay.getImplClassName()), (Throwable)e);
                        }
                        if (INativeLinkPayable.class.isAssignableFrom(nativeLinkPayImpl)) {
                            stepOnePaymentInfo = nativeLinkPay;
                            this.logger.info("\u94f6\u884c\u652f\u6301\u8054\u52a8\u652f\u4ed8");
                        }
                    }
                }
                if (stepOnePaymentInfo == null) {
                    this.logger.info("\u94f6\u884c\u4e0d\u652f\u6301\u539f\u751f\u8054\u52a8\u652f\u4ed8,\u5f00\u59cb\u5206\u6b65\u9aa4\u5b9e\u73b0\u8054\u52a8\u652f\u4ed8\u4e1a\u52a1");
                    PaymentInfo transDown = InfoConvertUtils.convert4TransDown(linkPaymentInfos.get(0), body.getParentAcnt(), body.getChildAcnt1(), linkPayConfig);
                    this.checkImplement(iPretreat, bankVersionId, transDown, ResManager.loadKDString((String)"\u4e0b\u62e8", (String)"LinkPayMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    this.logger.info("\u94f6\u884c\u63d2\u4ef6\u652f\u6301\u4e0b\u62e8\u652f\u4ed8\u4e1a\u52a1\uff1a\u68c0\u67e5\u5b8c\u6210");
                    PaymentInfo transUp = InfoConvertUtils.convert4TransUp(linkPaymentInfos.get(0), body.getChildAcnt1(), body.getParentAcnt(), linkPayConfig);
                    this.checkImplement(iPretreat, bankVersionId, transUp, ResManager.loadKDString((String)"\u4e0a\u5212", (String)"LinkPayMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    this.logger.info("\u94f6\u884c\u63d2\u4ef6\u652f\u6301\u4e0a\u5212\u652f\u4ed8\u4e1a\u52a1\uff1a\u68c0\u67e5\u5b8c\u6210");
                    IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
                    this.logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u4e0b\u62e8]\u7684PaymentInfo\u5bf9\u8c61, \u4ed8\u6b3e\u8d26\u53f7\uff1a" + body.getParentAcnt() + ", \u6536\u6b3e\u8d26\u53f7\uff1a" + body.getChildAcnt1());
                    for (LinkPaymentInfo linkPaymentInfo : linkPaymentInfos) {
                        try {
                            PaymentInfo convert4Pay = InfoConvertUtils.convert4Pay(linkPaymentInfo, LinkPayUtils.getLastChildAcnt(request));
                            this.checkImplement(iPretreat, bankVersionId, convert4Pay, ResManager.loadKDString((String)"\u5bf9\u5916\u652f\u4ed8", (String)"LinkPayMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
                            stepOnePaymentInfo = InfoConvertUtils.convert4TransDown(linkPaymentInfo, body.getParentAcnt(), body.getChildAcnt1(), linkPayConfig);
                            LinkPayUtils.pretreatment(stepOnePaymentInfo);
                            iPretreat.appendData(stepOnePaymentInfo);
                            linkPaymentInfo.setLinkpayType("linkPay_transDown");
                            LinkPayStepInfo linkPayStepInfo = new LinkPayStepInfo();
                            ArrayList<LinkPaymentInfo> linkPaymentInfoList = new ArrayList<LinkPaymentInfo>(1);
                            linkPaymentInfoList.add(linkPaymentInfo);
                            linkPayStepInfo.setLinkPayDetails(linkPaymentInfoList);
                            linkPayStepInfo.setStepOnePayment(stepOnePaymentInfo);
                            filteredLinkPayInfos.add(linkPayStepInfo);
                        }
                        catch (Throwable e) {
                            illegalPaymentResult.addIllegalPayment(linkPaymentInfo.getDetailSeqId(), e.getMessage());
                        }
                    }
                    if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
                        throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
                    }
                    paymentResult.addIllegalPaymentResult(illegalPaymentResult);
                } else {
                    IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
                    for (LinkPaymentInfo linkPaymentInfo : linkPaymentInfos) {
                        try {
                            nativeLinkPay = InfoConvertUtils.convert4NativeLinkPay(linkPaymentInfo);
                            LinkPayUtils.pretreatment(nativeLinkPay);
                            iPretreat.appendData(nativeLinkPay);
                            stepOnePaymentInfo = nativeLinkPay;
                            linkPaymentInfo.setLinkpayType("linkPay_native");
                            LinkPayStepInfo stepInfo = new LinkPayStepInfo();
                            ArrayList<LinkPaymentInfo> linkPaymentInfoList = new ArrayList<LinkPaymentInfo>(16);
                            linkPaymentInfoList.add(linkPaymentInfo);
                            stepInfo.setLinkPayDetails(linkPaymentInfoList);
                            stepInfo.setStepOnePayment(stepOnePaymentInfo);
                            filteredLinkPayInfos.add(stepInfo);
                        }
                        catch (Throwable e) {
                            illegalPaymentResult.addIllegalPayment(linkPaymentInfo.getDetailSeqId(), e.getMessage());
                        }
                    }
                    if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
                        throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
                    }
                    paymentResult.addIllegalPaymentResult(illegalPaymentResult);
                }
                List<String> validLinkPaymentDetailSeqList = paymentResult.getValidLinkPaymentDetailSeqList(linkPaymentInfos);
                ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(16);
                ListIterator infoIterator = filteredLinkPayInfos.listIterator();
                while (infoIterator.hasNext()) {
                    LinkPaymentInfo linkPaymentInfo;
                    LinkPayStepInfo linkPayStepInfo = (LinkPayStepInfo)infoIterator.next();
                    linkPaymentInfo = (LinkPaymentInfo)linkPayStepInfo.getLinkPayDetails().get(0);
                    if (validLinkPaymentDetailSeqList.contains(linkPaymentInfo.getDetailSeqId())) {
                        PaymentInfo stepOnePayment = linkPayStepInfo.getStepOnePayment();
                        stepOnePayment.setRequestTime(requestTime);
                        paymentInfos.add(stepOnePayment);
                        continue;
                    }
                    infoIterator.remove();
                }
                set = PaymentUtil.packagePay(paymentInfos);
            }
            catch (IllegalArgumentException | EBServiceException e) {
                throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
            }
            catch (EBDuplicateException e) {
                throw EBExceiptionUtil.duplicateException((String)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
            }
            if (!CachePayStorage.checkRepeat(key) && filteredLinkPayInfos.size() > 0) {
                this.logger.info("\u8054\u52a8\u652f\u4ed8\u6570\u636e\u51c6\u5907\u5165\u5e93");
                this.linkPayStepInfosInsert2DB(filteredLinkPayInfos);
                this.logger.info("\u8054\u52a8\u652f\u4ed8\u6570\u636e\u5165\u5e93\u5b8c\u6210,\u5f00\u59cb\u63d0\u4ea4\u6570\u636e\u81f3\u7ebf\u7a0b\u6c60\u5904\u7406");
                PaymentUtil.async(set, (EBRequest)request);
            }
            LinkPayResponse linkPayResponse = LinkPaymentConvert.linkPayConvertToResponse(linkPaymentInfos, request);
            return linkPayResponse;
        }
        finally {
            LinkPayCacheFactory.getInstance().release();
            CachePayStorage.release(key);
        }
    }

    private void checkSameBank(LinkPayRequest payRequest) {
        boolean isSameBank;
        ArrayList<String> errorAccNoList = new ArrayList<String>(1);
        String accNo = payRequest.getBody().getParentAcnt();
        String childAccNo = payRequest.getBody().getChildAcnt1();
        BankAcntService bankAcntService = BankAcntService.getInstance();
        String payerBankVersion = "";
        String payeeBankVersion = "";
        BankAcnt payer = bankAcntService.selectByAccNo(accNo);
        if (payer == null) {
            errorAccNoList.add(accNo);
        } else {
            payerBankVersion = payer.getBankVersionId();
        }
        BankAcnt payee = bankAcntService.selectByAccNo(childAccNo);
        if (payee == null) {
            errorAccNoList.add(childAccNo);
        } else {
            payeeBankVersion = payee.getBankVersionId();
        }
        if (!errorAccNoList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < errorAccNoList.size(); ++i) {
                if (i != errorAccNoList.size() - 1) {
                    sb.append((String)errorAccNoList.get(i)).append(',');
                    continue;
                }
                sb.append((String)errorAccNoList.get(i));
            }
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8054\u52a8\u652f\u4ed8\u8d26\u53f7%s\u672a\u5728\u94f6\u4f01\u4e91\u7ef4\u62a4\uff0c\u8bf7\u5728\u4e1a\u52a1\u7aef\u540c\u6b65\u94f6\u884c\u8d26\u53f7\u3002", (String)"LinkPayMethod_19", (String)"ebg-aqap-business", (Object[])new Object[0]), sb.toString());
            throw EBExceiptionUtil.preCheckException((String)msg);
        }
        boolean bl = isSameBank = StringUtils.isNotEmpty((CharSequence)payerBankVersion) && StringUtils.isNotEmpty((CharSequence)payeeBankVersion) && payerBankVersion.equalsIgnoreCase(payeeBankVersion);
        if (!isSameBank) {
            List payerBankKeyWords = BankKeyWordsService.getInstance().getKeyWords(payerBankVersion);
            List payeeBankKeyWords = BankKeyWordsService.getInstance().getKeyWords(payeeBankVersion);
            for (String keyName : payerBankKeyWords) {
                if (!payeeBankKeyWords.contains(keyName)) continue;
                isSameBank = true;
                break;
            }
            if (!isSameBank) {
                String msg = ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u65f6\uff0c\u53ea\u652f\u6301\u6bcd\u5b50\u8d26\u6237\u4e3a\u540c\u884c\u3002", (String)"LinkPayMethod_18", (String)"ebg-aqap-business", (Object[])new Object[0]);
                throw EBExceiptionUtil.preCheckException((String)msg);
            }
        }
    }

    private void checkExplanationSpecialCharPool(LinkPayRequest payRequest, InvalidPaymentResult paymentResult) {
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        ArrayList payDetailList = new ArrayList(16);
        payDetailList.addAll(payRequest.getBody().getDetails());
        for (LinkPayDetail detail : payDetailList) {
            try {
                this.checkExplanation(EBContext.getContext().getBankVersionID(), detail.getExplanation());
            }
            catch (EBPreCheckException e) {
                illegalPaymentResult.addIllegalPayment(detail.getDetailSeqID(), e.getMessage());
            }
        }
        if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
        paymentResult.addIllegalPaymentResult(illegalPaymentResult);
    }

    private void checkExplanation(String bankVersionID, String explanation) {
        List pools;
        if (StringUtils.isNotEmpty((CharSequence)explanation) && CollectionUtil.isNotEmpty((Collection)(pools = BankPropertyConfig.getExplanationSpecialCharPool((String)bankVersionID)))) {
            for (String pool : pools) {
                if (!StringUtils.isNotEmpty((CharSequence)explanation) || !explanation.contains(pool)) continue;
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u5185\u586b\u5199\u7684\u6458\u8981\u5305\u542b\u4e0d\u89c4\u8303\u7684\u7279\u6b8a\u5b57\u7b26\u4fe1\u606f\uff1b\u8be6\u60c5\u53ef\u4ee5\u67e5\u770b\u67e5\u8be2\u4e0e\u652f\u4ed8-\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u7684\u4ed8\u6b3e\u6458\u8981\u7279\u6b8a\u5b57\u7b26\u6c60\uff1b", (String)"AccessUtils_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBizNO(LinkPayRequest payRequest) {
        JSONObject jsonObject;
        this.logger.info("\u68c0\u67e5\u4ed8\u6b3e\u5355\u636e\u4e1a\u52a1\u53f7\u662f\u5426\u91cd\u590d");
        boolean idempotency = false;
        if (StringUtils.isNotEmpty((CharSequence)payRequest.getExtData())) {
            jsonObject = JSONObject.parseObject((String)payRequest.getExtData());
            if (jsonObject.containsKey((Object)"idempotency")) {
                idempotency = jsonObject.getBoolean("idempotency");
            }
        } else if (StringUtils.isNotEmpty((CharSequence)payRequest.getBody().getExtData()) && (jsonObject = JSONObject.parseObject((String)payRequest.getBody().getExtData())).containsKey((Object)"idempotency")) {
            idempotency = jsonObject.getBoolean("idempotency");
        }
        if (idempotency) {
            int groupSize;
            List payDetailList = payRequest.getBody().getDetails();
            int total = payDetailList.size();
            int groupNum = total % (groupSize = 200) == 0 ? total / groupSize : total / groupSize + 1;
            ArrayList<String> detailBizNoList = new ArrayList<String>(16);
            ArrayList<String> checkRepeatBizNoList = new ArrayList<String>(16);
            for (int i = 0; i < groupNum; ++i) {
                int start = i * groupSize;
                int end = (i + 1) * groupSize;
                if (end > total) {
                    end = total;
                }
                detailBizNoList.clear();
                for (int j = start; j < end; ++j) {
                    detailBizNoList.add(((LinkPayDetail)payDetailList.get(j)).getDetailBizNo());
                }
                QFilter filter = QFilter.of((String)"back_bank_status='1'", (Object[])new Object[0]);
                filter.and(new QFilter("detail_biz_no", "in", detailBizNoList));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"aqap_bd_linkpaymentinfo", (String)"detail_biz_no", (QFilter[])filter.toArray());
                if (!CollectionUtil.isNotEmpty((Collection)collection)) continue;
                for (DynamicObject dynamicObject : collection) {
                    checkRepeatBizNoList.add(dynamicObject.getString("detail_biz_no"));
                }
            }
            if (CollectionUtil.isNotEmpty(checkRepeatBizNoList)) {
                StringBuilder sb = new StringBuilder();
                for (int k = 0; k < checkRepeatBizNoList.size(); ++k) {
                    sb.append((String)checkRepeatBizNoList.get(k));
                    if (k >= checkRepeatBizNoList.size() - 1) continue;
                    sb.append(',');
                }
                String detailBizNo = sb.toString();
                throw EBExceiptionUtil.duplicateException((String)String.format(ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u8bf7\u6c42\u7591\u4f3c\u91cd\u590d\u88ab\u62e6\u622a\uff0c\u5df2\u5b58\u5728\u4ed8\u6b3e\u5b8c\u6210\u6216\u5728\u9014\u7684\u4e1a\u52a1\u53f7[%s]\u3002", (String)"LinkPayMethod_15", (String)"ebg-aqap-business", (Object[])new Object[0]), detailBizNo));
            }
        } else {
            return;
        }
    }

    private void linkPayStepInfosInsert2DB(List<LinkPayStepInfo> filteredLinkPayInfos) {
        LinkPaymentInfoService linkPaymentInfoService = LinkPaymentInfoService.getInstance();
        for (LinkPayStepInfo info : filteredLinkPayInfos) {
            PaymentInfo stepOnePayment = info.getStepOnePayment();
            LinkPaymentInfo linkPaymentInfo = (LinkPaymentInfo)info.getLinkPayDetails().get(0);
            LinkPayUtils.initLinkPaymentInfo(stepOnePayment, linkPaymentInfo.getCurrency());
        }
        linkPaymentInfoService.linkpayWithTransaction(filteredLinkPayInfos);
    }

    private void checkImplement(IPretreat iPretreat, String bankVersionId, PaymentInfo paymentInfo, String funcDesc) {
        iPretreat.appendData(paymentInfo);
        if (StringUtils.isBlank((CharSequence)paymentInfo.getImplClassName())) {
            throw EBExceiptionUtil.preCheckException((String)(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c[%s]", (String)"LinkPayMethod_16", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionId) + String.format(ResManager.loadKDString((String)"\u7f3a\u5c11[%s]\u529f\u80fd\u5b9e\u73b0\uff0c\u8054\u52a8\u652f\u4ed8\u65e0\u6cd5\u8fdb\u884c", (String)"LinkPayMethod_17", (String)"ebg-aqap-business", (Object[])new Object[0]), funcDesc)));
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return BizName.LINK_PAY.name();
    }
}

