/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.duplication.DuplicationPaymentChecker;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentConvert;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.pay.PayResponse;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.MDC;

public class PayMethod
implements EBServiceMethod<PayRequest, PayResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PayMethod.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayResponse executeClientRequest(PayRequest request, EBContext context) {
        AccessUtils.checkPaymentAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        String batchSeqID = "";
        String dky = "";
        boolean isBatchRollBack = PaymentUtil.isBatchPayRollBack((EBRequest)request);
        InvalidPaymentResult paymentResult = new InvalidPaymentResult(isBatchRollBack);
        try {
            Set<List<PaymentInfo>> set;
            List<PaymentInfo> validPaymentInfos;
            List<PaymentInfo> paymentInfos;
            try {
                this.checkStructure(request);
                batchSeqID = request.getBody().getBatchSeqID();
                this.checkBatchSeqIDUnique(batchSeqID);
                dky = request.getHeader().getCustomId() + "_" + batchSeqID;
                PaymentUtil.checkExplanationSpecialCharPool((EBRequest)request, paymentResult);
                PaymentUtil.checkBizNO((EBRequest)request);
                paymentInfos = PaymentConvert.convertPay(request);
                PaymentUtil.checkInvalidPayments(paymentInfos, paymentResult);
                DuplicationPaymentChecker.checkPaymentDuplication(paymentInfos, paymentResult);
                PaymentUtil.payRouteTrace(paymentInfos);
                PaymentUtil.payPriority(paymentInfos);
                PaymentUtil.preTreatment(paymentInfos, paymentResult);
                PaymentUtil.execCheck(paymentInfos, paymentResult);
                validPaymentInfos = paymentResult.getValidPaymentInfoList(paymentInfos);
                set = PaymentUtil.packagePay(validPaymentInfos);
                PaymentUtil.recountTotalAmount(set);
            }
            catch (IllegalArgumentException | EBServiceException e) {
                throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
            }
            catch (EBDuplicateException e) {
                throw EBExceiptionUtil.duplicateException((String)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
            }
            if (!CachePayStorage.checkRepeat(dky)) {
                PaymentUtil.insertPay(validPaymentInfos);
                PaymentUtil.async(set, (EBRequest)request);
            } else {
                this.logger.error("\u5f53\u524d\u4ed8\u6b3e\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u4e1a\u52a1\u6279\u6b21\u53f7\uff1a" + batchSeqID);
            }
            PayResponse payResponse = PaymentConvert.convertToResponse(paymentInfos, request);
            return payResponse;
        }
        finally {
            CachePayStorage.release(dky);
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return BizName.PAY.name();
    }

    private void checkStructure(PayRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)MultiLang.getBatchNotEmptyTip());
        Preconditions.checkState((!PaymentInfoService.getInstance().batchSeqIDExist(batchSeqID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"PayMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
    }
}

