/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.duplication;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.business.payment.duplication.DuplicationPaymentResult;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class DuplicationPaymentChecker {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(DuplicationPaymentChecker.class);
    private static DuplicationPaymentChecker instance = new DuplicationPaymentChecker();

    public static DuplicationPaymentChecker getInstance() {
        return instance;
    }

    public static void checkPaymentDuplication(List<PaymentInfo> paymentInfoList, InvalidPaymentResult paymentResult) {
        logger.info("\u4e1a\u52a1\u8981\u7d20\u9632\u91cd\u68c0\u67e5");
        String bankVersionID = paymentInfoList.get(0).getBankVersionID();
        DuplicationPaymentResult duplicationPaymentResult = DuplicationPaymentChecker.getInstance().getDuplicationCheckResult(paymentInfoList, DuplicationPaymentChecker.isForeignBank(bankVersionID));
        if (duplicationPaymentResult.isHasDuplication() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.duplicateException((String)duplicationPaymentResult.toString());
        }
        paymentResult.addDuplicationPaymentResult(duplicationPaymentResult);
    }

    private static boolean isForeignBank(String bankVersionID) {
        return BankBundleManager.getInstance().isForeignBank(bankVersionID);
    }

    public DuplicationPaymentResult getDuplicationCheckResult(List<PaymentInfo> paymentInfoList, boolean isOverseaPay) {
        DuplicationPaymentResult duplicationPaymentResult = new DuplicationPaymentResult();
        String bankVersionID = paymentInfoList.get(0).getBankVersionID();
        String accNo = paymentInfoList.get(0).getAccNo();
        boolean isHasDuplication = false;
        if (this.isOpenDuplicationPayment(bankVersionID, isOverseaPay)) {
            Map<String, String> tempDuplicationCheckMap = this.getTodayUnFailPaymentResult(accNo);
            for (PaymentInfo paymentInfo : paymentInfoList) {
                String key = this.getDuplicationKey(accNo, paymentInfo);
                if (!tempDuplicationCheckMap.containsKey(key)) continue;
                String existBatchSeqID = tempDuplicationCheckMap.get(key);
                isHasDuplication = true;
                duplicationPaymentResult.addDuplicationPayment(paymentInfo, existBatchSeqID);
            }
        } else {
            logger.info("\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u6b3e\u9a8c\u8bc1\u5f00\u5173\u672a\u542f\u7528\uff0c\u8df3\u8fc7\u68c0\u67e5");
        }
        if (isHasDuplication) {
            logger.info("\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u6b3e\u9a8c\u8bc1\u5f00\u5173\u542f\u7528\uff0c\u5f53\u524d\u4ed8\u6b3e\u91d1\u989d\u6ee1\u8db3'\u9632\u91cd\u590d\u9a8c\u8bc1\u5355\u636e\u91d1\u989d'\u6761\u4ef6\uff0c\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u7684\u4ed8\u6b3e");
        } else {
            logger.info("\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u6b3e\u9a8c\u8bc1\u5f00\u5173\u542f\u7528\uff0c\u5f53\u524d\u4ed8\u6b3e\u91d1\u989d\u6ee1\u8db3'\u9632\u91cd\u590d\u9a8c\u8bc1\u5355\u636e\u91d1\u989d'\u6761\u4ef6\uff0c\u68c0\u67e5\u901a\u8fc7");
        }
        duplicationPaymentResult.setHasDuplication(isHasDuplication);
        return duplicationPaymentResult;
    }

    private boolean isOpenDuplicationPayment(String bankVersionID, boolean isForeignBank) {
        if (isForeignBank) {
            logger.info("\u83b7\u53d6\u5916\u8d44\u94f6\u884c'\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u6b3e\u9a8c\u8bc1\u5f00\u5173");
            return BankPropertyConfig.isAntiDuplicationForeignPayment((String)bankVersionID);
        }
        logger.info("\u83b7\u53d6\u56fd\u5185\u94f6\u884c'\u4e1a\u52a1\u5355\u636e\u9632\u91cd\u4ed8\u6b3e\u9a8c\u8bc1\u5f00\u5173");
        return BankPropertyConfig.isAntiDuplicationPayment((String)bankVersionID);
    }

    private BigDecimal getCheckPayAmount(String bankVersionID) {
        BigDecimal bigDecimal;
        String value = BankPropertyConfig.getAntiDuplicationPaymentAmount((String)bankVersionID);
        try {
            bigDecimal = BigDecimal.valueOf(Long.parseLong(value));
        }
        catch (Exception e) {
            bigDecimal = BigDecimal.valueOf(0L);
            logger.error("\u83b7\u53d6\u9632\u91cd\u590d\u9a8c\u8bc1\u5355\u636e\u91d1\u989d\u5f02\u5e38", (Throwable)e);
        }
        return bigDecimal;
    }

    private Map<String, String> getTodayUnFailPaymentResult(String accNo) {
        HashMap<String, String> paymentResult = new HashMap<String, String>(16);
        QFilter filter = QFilter.of((String)"acc_no=?", (Object[])new Object[]{accNo});
        filter.and(QFilter.of((String)"back_bank_status=?", (Object[])new Object[]{"1"}));
        filter.and(QFilter.of((String)"insert_time>=?", (Object[])new Object[]{LocalDate.now().atStartOfDay()}));
        filter.and(QFilter.of((String)"insert_time<?", (Object[])new Object[]{LocalDate.now().plusDays(1L).atStartOfDay()}));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_bd_paymentinfo", (String)"batch_seq_id,income_acc_no,currency,amount,explanation", (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String income_acc_no = dynamicObject.getString("income_acc_no");
                String currency = dynamicObject.getString("currency");
                BigDecimal amount = dynamicObject.getBigDecimal("amount");
                String explanation = dynamicObject.getString("explanation");
                String key = this.getDuplicationKey(accNo, income_acc_no, currency, amount, explanation);
                String batchSeqID = dynamicObject.getString("batch_seq_id");
                paymentResult.putIfAbsent(key, batchSeqID);
            }
        }
        return paymentResult;
    }

    private String getDuplicationKey(String accNo, String income_acc_no, String currency, BigDecimal amount, String explanation) {
        StringBuilder sb = new StringBuilder();
        sb.append(accNo).append('_').append(income_acc_no).append('_').append(currency).append('_').append(amount.setScale(2)).append('_').append(explanation);
        return sb.toString();
    }

    private String getDuplicationKey(String accNo, PaymentInfo paymentInfo) {
        return this.getDuplicationKey(accNo, paymentInfo.getIncomeAccNo(), paymentInfo.getCurrency(), paymentInfo.getAmount(), paymentInfo.getExplanation());
    }
}

