/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.storage.DetailSyncService;
import kd.ebg.aqap.business.detail.utils.DetailCurrencyFilterUtils;
import kd.ebg.aqap.business.detail.utils.DetailSyncKit;
import kd.ebg.aqap.business.detail.utils.SyncPeriod;
import kd.ebg.aqap.business.util.CurrencyPreCheckUtil;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.repository.DetailInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.MDC;

public class BankDetailTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankDetailTask.class);
    private BankDetailRequest request;
    private EBContext context;
    private DetailSyncService syncService;
    private static final int PAGE_SIZE = 1000;
    private static final String EB_DETAIL = "eb_detail_";
    private static final String acnt_iso_currency_key = "ebg_acnt_iso_currency";
    private static final String business_iso_currency_key = "ebg_business_iso_currency";
    private static final Integer isKeyRepeat = 0;

    public BankDetailTask(BankDetailRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)this.context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u4ea4\u6613\u660e\u7ec6\u5904\u7406,{}", (Object)this.context.getBizSeqID());
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5f00\u59cb\u5904\u7406\u660e\u7ec6\u67e5\u8be2\uff0ccustomID={},bankVersionID={}", new Object[]{this.context.getCustomID(), this.context.getBankVersionID()});
        this.syncService = (DetailSyncService)SpringContextUtil.getBean(DetailSyncService.class);
        EBContext.setContext((EBContext)this.context);
        String bankVersionID = this.context.getBankVersionID();
        String customID = this.context.getCustomID();
        LocalDate startDate = this.request.getStartDate();
        LocalDate endDate = this.request.getEndDate();
        BankAcnt bankAcnt = this.context.getBankAcnt();
        String currency = this.request.getHeader().getBankCurrency();
        boolean isFromEbgPage = "COSMIC-EBG".equalsIgnoreCase(this.request.getHeader().getClientName());
        int pageNum = this.request.getPageNum();
        int pageSize = this.request.getPageSize();
        if (pageNum <= 0) {
            pageNum = 1;
            this.request.setPageNum(1);
        }
        if (pageSize <= 0) {
            pageSize = 1000;
            this.request.setPageSize(1000);
        }
        HashMap<String, String> runningParams = new HashMap<String, String>(1);
        runningParams.put(acnt_iso_currency_key, bankAcnt.getCurrency());
        runningParams.put(business_iso_currency_key, currency);
        if (StrUtil.isBlank((CharSequence)currency)) {
            currency = bankAcnt.getCurrency();
            this.logger.info("\u5f02\u6b65\u7ebf\u7a0b,\u672a\u4f20\u5e01\u79cd\uff0c\u8bbe\u7f6e\u4e3a\u8d26\u53f7\u9ed8\u8ba4\u5e01\u79cd\uff1a{}", (Object)currency);
        }
        this.context.setRunningParams(runningParams);
        String key = "eb_detailFlag__" + customID + "_" + bankVersionID + "_" + bankAcnt.getAccNo() + "_" + startDate.toString() + "_" + endDate.toString() + "_" + currency;
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.plusDays(-1L);
        boolean isToday = false;
        if (startDate.isEqual(today) && endDate.isEqual(today)) {
            isToday = true;
        }
        this.logger.info("\u67e5\u8be2\u5e10\u53f7 : {}, \u5e01\u79cd:{} \u4ece {} \u5230 {} \u7684\u660e\u7ec6", new Object[]{bankAcnt.getAccNo(), currency, startDate, endDate});
        try {
            if (isToday) {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"0", (int)10, (TimeUnit)TimeUnit.MINUTES);
            } else {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"0", (int)1, (TimeUnit)TimeUnit.DAYS);
            }
            this.logger.info("\u8bbe\u7f6e\u5904\u7406\u6807\u8bb0\u4e3a\u5904\u7406\u4e2d\uff0ckey={}\uff0cvalue={}", new Object[]{key, "0"});
            boolean forceQuery = false;
            Page prePage = null;
            if (isToday && !this.syncService.isHavingPagingDetail(bankAcnt.getAccNo(), today.toString(), currency, isKeyRepeat, pageNum, pageSize)) {
                prePage = DetailInfoService.getInstance().selectForPage(customID, bankVersionID, bankAcnt.getAccNo(), currency, startDate, endDate, pageNum, pageSize, isFromEbgPage, null);
                forceQuery = prePage.getTotalElements() == 0L;
            }
            this.queryFromBank(bankAcnt, startDate, endDate, this.request, customID, forceQuery);
            if (isToday) {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)10, (TimeUnit)TimeUnit.MINUTES);
            } else {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"1", (int)1, (TimeUnit)TimeUnit.DAYS);
            }
            this.logger.info("\u4ece {} \u5230 {} \u7684\u660e\u7ec6\u5904\u7406\u5b8c\u6210\uff0c\u8bbe\u7f6e\u5904\u7406\u6807\u8bb0\u4e3a\u5df2\u5b8c\u6210\uff0ckey={}\uff0cvalue={}", new Object[]{startDate, endDate, key, "1"});
        }
        catch (Exception e) {
            this.logger.error("\u4ea4\u6613\u660e\u7ec6\u5f02\u6b65\u5904\u7406\u5f02\u5e38", (Throwable)e);
            if (isToday) {
                CosmicCache.putIfAbsentWithExpire((String)key, (String)"2", (int)10, (TimeUnit)TimeUnit.MINUTES);
            }
            CosmicCache.putIfAbsentWithExpire((String)key, (String)"2", (int)1, (TimeUnit)TimeUnit.DAYS);
        }
        return new EBBankDetailResponse();
    }

    private void queryFromBank(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, BankDetailRequest detailRequest, String customID, boolean forceQuery) {
        String isoCurrency = (String)EBContext.getContext().getRunningParams().get(business_iso_currency_key);
        LocalDate today = LocalDate.now();
        String date = today.format(DateTimeFormatter.BASIC_ISO_DATE);
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        if (forceQuery) {
            this.context.setForceQueryDetail(true);
            this.logger.info("\u5f3a\u5236\u67e5\u8be2\uff0c\u8df3\u8fc73\u5206\u949f\u9650\u5236");
        }
        boolean isDetailSupportMultiCurrency = BankBundleManager.getInstance().getBankVersionInfo(bankAcnt.getBankVersionId()).isDetailSupportMultiCurrency();
        if (today.isEqual(startDate) && syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, isoCurrency, customID)) {
            int minute = BusinessPropertyConfig.getTodayDetailLimitTime();
            if (forceQuery || this.syncService.isExpire(bankAcnt.getAccNo(), date, customID, minute)) {
                this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest));
                this.syncService.recordTodayDetailTimestamp(bankAcnt.getAccNo(), date, customID);
            } else {
                this.logger.info("\u5e10\u53f7: {} \u5728{}\u5206\u949f\u5185\u67e5\u8be2\u8fc7\u4eca\u65e5\u660e\u7ec6\uff0c\u4e0d\u518d\u67e5\u8be2", new Object[]{bankAcnt.getAccNo(), minute});
            }
        } else if (today.isEqual(endDate)) {
            LocalDate yesterday = today.plusDays(-1L);
            if (syncKit.canSync(bankAcnt.getAccNo(), today, isDetailSupportMultiCurrency, isoCurrency, customID)) {
                this.syncToday(bankAcnt, today, this.buildRequest(bankAcnt, today, today, detailRequest));
            } else {
                this.logger.info("\u5e10\u53f7 : {} \u8fd13\u5206\u949f\u5185\u67e5\u8be2\u8fc7\u4eca\u65e5\u660e\u7ec6\uff0c\u4e0d\u5728\u67e5\u8be2", (Object)bankAcnt.getAccNo());
            }
            List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, yesterday, isDetailSupportMultiCurrency, isoCurrency, customID);
            for (SyncPeriod period : syncPeriods) {
                this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest));
            }
        } else {
            List<SyncPeriod> syncPeriods = syncKit.getSyncPeriods(bankAcnt.getAccNo(), startDate, endDate, isDetailSupportMultiCurrency, isoCurrency, customID);
            for (SyncPeriod period : syncPeriods) {
                this.syncHistory(bankAcnt, period.getStartDate(), period.getEndDate(), this.buildRequest(bankAcnt, period.getStartDate(), period.getEndDate(), detailRequest));
            }
        }
    }

    private BankDetailRequest buildRequest(BankAcnt acnt, LocalDate startDate, LocalDate endDate, BankDetailRequest detailRequest) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomerID());
        String bankCurrency = CurrencyUtils.convert2Bank((String)detailRequest.getBankCurrency(), (String)this.context.getBankVersionID(), (String)this.context.getCustomID());
        header.setBankCurrency(bankCurrency);
        request.setPageSize(detailRequest.getPageSize());
        request.setPageNum(1);
        request.setBankCurrency(bankCurrency);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setExtData(detailRequest.getExtData());
        request.setSerialNo(detailRequest.getSerialNo());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncToday(BankAcnt bankAcnt, LocalDate today, BankDetailRequest request) {
        String isoCurrency = (String)EBContext.getContext().getRunningParams().get(business_iso_currency_key);
        String key = EB_DETAIL + request.getHeader().getCustomerID() + "_" + bankAcnt.getAccNo() + "_" + today.toString() + "_" + isoCurrency + "_" + isKeyRepeat;
        String result = CosmicCache.putIfAbsentWithExpire((String)key, (String)"exist", (int)30, (TimeUnit)TimeUnit.SECONDS);
        if (StringUtils.isNotEmpty((String)result)) {
            this.logger.error("\u5f53\u524d\u67e5\u8be2\u5f53\u65e5\u660e\u7ec6\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u7b49\u5f8530s\u540e\u67e5\u8be2");
            return;
        }
        this.logger.info("\u67e5\u8be2\u4eca\u65e5\u7684\u660e\u7ec6\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {} ", new Object[]{today.toString(), today.toString()});
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"todayDetail");
        IDetail detail = (IDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IDetail.class, (Object)request);
        CurrencyPreCheckUtil.checkDetailCurrency(detail, bankAcnt.getCurrency(), request.getBankCurrency());
        EBBankDetailResponse response = null;
        FEPAccess access = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)this.context.getBankVersionID(), (String)this.context.getBankLoginID());
            response = detail.detail(request);
        }
        catch (Throwable throwable) {
            FEPAccessUtil.release(access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            throw throwable;
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.info("\u65e5\u671f\u53ca\u5e01\u79cd\u8fc7\u6ee4\u524d\u540c\u6b65\u5230 : {} \u6761\u4ea4\u6613\u660e\u7ec6 ", (Object)response.getDetails().size());
        if (CollectionUtil.isNotEmpty(response.getDetails()) && !response.getDetails().get(0).getCurrency().equals(isoCurrency)) {
            boolean isOpenFilter = BusinessPropertyConfig.isOpenCurrencyFilter();
            if (isOpenFilter) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u8fc7\u6ee4", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            } else {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u4f46\u662f\u7531\u4e8e\u5173\u95ed\u4e86\u8fc7\u6ee4\u5f00\u5173\uff0c\u6240\u4ee5\u672c\u6b21\u4e0d\u8fc7\u6ee4\u8bb0\u5f55\uff0c\u5c06\u5e01\u79cd\u4fee\u6539\u4e3a\u4e0a\u9001\u5e01\u79cd\uff0c\u6b63\u5e38\u8fd4\u56de", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            }
        }
        List detailInfoList = response.getDetails().stream().filter(detailInfo -> detailInfo.getTransDate() != null && detailInfo.getTransDate().compareTo(LocalDate.now()) == 0).collect(Collectors.toList());
        this.logger.info("\u65e5\u671f\u8fc7\u6ee4\u540e\uff0c\u540c\u6b65\u5230{}\u6761\u660e\u7ec6", (Object)detailInfoList.size());
        response.setDetails(DetailCurrencyFilterUtils.filterCurrency(detailInfoList, isoCurrency));
        this.dealResponse(bankAcnt, response, today, today);
        DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        detailInfoList = detailInfoRepository.findByCustomIDAndAccNoAndCurrencyAndTransDateBetweenAndIsKeyRepeat(bankAcnt.getCustomID(), bankAcnt.getAccNo(), isoCurrency, today, today, isKeyRepeat);
        this.syncService.removePagingTotalNum(bankAcnt.getAccNo(), today.toString(), isoCurrency, isKeyRepeat);
        this.syncService.savePagingDetail(detailInfoList, bankAcnt.getAccNo(), today.toString(), isoCurrency, request.getPageSize(), isKeyRepeat);
        this.syncService.savePagingTotalNum(bankAcnt.getAccNo(), today.toString(), isoCurrency, detailInfoList.size(), isKeyRepeat);
        CosmicCache.delete((String)key);
    }

    private void syncHistory(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, BankDetailRequest request) {
        long takeUpTime;
        EBBankDetailResponse response;
        String isoCurrency = (String)EBContext.getContext().getRunningParams().get(business_iso_currency_key);
        String key = EB_DETAIL + request.getHeader().getCustomerID() + "_" + bankAcnt.getAccNo() + "_" + startDate.toString() + "_" + endDate.toString() + "_" + isoCurrency + "_" + isKeyRepeat;
        String result = CosmicCache.putIfAbsentWithExpire((String)key, (String)"exist", (int)30, (TimeUnit)TimeUnit.SECONDS);
        if (kd.ebg.egf.common.utils.string.StringUtils.isNotEmpty((String)result)) {
            this.logger.error("\u5f53\u524d\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u7b49\u5f8530s\u540e\u67e5\u8be2");
            return;
        }
        this.logger.info("\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u7684\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {} ", new Object[]{startDate.toString(), endDate.toString()});
        EBContext.setContext((EBContext)this.context);
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"hisDetail");
        IHisDetail detail = (IHisDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IHisDetail.class, (Object)request);
        CurrencyPreCheckUtil.checkDetailCurrency(detail, bankAcnt.getCurrency(), request.getBankCurrency());
        FEPAccess access = null;
        String customID = EBContext.getContext().getCustomID();
        DetailSyncKit syncKit = (DetailSyncKit)SpringContextUtil.getBean(DetailSyncKit.class);
        try {
            long startTime = System.currentTimeMillis();
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)this.context.getBankVersionID(), (String)this.context.getBankLoginID());
            response = detail.hisDetail(request);
            takeUpTime = System.currentTimeMillis() - startTime;
        }
        catch (Exception ex) {
            try {
                syncKit.insertSyncDetailRecord(null, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, isoCurrency, false);
                throw EBExceiptionUtil.serviceException((Throwable)ex);
            }
            catch (Throwable throwable) {
                FEPAccessUtil.release(access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                throw throwable;
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        syncKit.insert_sync_detail(bankAcnt.getAccNo(), customID, startDate, endDate, takeUpTime);
        this.logger.info("\u65e5\u671f\u53ca\u5e01\u79cd\u8fc7\u6ee4\u524d\u540c\u6b65\u5230 : {} \u6761\u4ea4\u6613\u660e\u7ec6 ", (Object)response.getDetails().size());
        if (CollectionUtil.isNotEmpty(response.getDetails()) && !response.getDetails().get(0).getCurrency().equals(isoCurrency)) {
            boolean isOpenFilter = BusinessPropertyConfig.isOpenCurrencyFilter();
            if (isOpenFilter) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u8fc7\u6ee4", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            } else {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u6846\u67b6\u68c0\u6d4b\u5230\u4e1a\u52a1\u8bf7\u6c42\u5e01\u79cd{}\u4e0e\u94f6\u884c\u63d2\u4ef6\u54cd\u5e94\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u4f46\u662f\u7531\u4e8e\u5173\u95ed\u4e86\u8fc7\u6ee4\u5f00\u5173\uff0c\u6240\u4ee5\u672c\u6b21\u4e0d\u8fc7\u6ee4\u8bb0\u5f55\uff0c\u5c06\u5e01\u79cd\u4fee\u6539\u4e3a\u4e0a\u9001\u5e01\u79cd\uff0c\u6b63\u5e38\u8fd4\u56de", new Object[]{isoCurrency, response.getDetails().get(0).getCurrency()});
            }
        }
        List<DetailInfo> detailInfos = response.getDetails().stream().filter(detailInfo -> detailInfo.getTransDate() != null && detailInfo.getTransDate().isBefore(endDate.plusDays(1L)) && detailInfo.getTransDate().isAfter(startDate.minusDays(1L))).collect(Collectors.toList());
        this.logger.info("\u65e5\u671f\u8fc7\u6ee4\u540e\uff0c\u540c\u6b65\u5230{}\u6761\u660e\u7ec6", (Object)detailInfos.size());
        response.setDetails(DetailCurrencyFilterUtils.filterCurrency(detailInfos, isoCurrency));
        try {
            this.dealResponse(bankAcnt, response, startDate, endDate);
            syncKit.insertSyncDetailRecord(detailInfos, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, isoCurrency, true);
        }
        catch (Exception ex) {
            this.logger.info("\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38");
            syncKit.insertSyncDetailRecord(null, bankAcnt.getAccNo(), bankAcnt.getBankName(), customID, startDate, endDate, isoCurrency, false);
            throw EBExceiptionUtil.serviceException((Throwable)ex);
        }
        CosmicCache.delete((String)key);
    }

    private void dealResponse(BankAcnt bankAcnt, EBBankDetailResponse response, LocalDate startDate, LocalDate endDate) {
        HashMap<String, String> currencyMap = new HashMap<String, String>(16);
        List<DetailInfo> detailInfos = response.getDetails();
        this.logger.info("\u65e5\u671f\u53ca\u5e01\u79cd\u8fc7\u6ee4\u540e\u540c\u6b65\u5230 : {} \u6761\u4ea4\u6613\u660e\u7ec6 ", (Object)detailInfos.size());
        String accType = BankAcntPropertyConfig.getAccType((String)bankAcnt.getAccNo());
        for (DetailInfo detail : detailInfos) {
            String currency;
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getDebitAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u501f\u6b3e\u91d1\u989d(DebitAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u6536\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6", (String)"BankDetailTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCreditAmount()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u8d37\u6b3e\u91d1\u989d(CreditAmount)\u4e0d\u80fd\u4e3a\u7a7a.\u5982\u679c\u662f\u4ed8\u6b3e\uff0c\u53ef\u4ee5\u586b\u5165\u96f6", (String)"BankDetailTask_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574,\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a", (String)"BankDetailTask_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getTransTime()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u4ea4\u6613\u65f6\u95f4(TransTime)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDetailTask_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setBankLoginID(bankAcnt.getBankLoginId());
            detail.setBankVersionID(bankAcnt.getBankVersionId());
            String bankCurrency = detail.getCurrency();
            if (!currencyMap.containsKey(bankCurrency)) {
                currencyMap.put(bankCurrency, CurrencyUtils.convert2Iso((String)bankCurrency));
            }
            if (!kd.ebg.egf.common.utils.string.StringUtils.isEmpty((String)(currency = (String)currencyMap.get(bankCurrency)))) {
                detail.setCurrency(currency);
            }
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getCurrency()), (Object)ResManager.loadKDString((String)"\u5e01\u79cd\u8f6c\u6362\u9519\u8bef\uff0c\u5e01\u79cd(Currency)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDetailTask_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setCustomID(this.context.getCustomID());
            detail.setAccType(accType);
            LocalDateTime transTime = detail.getTransTime();
            if (Objects.isNull(transTime)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDetailTask_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            LocalDate transDate = detail.getTransDate();
            if (Objects.isNull(transDate)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u7684\u8bb0\u8d26\u65e5\u671f\uff08transDate\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankDetailTask_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            if (kd.ebg.egf.common.utils.string.StringUtils.isEmpty((String)detail.getAccNo())) {
                detail.setAccNo(bankAcnt.getAccNo());
            }
            if (kd.ebg.egf.common.utils.string.StringUtils.isEmpty((String)detail.getAccName())) {
                detail.setAccName(bankAcnt.getAccName());
            }
            if (kd.ebg.egf.common.utils.string.StringUtils.isEmpty((String)detail.getBankName())) {
                detail.setBankName(bankAcnt.getBankName());
            }
            detail.setCreditAmount(detail.getCreditAmount().setScale(2, 4));
            detail.setDebitAmount(detail.getDebitAmount().setScale(2, 4));
        }
        DetailInfoService.getInstance().insertOrUpdate(detailInfos, bankAcnt, this.context.getCustomID(), startDate, endDate);
    }
}

