/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.utils.InfoConvertUtils;
import kd.ebg.aqap.business.payment.utils.LinkPayCacheFactory;
import kd.ebg.aqap.business.payment.utils.LinkPayUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayDetail;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.querylinkpay.QueryLinkPayDetail;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.LinkPaymentInfoService;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LinkPayStepHelper {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LinkPayStepHelper.class);

    public static void doNextStep(List<PaymentInfo> paymentInfos) {
        try {
            ListIterator<PaymentInfo> infoIterator = paymentInfos.listIterator();
            while (infoIterator.hasNext()) {
                PaymentInfo paymentInfo = (PaymentInfo)infoIterator.next();
                if (!UpdateOpState.MANUAL.getId().equalsIgnoreCase(paymentInfo.getUpdateOperation())) continue;
                infoIterator.remove();
            }
            LinkPayStepHelper.linkPayProcess(paymentInfos);
        }
        finally {
            LinkPayCacheFactory.getInstance().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linkPayProcess(List<PaymentInfo> currentPayments) {
        String bankVersionId = null;
        IPretreat appendDataService = null;
        ArrayList<PaymentInfo> nextPayments = new ArrayList<PaymentInfo>(1);
        ArrayList nextLinkPaymentsResult = new ArrayList(1);
        TXHandle h = TX.requiresNew();
        try {
            PaymentInfoService paymentInfoService = PaymentInfoService.getInstance();
            BankAcntService bankAcntService = BankAcntService.getInstance();
            LinkPaymentInfoService linkPaymentInfoService = LinkPaymentInfoService.getInstance();
            for (PaymentInfo paymentInfo : currentPayments) {
                String linkpayType = paymentInfo.getLinkpayType();
                if (StringUtils.isEmpty((String)linkpayType) || linkpayType.indexOf("linkPay") == -1) continue;
                if (StringUtils.isEmpty((String)paymentInfo.getDetailSeqId())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"detailSeqId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkPayStepHelper_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
                List<LinkPaymentInfo> linkPaymentInfos = linkPaymentInfoService.selectByBatchSeqIdAndDetailSeqId(paymentInfo.getBatchSeqId(), paymentInfo.getLinkpayDetailSeqId());
                logger.info("currPayments.length:" + currentPayments.size());
                logger.info("\u5f53\u524d\u4ed8\u6b3e\u660e\u7ec6\u53f7\uff1a" + paymentInfo.getDetailSeqId() + ",linkPaymentInfos.length:" + linkPaymentInfos.size());
                logger.info("\u8054\u52a8\u652f\u4ed8\u4e1a\u52a1\uff0c\u6d41\u6c34\u53f7\uff1a" + paymentInfo.getBatchSeqId());
                if (CollectionUtils.isEmpty((Collection)linkPaymentInfos)) {
                    logger.info("\u6839\u636edetailSeqId:{},batchSeqId\uff1a{}\u672a\u627e\u5230\u8054\u52a8\u652f\u4ed8\u8bb0\u5f55", new Object[]{paymentInfo.getLinkpayDetailSeqId(), paymentInfo.getBatchSeqId()});
                    continue;
                }
                PaymentState currState = PaymentState.getEnumById((int)paymentInfo.getStatus());
                linkPaymentInfos = LinkPayStepHelper.updateLinkPayState(linkPaymentInfos, paymentInfo);
                if ("linkPay_native".equalsIgnoreCase(paymentInfo.getLinkpayType())) {
                    logger.info("\u94f6\u884c\u652f\u6301\u8054\u52a8\u652f\u4ed8\uff0c\u65e0\u9700\u6267\u884c\u4e0b\u4e00\u6b65\u3002\u4ed8\u6b3e\u8868\u6d41\u6c34\u53f7BatchSeqId\uff1a" + paymentInfo.getBatchSeqId());
                    continue;
                }
                logger.info("\u4ea4\u6613\u7ed3\u679c\uff1a[id: " + currState.getId() + ", msg: " + currState.getCnName() + "]");
                ArrayList<PaymentInfo> _nextPayments = new ArrayList<PaymentInfo>(1);
                ArrayList<LinkPaymentInfo> _nextLinkPayments = new ArrayList<LinkPaymentInfo>(1);
                logger.info("currPayment.Id:" + paymentInfo.getId() + ",currPayment.detailSeqId:" + paymentInfo.getDetailSeqId() + ",currPayment.batchSeqId:" + paymentInfo.getBatchSeqId());
                logger.info("\u5f53\u524d\u4ed8\u6b3e\u8bb0\u5f55\u7684\u72b6\u6001currState:" + currState);
                if (PaymentState.SUCCESS == currState) {
                    List<PaymentInfo> successNextPayments = LinkPayStepHelper.getNextPaymentWhenSuccess(linkPaymentInfos, paymentInfo);
                    LinkPaymentInfo linkPaymentInfo = linkPaymentInfos.get(0);
                    String linkPayType = linkPaymentInfo.getLinkpayType();
                    logger.info("\u5f53\u524d\u8054\u52a8\u652f\u4ed8\u65b9\u5411:" + linkPayType + ",detailSeqId:" + paymentInfo.getDetailSeqId() + ",successNextPayments.size:" + (null == successNextPayments ? 0 : successNextPayments.size()));
                    if (!CollectionUtils.isEmpty(successNextPayments) && StringUtils.equals((String)linkPayType, (String)"linkPay_transDown")) {
                        logger.info("\u6bcd\u8d26\u53f7\u5bf9\u5b50\u8d26\u53f7\u4ed8\u6b3e\u6210\u529f\uff0c\u51c6\u5907\u5b50\u8d26\u53f7\u5bf9\u5916\u4ed8\u6b3e\u7684\u6570\u636e\uff0clinkPayment\u8bb0\u5f55\u7684\u4e3b\u952e\u4e3a\uff1a" + linkPaymentInfo.getId() + ",\u5f53\u524d\u4ed8\u6b3e\u8bb0\u5f55\u7684\u4e3b\u952e\u4e3a\uff1a" + paymentInfo.getId());
                        successNextPayments.get(0).setRelativeId(paymentInfo.getId());
                        linkPaymentInfo.setLinkpayType("linkPay_pay");
                        _nextLinkPayments.add(linkPaymentInfo);
                        _nextPayments.addAll(successNextPayments);
                    }
                    logger.info("\u4ea4\u6613\u6210\u529f\uff0c\u662f\u5426\u8fd8\u6709\u4e0b\u4e00\u6b65\u4ea4\u6613:" + (_nextPayments == null || _nextPayments.size() == 0 ? "\u5426" : "\u662f"));
                } else if (PaymentState.FAIL == currState) {
                    PaymentInfo nextPayment = LinkPayStepHelper.getNextPaymentWhenFail(linkPaymentInfos, paymentInfo);
                    String linkPayType = linkPaymentInfos.get(0).getLinkpayType();
                    logger.info("\u5f53\u524d\u8054\u52a8\u652f\u4ed8\u65b9\u5411:" + linkPayType);
                    if (nextPayment != null && StringUtils.equalsIgnoreCase((String)linkPayType, (String)"linkPay_pay")) {
                        logger.info("\u5b50\u8d26\u53f7\u5bf9\u5916\u4ed8\u6b3e\u5931\u8d25\uff0c\u51c6\u5907\u5b50\u8d26\u53f7\u5bf9\u6bcd\u8d26\u53f7\u4ed8\u6b3e\u7684\u6570\u636e\uff0clinkPayment\u8bb0\u5f55\u7684\u4e3b\u952e\u4e3a\uff1a" + linkPaymentInfos.get(0).getId() + ",\u5f53\u524d\u4ed8\u6b3e\u8bb0\u5f55\u7684\u4e3b\u952e\u4e3a\uff1a" + paymentInfo.getId());
                        LinkPaymentInfo info = linkPaymentInfos.get(0);
                        nextPayment.setRelativeId(paymentInfo.getId());
                        info.setLinkpayType("linkPay_transUp");
                        _nextLinkPayments.add(info);
                        _nextPayments.add(nextPayment);
                    }
                    logger.info("\u4ea4\u6613\u5931\u8d25\uff0c\u662f\u5426\u9700\u8981\u6267\u884c\u4e0a\u5212\u64cd\u4f5c\uff1a" + (nextPayment == null ? "\u5426" : "\u662f"));
                } else {
                    logger.info("\u4ea4\u6613\u7ed3\u679c\u672a\u786e\u8ba4(\u975e\u6210\u529f\u975e\u5931\u8d25)\uff0c\u9700\u8981\u540c\u6b65\u4ea4\u6613\u7ed3\u679c");
                }
                if (_nextPayments.size() == 0) continue;
                nextPayments.addAll(_nextPayments);
                nextLinkPaymentsResult.addAll(_nextLinkPayments);
                BankAcnt acnt = bankAcntService.selectByAccNo(((PaymentInfo)_nextPayments.get(0)).getAccNo());
                acnt = LinkPayUtils.convertAddress(acnt);
                EBContext.getContext().setBankAcnt(acnt);
                if (appendDataService == null) {
                    bankVersionId = acnt.getBankVersionId();
                    BankBundleManager bankBundleManager = BankBundleManager.getInstance();
                    appendDataService = (IPretreat)bankBundleManager.getImpl(bankVersionId, IPretreat.class, _nextPayments.get(0));
                    if (appendDataService == null) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%s\u63d2\u4ef6\u9519\u8bef\uff0c\u8bf7\u63d0\u4f9bIPretreat\u7684\u63a5\u53e3\u5b9e\u73b0\u3002", (String)"LinkPayStepHelper_2", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionId));
                    }
                }
                for (PaymentInfo nextPayment : _nextPayments) {
                    LinkPayUtils.pretreatment(nextPayment);
                    appendDataService.appendData(nextPayment);
                    LinkPayUtils.initLinkPaymentInfo(nextPayment, linkPaymentInfos.get(0).getCurrency());
                }
            }
            if (nextPayments.size() > 0) {
                List<String> repeatRelativeIDs = PaymentUtil.checkRepeatRelativeIDs(nextPayments);
                if (repeatRelativeIDs.isEmpty()) {
                    logger.info("\u8054\u52a8\u652f\u4ed8\u6d3e\u751f\u4ed8\u6b3e\u9632\u91cd\u590d\u68c0\u67e5\u901a\u8fc7");
                } else {
                    ListIterator infoIterator = nextPayments.listIterator();
                    while (infoIterator.hasNext()) {
                        PaymentInfo paymentInfo = (PaymentInfo)infoIterator.next();
                        String relativeID = paymentInfo.getRelativeId();
                        if (!StringUtils.isNotEmpty((String)relativeID) || !repeatRelativeIDs.contains(relativeID)) continue;
                        infoIterator.remove();
                    }
                    logger.info("\u8054\u52a8\u652f\u4ed8\u6d3e\u751f\u4ed8\u6b3e\u9632\u91cd\u590d\u68c0\u67e5\u5230\u5b58\u5728\u91cd\u590d\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u5df2\u5904\u7406\u91cd\u590d\u8bb0\u5f55");
                }
                Set<List<PaymentInfo>> set = PaymentUtil.packagePay(nextPayments);
                PaymentUtil.recountTotalAmount(set);
                paymentInfoService.insertPaymentAndUpdateLinkPaymentInfos(nextPayments, nextLinkPaymentsResult);
                PayRequest payRequest = new PayRequest();
                EBHeader ebHeader = new EBHeader();
                payRequest.setHeader(ebHeader);
                ebHeader.setCurrency(((LinkPaymentInfo)nextLinkPaymentsResult.get(0)).getCurrency());
                ebHeader.setBizSeqID(EBContext.getContext().getBizSeqID());
                ebHeader.setCustomId(EBContext.getContext().getCustomID());
                ebHeader.setClientName("linkPayTask");
                ebHeader.setClientVersion("1.0");
                logger.info("\u91cd\u65b0\u63d0\u4ea4\u4ed8\u6b3e\u8bf7\u6c42\u5230\u5f02\u6b65\u7ebf\u7a0b\u6c60\u7b49\u5f85\u5904\u7406");
                PaymentUtil.async(set, (EBRequest)payRequest);
            }
        }
        catch (Exception e) {
            logger.error("\u8054\u52a8\u652f\u4ed8\u8fc7\u7a0b\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
            h.markRollback();
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static List<LinkPaymentInfo> updateLinkPayState(List<LinkPaymentInfo> linkPaymentInfos, PaymentInfo paymentInfo) {
        LinkPaymentInfoService service = LinkPaymentInfoService.getInstance();
        for (LinkPaymentInfo linkPaymentInfo : linkPaymentInfos) {
            LinkPayStepHelper.updateLinkPayState(linkPaymentInfo, paymentInfo);
        }
        return service.updateLinkPaymentInfo(linkPaymentInfos);
    }

    private static void updateLinkPayState(LinkPaymentInfo linkPaymentInfo, PaymentInfo paymentInfo) {
        PaymentState bankState = PaymentState.getEnumById((int)paymentInfo.getStatus());
        String ebStatus = "";
        String ebStatusMsg = linkPaymentInfo.getEbStatusMsg();
        boolean isTransDown = "linkPay_transDown".equalsIgnoreCase(paymentInfo.getLinkpayType());
        boolean isPay = "linkPay_pay".equalsIgnoreCase(paymentInfo.getLinkpayType());
        boolean isTransUp = "linkPay_transUp".equalsIgnoreCase(paymentInfo.getLinkpayType());
        boolean isManual = UpdateOpState.MANUAL.getId().equalsIgnoreCase(paymentInfo.getUpdateOperation());
        if (isManual && (isTransDown || isPay)) {
            if (bankState == PaymentState.FAIL) {
                ebStatus = EbStatus.BANK_FAIL.getName();
                ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_FAIL_MANUAL;
            } else if (bankState == PaymentState.SUCCESS) {
                ebStatus = EbStatus.BANK_SUCCESS.getName();
                ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_SUCCESS_MANUAL;
            }
        } else {
            boolean isNative;
            boolean isStep1;
            boolean isForward = "linkPay_transDown".equalsIgnoreCase(paymentInfo.getLinkpayType()) || "linkPay_pay".equalsIgnoreCase(paymentInfo.getLinkpayType());
            boolean bl = isStep1 = linkPaymentInfo.getParentAcnt().equalsIgnoreCase(paymentInfo.getAccNo()) && linkPaymentInfo.getChildAcnt1().equalsIgnoreCase(paymentInfo.getIncomeAccNo());
            if (bankState == PaymentState.INITIAL) {
                if (isStep1) {
                    ebStatus = EbStatus.EB_PROCESSING.getName();
                    ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_ACCEPTED;
                }
            } else if (bankState == PaymentState.SUBMITTING) {
                if (isStep1) {
                    ebStatus = EbStatus.EB_PROCESSING.getName();
                    ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_ACCEPTED;
                }
            } else if (bankState == PaymentState.SUBMITED) {
                ebStatus = EbStatus.BANK_PROCESSING.getName();
                ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_PROCESSING;
            } else if (bankState == PaymentState.UNKNOWN) {
                ebStatus = EbStatus.BANK_UNKNOWN.getName();
                isNative = "linkPay_native".equalsIgnoreCase(paymentInfo.getLinkpayType());
                ebStatusMsg = isNative ? LinkPayUtils.LINKPAY_STATUS_UNKNOWN : (isTransDown ? LinkPayUtils.LINKPAY_STATUS_UNKNOWN_TRANSDOWN : (isPay ? LinkPayUtils.LINKPAY_STATUS_UNKNOWN_PAY : (isTransUp ? LinkPayUtils.LINKPAY_STATUS_UNKNOWN_TRANSUP : LinkPayUtils.LINKPAY_STATUS_UNKNOWN)));
            } else if (bankState == PaymentState.FAIL) {
                isNative = "linkPay_native".equalsIgnoreCase(paymentInfo.getLinkpayType());
                if (isNative) {
                    ebStatus = EbStatus.BANK_FAIL.getName();
                    ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_FAIL;
                } else if (isForward && !isStep1) {
                    boolean needTransUp = LinkPayStepHelper.isLastPay(linkPaymentInfo, paymentInfo);
                    if (needTransUp) {
                        ebStatus = EbStatus.BANK_PROCESSING.getName();
                        ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_FAIL_TRANSUP;
                    } else {
                        ebStatus = EbStatus.BANK_FAIL.getName();
                        ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_FAIL_BATCH_FAIL;
                    }
                } else if (!isForward) {
                    ebStatus = EbStatus.BANK_FAIL.getName();
                    ebStatusMsg = isManual ? LinkPayUtils.LINKPAY_STATUS_FAIL_TRANSUP_FAIL_MANUAL : LinkPayUtils.LINKPAY_STATUS_FAIL_TRANSUP_FAIL;
                } else {
                    ebStatus = EbStatus.BANK_FAIL.getName();
                    ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_FAIL;
                }
            } else if (bankState == PaymentState.SUCCESS) {
                boolean isLastTransUp;
                boolean isLastPay = LinkPayStepHelper.isLastPay(linkPaymentInfo, paymentInfo);
                boolean bl2 = isLastTransUp = linkPaymentInfo.getChildAcnt1().equalsIgnoreCase(paymentInfo.getAccNo()) && linkPaymentInfo.getParentAcnt().equalsIgnoreCase(paymentInfo.getIncomeAccNo());
                if (isLastPay) {
                    ebStatus = EbStatus.BANK_SUCCESS.getName();
                    ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_SUCCESS;
                } else if (isLastTransUp) {
                    ebStatus = EbStatus.BANK_FAIL.getName();
                    ebStatusMsg = isManual ? LinkPayUtils.LINKPAY_STATUS_FAIL_TRANSUP_SUCCESS_MANUAL : LinkPayUtils.LINKPAY_STATUS_FAIL_TRANSUP_SUCCESS;
                } else {
                    ebStatus = EbStatus.BANK_PROCESSING.getName();
                    ebStatusMsg = isForward ? LinkPayUtils.LINKPAY_STATUS_PROCESSING : LinkPayUtils.LINKPAY_STATUS_FAIL_TRANSUP;
                }
            } else if (isStep1) {
                ebStatus = EbStatus.EB_PROCESSING.getName();
                ebStatusMsg = LinkPayUtils.LINKPAY_STATUS_ACCEPTED;
            }
            boolean flag = ebStatus == null || ebStatusMsg == null;
            String origin_EbStatus = linkPaymentInfo.getEbStatus();
            String origin_EbStatusMsg = linkPaymentInfo.getEbStatusMsg();
            boolean statusFlag = true;
            if (linkPaymentInfo != null && ebStatus != null && ebStatusMsg != null) {
                if (origin_EbStatus != null) {
                    statusFlag = origin_EbStatus.equalsIgnoreCase(ebStatus);
                }
                if (origin_EbStatusMsg != null) {
                    statusFlag = origin_EbStatusMsg.equalsIgnoreCase(ebStatusMsg);
                }
            } else {
                statusFlag = false;
            }
            if (flag || statusFlag) {
                logger.info("\u8054\u52a8\u652f\u4ed8\u72b6\u6001\u4fe1\u606f\u672a\u53d8\u66f4\uff0c\u65e0\u9700\u66f4\u65b0\u6570\u636e\u5e93\u72b6\u6001");
            }
        }
        linkPaymentInfo.setEbStatus(ebStatus);
        linkPaymentInfo.setEbStatusMsg(ebStatusMsg);
        logger.info("\u66f4\u65b0\u8054\u52a8\u652f\u4ed8\u72b6\u6001\u7801\uff1a" + ebStatus + ", \u72b6\u6001\u4fe1\u606f\uff1a" + ebStatusMsg);
    }

    public static List<QueryLinkPayDetail> queryLinkPaymentDetails(List<LinkPaymentInfo> linkPaymentInfos) {
        ArrayList<QueryLinkPayDetail> result = new ArrayList<QueryLinkPayDetail>(1);
        PaymentInfoService paymentInfoService = PaymentInfoService.getInstance();
        for (LinkPaymentInfo info : linkPaymentInfos) {
            QueryLinkPayDetail queryLinkPayDetail = new QueryLinkPayDetail();
            result.add(queryLinkPayDetail);
            String linkPayType = info.getLinkpayType();
            List paymentInfos = paymentInfoService.selectByBatchSeqIDAndLinkpayDetailSeqId(info.getBatchSeqId(), info.getDetailSeqId());
            ArrayList<LinkPayDetail> bankDetailMessageDetails = new ArrayList<LinkPayDetail>(1);
            AtomicBoolean isHasSubmitting = new AtomicBoolean(false);
            paymentInfos.forEach(paymentInfo -> {
                Duration duration;
                long minutes;
                LocalDateTime submitSuccessTime = paymentInfo.getSubmitSuccessTime();
                if (submitSuccessTime != null && (minutes = (duration = Duration.between(submitSuccessTime, LocalDateTime.now())).toMinutes()) > 20L && paymentInfo.getStatus().intValue() == PaymentState.SUBMITTING.getId()) {
                    paymentInfo.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                    paymentInfo.setStatusName(PaymentState.UNKNOWN.getEnName());
                    paymentInfo.setStatusMsg(PaymentState.UNKNOWN.getCnName());
                    isHasSubmitting.set(true);
                }
            });
            if (isHasSubmitting.get()) {
                paymentInfos = paymentInfoService.save(paymentInfos);
            }
            for (PaymentInfo paymentInfo2 : paymentInfos) {
                PayDetail payDetail = InfoConvertUtils.converPaymentInfo2PaymentDetail(paymentInfo2);
                LinkPayDetail linkPayDetail = LinkPayUtils.convertPaymentDetail2LinkPayDetail(payDetail);
                linkPayDetail.setPayerAccNo(paymentInfo2.getAccNo());
                linkPayDetail.setPayerAccName(paymentInfo2.getAccName());
                linkPayDetail.setType(paymentInfo2.getLinkpayType());
                linkPayDetail.setKdFlagID(paymentInfo2.getKdFlagID());
                linkPayDetail.setAbstractMsg(paymentInfo2.getAbstractMsg());
                LinkPayStepHelper.setOrigalDetailSeqId(info, linkPayDetail);
                bankDetailMessageDetails.add(linkPayDetail);
                if (linkPayType.equalsIgnoreCase(paymentInfo2.getLinkpayType())) {
                    LinkPayStepHelper.updateLinkPayState(info, paymentInfo2);
                    if (paymentInfo2.getStatus().intValue() == PaymentState.SUCCESS.getId() || paymentInfo2.getStatus().intValue() == PaymentState.FAIL.getId()) {
                        ArrayList<PaymentInfo> nextPaymentInfos = new ArrayList<PaymentInfo>(1);
                        nextPaymentInfos.add(paymentInfo2);
                        LinkPayStepHelper.doNextStep(nextPaymentInfos);
                    } else {
                        LinkPaymentInfoService service = LinkPaymentInfoService.getInstance();
                        ArrayList<LinkPaymentInfo> updateList = new ArrayList<LinkPaymentInfo>(1);
                        updateList.add(info);
                        service.updateLinkPaymentInfo(updateList);
                    }
                }
                queryLinkPayDetail.setStatus(info.getEbStatus());
                queryLinkPayDetail.setStatusMsg(info.getEbStatusMsg());
                queryLinkPayDetail.setDetailBizNo(info.getDetailBizNo());
                queryLinkPayDetail.setDetailSeqID(info.getDetailSeqId());
            }
            String transDownBankDetailId = "";
            for (LinkPayDetail linkPayDetail : bankDetailMessageDetails) {
                if (!linkPayDetail.getType().equalsIgnoreCase("linkPay_transDown")) continue;
                transDownBankDetailId = linkPayDetail.getBankDetailSeqId();
            }
            for (LinkPayDetail linkPayDetail : bankDetailMessageDetails) {
                if (!linkPayDetail.getType().equalsIgnoreCase("linkPay_pay") || StringUtils.isEmpty((String)transDownBankDetailId)) continue;
                linkPayDetail.setLastBankDetailSeqId(transDownBankDetailId);
            }
            queryLinkPayDetail.setDetails(bankDetailMessageDetails);
        }
        return result;
    }

    private static void setOrigalDetailSeqId(LinkPaymentInfo info, LinkPayDetail detail) {
        if (detail.getType().equalsIgnoreCase("linkPay_transDown")) {
            if (!detail.getEbStatus().equalsIgnoreCase(EbStatus.BANK_SUCCESS.getName())) {
                detail.setDetailSeqID(info.getDetailSeqId());
                if (StringUtils.isEmpty((String)detail.getEbStatusMsg())) {
                    detail.setEbStatusMsg(info.getEbStatusMsg());
                }
            }
        } else if ((detail.getType().equalsIgnoreCase("linkPay_pay") || detail.getType().equalsIgnoreCase("linkPay_native")) && StringUtils.isEmpty((String)detail.getEbStatusMsg())) {
            detail.setEbStatusMsg(info.getEbStatusMsg());
        }
    }

    private static boolean isLastPay(LinkPaymentInfo linkPaymentInfo, PaymentInfo paymentInfo) {
        String lastChildAcnt = LinkPayUtils.getLastChildAcnt(linkPaymentInfo);
        boolean isLastPay = lastChildAcnt.equalsIgnoreCase(paymentInfo.getAccNo()) && linkPaymentInfo.getPayeeAccNo().equalsIgnoreCase(paymentInfo.getIncomeAccNo());
        return isLastPay;
    }

    private static PaymentInfo getNextPaymentWhenFail(List<LinkPaymentInfo> linkPaymentInfos, PaymentInfo paymentInfo) {
        boolean needTransUp = LinkPayStepHelper.isLastPay(linkPaymentInfos.get(0), paymentInfo);
        String bankVersion = paymentInfo.getBankVersionID();
        String linkPayConfig = InfoConvertUtils.getLinkPayConfig(bankVersion);
        if (!needTransUp) {
            return null;
        }
        String curPayerAcnt = paymentInfo.getAccNo();
        logger.info("\u5f53\u524d\u4e1a\u52a1\u4ed8\u6b3e\u4eba\u8d26\u53f7\uff1a" + curPayerAcnt + ", \u6536\u6b3e\u4eba\u8d26\u53f7\uff1a" + paymentInfo.getIncomeAccNo());
        boolean isBack = "linkPay_transUp".equalsIgnoreCase(paymentInfo.getLinkpayType());
        if (isBack) {
            logger.info("\u5f53\u524d\u4e1a\u52a1(\u4e0a\u5212)\u5931\u8d25, \u653e\u5f03\u5904\u7406\uff08\u4e0d\u91cd\u8bd5\uff09\u3002");
            return null;
        }
        logger.info("\u5f53\u524d\u4e1a\u52a1\u5931\u8d25\uff0c\u5c06\u6267\u884c\u8d44\u91d1\u4e0a\u5212");
        String[] linkPayAcnts = LinkPayStepHelper.filterNullAcnts(linkPaymentInfos.get(0));
        String nextPayerAcnt = curPayerAcnt;
        String nextPayeeAcnt = null;
        for (int i = 0; i < linkPayAcnts.length; ++i) {
            if (!nextPayerAcnt.equalsIgnoreCase(linkPayAcnts[i])) continue;
            if (i - 1 < 0 || linkPayAcnts[i - 1] == null) break;
            nextPayeeAcnt = linkPayAcnts[i - 1];
            break;
        }
        logger.info("\u4e0b\u4e00\u6b65\u4e1a\u52a1\u4ed8\u6b3e\u4eba\u8d26\u53f7\uff1a" + nextPayerAcnt + ", \u6536\u6b3e\u4eba\u8d26\u53f7\uff1a" + nextPayeeAcnt);
        if (nextPayeeAcnt == null) {
            logger.info("\u4e0b\u4e00\u4e2a\u6536\u6b3e\u4eba\u4e3a\u7a7a, \u8054\u52a8\u652f\u4ed8\u4e1a\u52a1\u7ed3\u675f\uff0c\u8fd4\u56de\u3002");
            return null;
        }
        logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u4e0a\u5212]\u7684PaymentInfo\u5bf9\u8c61, \u4ed8\u6b3e\u8d26\u53f7\uff1a" + nextPayerAcnt + ", \u6536\u6b3e\u8d26\u53f7\uff1a" + nextPayeeAcnt);
        PaymentInfo nextPaymentInfo = InfoConvertUtils.convert4TransUp(linkPaymentInfos.get(0), nextPayerAcnt, nextPayeeAcnt, linkPayConfig);
        return nextPaymentInfo;
    }

    private static List<PaymentInfo> getNextPaymentWhenSuccess(List<LinkPaymentInfo> linkPaymentInfos, PaymentInfo paymentInfo) {
        int i;
        String curPayerAcnt = paymentInfo.getAccNo();
        String curPayeeAcnt = paymentInfo.getIncomeAccNo();
        String bankVersion = paymentInfo.getBankVersionID();
        String linkPayConfig = InfoConvertUtils.getLinkPayConfig(bankVersion);
        logger.info("\u5f53\u524d\u4e1a\u52a1\u4ed8\u6b3e\u4eba\u8d26\u53f7\uff1a" + curPayerAcnt + ", \u6536\u6b3e\u4eba\u8d26\u53f7\uff1a" + curPayeeAcnt);
        logger.info("\u5f53\u524d\u4e1a\u52a1\u6210\u529f\uff0c\u5c06\u6267\u884c\u4e0b\u4e00\u6b65\u4ea4\u6613");
        boolean isForward = "linkPay_transDown".equalsIgnoreCase(paymentInfo.getLinkpayType()) || "linkPay_pay".equalsIgnoreCase(paymentInfo.getLinkpayType());
        String nextPayeeAcnt = null;
        String nextPayerAcnt = curPayeeAcnt;
        String[] linkPayAcnts = LinkPayStepHelper.filterNullAcnts(linkPaymentInfos.get(0));
        if (isForward) {
            for (i = 0; i < linkPayAcnts.length; ++i) {
                if (!linkPayAcnts[i].equalsIgnoreCase(nextPayerAcnt) || i + 1 >= linkPayAcnts.length) continue;
                nextPayeeAcnt = linkPayAcnts[i + 1];
            }
        } else {
            for (i = 0; i < linkPayAcnts.length; ++i) {
                if (!linkPayAcnts[i].equalsIgnoreCase(nextPayerAcnt) || i - 1 < 0) continue;
                nextPayeeAcnt = linkPayAcnts[i - 1];
            }
        }
        if (nextPayerAcnt == null || nextPayeeAcnt == null) {
            logger.info("\u4e0b\u4e00\u4e2a\u6536\u6b3e\u4eba\u4e3a\u7a7a, \u8054\u52a8\u652f\u4ed8\u4e1a\u52a1\u7ed3\u675f\uff0c\u8fd4\u56de\u3002");
            return null;
        }
        logger.info("\u4e0b\u4e00\u6b65\u4e1a\u52a1\u4ed8\u6b3e\u4eba\u8d26\u53f7\uff1a" + nextPayerAcnt + ", \u6536\u6b3e\u4eba\u8d26\u53f7\uff1a" + nextPayeeAcnt);
        ArrayList<PaymentInfo> nextPaymentInfos = new ArrayList<PaymentInfo>(1);
        if (nextPayeeAcnt.equalsIgnoreCase(linkPaymentInfos.get(0).getPayeeAccNo())) {
            for (LinkPaymentInfo linkPaymentInfo : linkPaymentInfos) {
                logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u5bf9\u5916\u652f\u4ed8]\u7684PaymentInfo\u5bf9\u8c61, \u4ed8\u6b3e\u8d26\u53f7\uff1a" + nextPayerAcnt + ", \u6536\u6b3e\u8d26\u53f7\uff1a" + linkPaymentInfo.getPayeeAccNo());
                PaymentInfo nextPaymentInfo = InfoConvertUtils.convert4Pay(linkPaymentInfo, nextPayerAcnt);
                logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u5bf9\u5916\u652f\u4ed8]\u7684PaymentInfo\u5bf9\u8c61\u6210\u529f");
                nextPaymentInfos.add(nextPaymentInfo);
            }
        } else if (isForward) {
            logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u4e0b\u62e8]\u7684PaymentInfo\u5bf9\u8c61, \u4ed8\u6b3e\u8d26\u53f7\uff1a" + nextPayerAcnt + ", \u6536\u6b3e\u8d26\u53f7\uff1a" + nextPayeeAcnt);
            PaymentInfo nextPaymentInfo = InfoConvertUtils.convert4TransDown(linkPaymentInfos.get(0), nextPayerAcnt, nextPayeeAcnt, linkPayConfig);
            logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u4e0b\u62e8]\u7684PaymentInfo\u5bf9\u8c61\u5b8c\u6210");
            nextPaymentInfos.add(nextPaymentInfo);
        } else {
            logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u4e0a\u5212]\u7684PaymentInfo\u5bf9\u8c61, \u4ed8\u6b3e\u8d26\u53f7\uff1a" + nextPayerAcnt + ", \u6536\u6b3e\u8d26\u53f7\uff1a" + nextPayeeAcnt);
            PaymentInfo nextPaymentInfo = InfoConvertUtils.convert4TransUp(linkPaymentInfos.get(0), nextPayerAcnt, nextPayeeAcnt, linkPayConfig);
            logger.info("\u628aLinkPaymentInfo\u8f6c\u4e3a[\u4e0a\u5212]\u7684PaymentInfo\u5bf9\u8c61\u5b8c\u6210");
            nextPaymentInfos.add(nextPaymentInfo);
        }
        return nextPaymentInfos;
    }

    private static String[] filterNullAcnts(LinkPaymentInfo linkPaymentInfo) {
        String[] acnts = new String[]{linkPaymentInfo.getParentAcnt(), linkPaymentInfo.getChildAcnt1(), linkPaymentInfo.getChildAcnt2(), linkPaymentInfo.getChildAcnt3(), linkPaymentInfo.getChildAcnt4(), linkPaymentInfo.getChildAcnt5(), linkPaymentInfo.getPayeeAccNo()};
        ArrayList<String> acntList = new ArrayList<String>(1);
        for (String acnt : acnts) {
            if (StringUtils.isEmpty((String)acnt)) continue;
            acntList.add(acnt);
        }
        return acntList.toArray(new String[0]);
    }
}

