/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankPayTask;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

class SubmitPayRunnale
implements Runnable {
    EBGLogger logger = EBGLogger.getInstance().getLogger(SubmitPayRunnale.class);
    Set<List<PaymentInfo>> set;
    EBRequest payRequest;
    Map<String, BankAcnt> bankAcntMap;
    Map<String, String> bankCurrencyMap;

    public SubmitPayRunnale(Set<List<PaymentInfo>> set, EBRequest payRequest) {
        this.set = set;
        this.payRequest = payRequest;
        this.bankAcntMap = new HashMap<String, BankAcnt>(16);
        this.bankCurrencyMap = new HashMap<String, String>(16);
    }

    private BankAcnt getBankAcnt(PaymentInfo info) {
        String accNo = info.getAccNo();
        if (this.bankAcntMap.containsKey(accNo)) {
            return this.bankAcntMap.get(accNo);
        }
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, info.getCustomID());
        this.bankAcntMap.put(accNo, acnt);
        return acnt;
    }

    private String getBankCurrency(PaymentInfo info, BankAcnt acnt) {
        String accNo = info.getAccNo();
        if (this.bankCurrencyMap.containsKey(accNo)) {
            return this.bankCurrencyMap.get(accNo);
        }
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        this.bankCurrencyMap.put(accNo, bankCurrency);
        return bankCurrency;
    }

    @Override
    public void run() {
        String extDate = this.payRequest.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<PaymentInfo> infos : this.set) {
            String bizType;
            PaymentInfo paymentInfo = infos.get(0);
            BankAcnt acnt = this.getBankAcnt(paymentInfo);
            String bankCurrency = this.getBankCurrency(paymentInfo, acnt);
            BankPayRequest request = PaymentUtil.prepareBankPayRequest(infos, acnt, bankCurrency);
            String bankVersion = paymentInfo.getBankVersionID();
            String subBizType = bizType = this.payRequest.getHeader().getBizType();
            if (StringUtils.isNotEmpty((String)paymentInfo.getLinkpayType())) {
                subBizType = "linkPay";
            }
            String customerId = paymentInfo.getCustomID();
            String batchSeqId = paymentInfo.getBatchSeqId();
            String requestSeqId = "";
            requestSeqId = this.payRequest.getHeader().getRequestSeqID() == null ? Sequence.genSequence() : String.valueOf(this.payRequest.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(System.currentTimeMillis());
            String logBizSeqId = String.valueOf(this.payRequest.getHeader().getLogBizSeqID());
            String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
            if (StringUtils.isEmpty((String)loggerBankNo)) {
                loggerBankNo = paymentInfo.getBankBatchSeqID();
            }
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(paymentInfo.getBankLoginID()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(paymentInfo.getBankBatchSeqID()).loggerBankNo(loggerBankNo).build();
            context.setBankAcnt(request.getHeader().getAcnt());
            EBContext.setContext((EBContext)context);
            String bankBatchSeqID = paymentInfo.getBankBatchSeqID();
            if (CachePayStorage.checkSubmitLock(bankBatchSeqID)) {
                this.logger.info(String.format("\u4ed8\u6b3e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u4ed8\u6b3e\u4efb\u52a1\u4e0d\u63d0\u4ea4\u4ed8\u6b3e\u7ebf\u7a0b\u6c60", bankBatchSeqID));
                continue;
            }
            String taskID = EBThreadPools.createBizTask(context);
            BankPayTask bankPayTask = new BankPayTask(request, context);
            bankPayTask.setTaskId(taskID);
            EBThreadPools.getPayThreadPool(customerId, bankLoginId).submit((Callable)((Object)bankPayTask));
        }
    }
}

