/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbb.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbb.dc.service.payment.salary.QueryPayImpl;
import kd.ebg.aqap.banks.hbb.dc.util.HeadPacker;
import kd.ebg.aqap.banks.hbb.dc.util.HeadParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl {
    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/eb2e-transfer.PaySalaryUpload.do?";
        s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userPassword") + "&SIGDATA=1&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)HeadPacker.buildHead("eb2e-transfer.PaySalaryUpload", paymentInfos[0].getBankBatchSeqId()));
        BigDecimal sumAmount = new BigDecimal("0");
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"payerAcNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"totalNum", (String)(paymentInfos.length + ""));
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        JDomUtils.addChild((Element)body, (String)"releaseMonth", (String)(month + ""));
        JDomUtils.addChild((Element)body, (String)"entryDate", (String)DateUtil.formatDate((Date)new Date()));
        if (StringUtils.isEmpty((String)paymentInfos[0].getExplanation())) {
            JDomUtils.addChild((Element)body, (String)"purpose", (String)ResManager.loadKDString((String)"\u4ee3\u53d1", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]));
        } else {
            JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfos[0].getExplanation());
        }
        Element list = JDomUtils.addChild((Element)body, (String)"detailList");
        for (int j = 0; j < paymentInfos.length; ++j) {
            Element map = JDomUtils.addChild((Element)list, (String)"map");
            BigDecimal amount = paymentInfos[j].getAmount();
            sumAmount = sumAmount.add(amount);
            JDomUtils.addChild((Element)map, (String)"key1Seq", (String)(j + 1 + ""));
            JDomUtils.addChild((Element)map, (String)"key2AcNo", (String)paymentInfos[j].getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"key3AcName", (String)paymentInfos[j].getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"key4NetSalary", (String)paymentInfos[j].getAmount().toString());
            JDomUtils.addChild((Element)map, (String)"key5Postscript", (String)paymentInfos[j].getExplanation());
        }
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)sumAmount.toString());
        String requestXml = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return requestXml;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = HeadParser.parserCommonInfo(root);
        if (!"00000000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getBizCode() {
        return "PaySalaryUpload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u7533\u8bf7\uff08eb2e-transfer. PaySalaryUpload\uff09", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-hbb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

