/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay;

import java.sql.Timestamp;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.QueryPayPacker;
import kd.ebg.aqap.banks.ceb.dc.services.payment.batchindividualpay.QueryPayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class BatchIndividualQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 2000;
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "b2e005010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ee3\u53d1\u7ed3\u679c", (String)"BatchIndividualQueryPayImpl_0", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Long submitSuccessTime = Timestamp.valueOf(((PaymentInfo)request.getPaymentInfos().get(0)).getSubmitSuccessTime()).getTime();
        Long now = System.currentTimeMillis();
        if ((now - submitSuccessTime) / 60000L < 2L) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u4ea4\u6613\u5904\u7406\u4e2d", (String)"BatchIndividualQueryPayImpl_1", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        return super.doBiz(request);
    }

    public String pack(BankPayRequest request) {
        return QueryPayPacker.packQueryPay(request.getPaymentInfos());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return QueryPayParser.parseQueryPay(request.getPaymentInfos(), responseStr);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder builder = new StringBuilder();
        builder.append("/ent/b2e005010.do").append("?userPassword=").append(RequestContextUtils.getBankParameterValue((String)"UserPassword")).append("&Sigdata=").append("1");
        factory.setUri(builder.toString());
        return factory;
    }
}

