/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.payment.salary;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.GzrcbFileUploadImpl;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.PackerUtil;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    private static final String FILE_SUFIX = ".dat";

    public String packPay(PaymentInfo[] paymentInfos, String bizSeqId) throws EBServiceException {
        GzrcbFileUploadImpl util = new GzrcbFileUploadImpl(paymentInfos);
        PaymentInfo info = paymentInfos[0];
        String fileName = info.getBankBatchSeqId() + FILE_SUFIX;
        if (!util.uploadFile(fileName)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\uff1a%1$s\u5931\u8d25\u3002", (String)"PayPacker_2", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]), fileName));
        }
        String uploadDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Element body = PackerUtil.buildBody();
        JDomUtils.addChild((Element)body, (String)"DANWZH", (String)info.getAccNo());
        JDomUtils.addChild((Element)body, (String)"DANWBH", (String)BankBusinessConfig.getUnitNo(info.getAccNo()));
        JDomUtils.addChild((Element)body, (String)"PLSFBZ", (String)"1");
        JDomUtils.addChild((Element)body, (String)"JSCLBZ", (String)(info.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"ZHBUBZ", (String)"0");
        JDomUtils.addChild((Element)body, (String)"ZHBUHO", (String)"");
        JDomUtils.addChild((Element)body, (String)"ZHBUMC", (String)"");
        JDomUtils.addChild((Element)body, (String)"YONGTU", (String)info.getUseCn());
        JDomUtils.addChild((Element)body, (String)"FUJYAN", (String)info.getExplanation());
        JDomUtils.addChild((Element)body, (String)"ZHYODM", (String)"B00345");
        JDomUtils.addChild((Element)body, (String)"HUOBDH", (String)info.getCurrency());
        String testTransDate = RequestContextUtils.getBankParameterValue((String)"test_transDate");
        if (!StringUtils.isEmpty((String)testTransDate)) {
            JDomUtils.addChild((Element)body, (String)"OPDATE", (String)testTransDate);
        } else {
            JDomUtils.addChild((Element)body, (String)"OPDATE", (String)uploadDate);
        }
        JDomUtils.addChild((Element)body, (String)"ZYWWTH", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"ZONGJE", (String)PackerUtils.getTotalAmount((PaymentInfo[])paymentInfos));
        JDomUtils.addChild((Element)body, (String)"ZBISHU", (String)(paymentInfos.length + ""));
        JDomUtils.addChild((Element)body, (String)"FILENM", (String)fileName);
        JDomUtils.addChild((Element)body, (String)"SHBHAO", (String)"");
        StringBuilder builder = new StringBuilder();
        builder.append(RequestContextUtils.getBankParameterValue((String)"userNo")).append("|").append(info.getAccNo()).append("|").append(BankBusinessConfig.getUnitNo(info.getAccNo())).append("|").append(PackerUtils.getTotalAmount((PaymentInfo[])paymentInfos)).append("|").append(paymentInfos.length);
        PackerUtil.setSignPlainText(body, builder.toString());
        return PackerUtil.getPackedStr("YQ271", PackerUtil.buildRoot(body, info.getBankBatchSeqId()));
    }
}

