/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.payment.salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.salary.PayPacker;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.salary.PayParser;
import kd.ebg.aqap.banks.gzrcb.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(SalaryPayImpl.class);
    PayPacker payPacker = new PayPacker();
    PayParser payParser = new PayParser();

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "kiki";
    }

    public String getBizCode() {
        return "YQ271";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u4e1a\u52a1", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equals(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        String bizSeqId = request.getHeader().getBizSeqID();
        int size = request.getPaymentInfos().size();
        return this.payPacker.packPay(request.getPaymentInfos().toArray(new PaymentInfo[size]), bizSeqId);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        int size = request.getPaymentInfos().size();
        return this.payParser.parsePay(request.getPaymentInfos().toArray(new PaymentInfo[size]), responseStr);
    }
}

