/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.dc.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class GzipUtil {
    static final EBGLogger logger = EBGLogger.getInstance().getLogger(GzipUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(byte[] data) throws Exception {
        ByteArrayOutputStream bos = null;
        DeflaterOutputStream gzip = null;
        try {
            byte[] ret;
            bos = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(bos);
            gzip.write(data);
            ((GZIPOutputStream)gzip).finish();
            byte[] byArray = ret = bos.toByteArray();
            return byArray;
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String gzipAndEncoder(String fileContent) {
        String string;
        FileInputStream in = null;
        try {
            String encoderString;
            if (StringUtils.isEmpty((String)fileContent)) {
                String string2 = null;
                return string2;
            }
            byte[] datas = fileContent.getBytes(RequestContextUtils.getCharset());
            logger.info("\u539f\u59cb\u6587\u4ef6\u5927\u5c0f:" + datas.length);
            byte[] ret1 = GzipUtil.gzip(datas);
            logger.info("\u538b\u7f29\u4e4b\u540e\u6587\u4ef6\u5927\u5c0f:" + ret1.length);
            BASE64Encoder encoder = new BASE64Encoder();
            string = encoderString = encoder.encode(ret1);
        }
        catch (Exception e) {
            logger.error("gzip\u538b\u7f29\u6587\u4ef6\u5185\u5bb9\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u538b\u7f29\u6587\u4ef6\u5f02\u5e38", (String)"GzipUtil_0", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static byte[] ungzipAndEncoder(String src) {
        byte[] byArray;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gzip = null;
        try {
            if (src == null || src.length() == 0) {
                byte[] byArray2 = null;
                return byArray2;
            }
            BASE64Decoder decoder = new BASE64Decoder();
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(decoder.decodeBuffer(src));
            gzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            int bSize = 0;
            while ((bSize = gzip.read(buffer)) >= 0) {
                out.write(buffer, 0, bSize);
            }
            gzip.close();
            byArray = out.toByteArray();
        }
        catch (IOException e) {
            logger.error("\u89e3\u538b\u7f29\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u538b\u7f29\u6587\u4ef6\u5185\u5bb9\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\u3002", (String)"GzipUtil_1", (String)"ebg-aqap-banks-gxnx-dc", (Object[])new Object[0]));
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }
}

