/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.dc.util.KDUtil;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public boolean match(BankDetailRequest request) {
        return !BankBusinessConfig.isDetailWithPage();
    }

    public String pack(BankDetailRequest request) {
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0024", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"queryType", (String)"0");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element message = JDomUtils.getChildElement((Element)root, (String)"Message");
        Element commHead = JDomUtils.getChildElement((Element)message, (String)"commHead");
        String retCode = JDomUtils.getChildText((Element)commHead, (String)"retCode");
        Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
        log.info("retCode:" + retCode);
        if ("000".equalsIgnoreCase(retCode)) {
            if (null != body) {
                String account = JDomUtils.getChildText((Element)body, (String)"account");
                String totalNum = JDomUtils.getChildText((Element)body, (String)"totalNum");
                log.info("totalNum:" + totalNum);
                BankAcnt bankAcnt = request.getAcnt();
                if (!bankAcnt.getAccNo().equalsIgnoreCase(account)) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7(%1$s)\u4e0e\u8fd4\u56de\u8d26\u53f7(%2$s)\u4e0d\u4e00\u81f4\uff1b", (String)"DetailImpl_8", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), bankAcnt.getAccNo(), account));
                }
                Element records = JDomUtils.getChildElement((Element)body, (String)"records");
                if (records == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u8bb0\u5f55\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
                }
                List recordList = records.getChildren("record");
                HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
                if (recordList != null && recordList.size() > 0) {
                    for (Element record : recordList) {
                        String bankDetailSeqId;
                        String serialNo = JDomUtils.getChildText((Element)record, (String)"serialNo");
                        String dealDate = JDomUtils.getChildText((Element)record, (String)"dealDate");
                        String loanSign = JDomUtils.getChildText((Element)record, (String)"loanSign");
                        String dealMoney = JDomUtils.getChildText((Element)record, (String)"dealMoney");
                        String financingSymbol = JDomUtils.getChildText((Element)record, (String)"financingSymbol");
                        String usableMoney = JDomUtils.getChildText((Element)record, (String)"usableMoney");
                        String abstractStr = JDomUtils.getChildText((Element)record, (String)"abstract");
                        String dealBranch = JDomUtils.getChildText((Element)record, (String)"dealBranch");
                        String upBill = JDomUtils.getChildText((Element)record, (String)"upBill");
                        String oppoAccno = JDomUtils.getChildText((Element)record, (String)"oppoAccno");
                        String name = JDomUtils.getChildText((Element)record, (String)"name");
                        String dealTime = JDomUtils.getChildText((Element)record, (String)"dealTime");
                        String abstractContent = JDomUtils.getChildText((Element)record, (String)"abstractContent");
                        String dealChannel = JDomUtils.getChildText((Element)record, (String)"dealChannel");
                        String summary = JDomUtils.getChildText((Element)record, (String)"summary");
                        String postScript = JDomUtils.getChildText((Element)record, (String)"postScript");
                        String reserve1 = JDomUtils.getChildText((Element)record, (String)"reserve1");
                        String reserve2 = JDomUtils.getChildText((Element)record, (String)"reserve2");
                        String reserve3 = JDomUtils.getChildText((Element)record, (String)"reserve3");
                        String reserve4 = JDomUtils.getChildText((Element)record, (String)"reserve4");
                        DetailInfo detailInfo = new DetailInfo();
                        detailInfo.setAccNo(bankAcnt.getAccNo());
                        detailInfo.setAccName(bankAcnt.getAccName());
                        detailInfo.setBankName(bankAcnt.getBankName());
                        detailInfo.setBankVersionID(bankAcnt.getBankVersionId());
                        detailInfo.setBankLoginID(bankAcnt.getBankLoginId());
                        detailInfo.setOppAccNo(oppoAccno);
                        detailInfo.setOppAccName(name);
                        detailInfo.setCurrency(request.getHeader().getBankCurrency());
                        if ("+".equalsIgnoreCase(loanSign)) {
                            if ("-".equalsIgnoreCase(financingSymbol)) {
                                detailInfo.setCreditAmount(new BigDecimal(dealMoney).multiply(new BigDecimal(-1)));
                            } else {
                                detailInfo.setCreditAmount(new BigDecimal(dealMoney));
                            }
                            detailInfo.setDebitAmount(new BigDecimal("0.00"));
                        }
                        if ("-".equalsIgnoreCase(loanSign)) {
                            if ("-".equalsIgnoreCase(financingSymbol)) {
                                detailInfo.setDebitAmount(new BigDecimal(dealMoney).multiply(new BigDecimal(-1)));
                            } else {
                                detailInfo.setDebitAmount(new BigDecimal(dealMoney));
                            }
                            detailInfo.setCreditAmount(new BigDecimal("0.00"));
                        }
                        if (!StringUtils.isEmpty((String)dealDate)) {
                            detailInfo.setTransDate(LocalDate.parse(dealDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                            try {
                                if (!StringUtils.isEmpty((String)dealTime)) {
                                    detailInfo.setTransTime(LocalDateTime.parse(dealDate + dealTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                                }
                                detailInfo.setTransTime(LocalDateTime.parse(dealDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            }
                            catch (DateTimeParseException e) {
                                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1a\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (Throwable)e);
                            }
                        } else {
                            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5b8c\u6210\u94f6\u884c\u4ea4\u6613\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
                        }
                        if (!StringUtils.isEmpty((String)usableMoney)) {
                            detailInfo.setBalance(new BigDecimal(usableMoney));
                        }
                        if (StringUtils.isEmpty((String)(bankDetailSeqId = KDUtil.getBankDetailSeqIdFromStr(postScript)))) {
                            bankDetailSeqId = KDUtil.getBankDetailSeqIdFromStr(summary);
                            if (StringUtils.isEmpty((String)bankDetailSeqId)) {
                                bankDetailSeqId = KDUtil.getBankDetailSeqIdFromStr(abstractContent);
                            } else {
                                summary = KDUtil.cutKDFlag(summary);
                            }
                        } else {
                            postScript = KDUtil.cutKDFlag(postScript);
                        }
                        if (!StringUtils.isEmpty((String)bankDetailSeqId)) {
                            DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)bankDetailSeqId);
                            detailInfo.setKdFlag(bankDetailSeqId);
                            detailInfo.setPayBankDetailSeqID(bankDetailSeqId);
                        }
                        if (!StringUtils.isEmpty((String)postScript)) {
                            if (!StringUtils.isEmpty((String)summary)) {
                                detailInfo.setExplanation(postScript + "-" + summary);
                            } else {
                                detailInfo.setExplanation(postScript);
                            }
                        } else {
                            detailInfo.setExplanation(summary);
                        }
                        detailInfo.setBankDetailNo(reserve2);
                        String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                        detailInfo.setJsonMap(jsonStr);
                        String accNo = request.getHeader().getAcnt().getAccNo();
                        String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                        String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                        if (countMap.containsKey(receiptNo)) {
                            int count = (Integer)countMap.get(receiptNo) + 1;
                            countMap.put(receiptNo, count);
                            receiptNo = receiptNo + "-" + String.format("%04d", count);
                        } else {
                            countMap.put(receiptNo, 0);
                        }
                        detailInfo.setReceiptNo(receiptNo);
                        result.add(detailInfo);
                    }
                }
            } else {
                log.info("\u94f6\u884c\u8fd4\u56de body \u4e3a\u7a7a");
            }
        } else if ("242".equalsIgnoreCase(retCode) || "251".equalsIgnoreCase(retCode)) {
            log.info("\u8fd4\u56de\u54cd\u5e94\u7801{},\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4ea4\u6613\u8bb0\u5f55", (Object)retCode);
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801:%S\u3002", (String)"DetailImpl_9", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), retCode));
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "0024";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_7", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

