/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ncb.dc.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ncb.dc.helper.Packer;
import kd.ebg.aqap.banks.ncb.dc.helper.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
    }

    public String getDeveloper() {
        return "lwc";
    }

    public String getBizCode() {
        return "0001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"4.1.\u5bf9\u516c\u6d3b\u671f\u5b58\u6b3e\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return this.packTodayBalance(bankBalanceRequest);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return this.parseTodayBalance(bankBalanceRequest, s);
    }

    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) {
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserCommonInfo(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
        BalanceInfo balanceInfo = new BalanceInfo();
        String accNo = JDomUtils.getChildText((Element)resBody, (String)"acct_no");
        String currency = JDomUtils.getChildText((Element)resBody, (String)"acct_curr");
        String balance = resBody.getChildText("balance");
        String availableBalance = resBody.getChildText("available_balance");
        this.setBankCurrency(balanceInfo, rqst.getBankCurrency(), currency);
        this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), accNo);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, availableBalance);
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        balanceInfos.add(balanceInfo);
        balanceRsp.setBalances(balanceInfos);
        return balanceRsp;
    }

    public String packTodayBalance(BankBalanceRequest rqst) {
        String accNo = rqst.getAcnt().getAccNo();
        Element root = Packer.buildHead("0001", Sequence.gen18Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("AcctNo", accNo);
        parameterMap.put("AcctCurr", rqst.getBankCurrency());
        Packer.buildBody(body, parameterMap);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }
}

