/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citi.dc.services.payment.swift;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.citi.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citi.dc.CitiMetaDataImpl;
import kd.ebg.aqap.banks.citi.dc.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        String bookDate;
        StringBuilder sb = new StringBuilder();
        String separator = System.getProperty("line.separator");
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        sb.append(BankBusinessConfig.getBicCode(paymentInfo.getAccNo())).append(separator).append("101").append(paymentInfo.getIncomeSwiftCode()).append(separator);
        sb.append(":20:").append(paymentInfo.getBankBatchSeqID()).append(separator);
        sb.append(":21R:").append(paymentInfo.getBankDetailSeqID()).append(separator);
        sb.append(":28D:").append("1/1").append(separator);
        sb.append(":50H:/").append(paymentInfo.getAccNo()).append(separator);
        sb.append(paymentInfo.getAccName()).append(separator);
        String payCompanyStreet = BankBusinessConfig.getPayCompanyStreet(paymentInfo.getAccNo());
        if (StringUtils.isNotEmpty((String)payCompanyStreet)) {
            if (payCompanyStreet.length() > 35) {
                sb.append(payCompanyStreet, 0, 35).append(separator);
                sb.append(payCompanyStreet.substring(35)).append(separator);
            } else {
                sb.append(payCompanyStreet).append(separator);
            }
        }
        if (StringUtils.isNotEmpty((String)(bookDate = paymentInfo.getBookingTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyMMdd"))))) {
            sb.append(":30:").append(bookDate).append(separator);
            PaymentUtil.setBookPayFlag((List)bankPayRequest.getPaymentInfos());
        } else {
            sb.append(":30:").append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyMMdd"))).append(separator);
        }
        sb.append(":21:").append(paymentInfo.getBankDetailSeqID()).append(separator);
        sb.append(":32B:").append(paymentInfo.getPayCurrency()).append(paymentInfo.getAmount().toPlainString().replaceAll("\\.", ",")).append(separator);
        sb.append(":59:/").append(paymentInfo.getIncomeAccNo()).append(separator);
        sb.append(paymentInfo.getIncomeAddress()).append(separator);
        if (paymentInfo.getPayerFeeType().equals("01")) {
            sb.append(":71A:OUR").append(separator);
        } else if (paymentInfo.getPayerFeeType().equals("02")) {
            sb.append(":71A:BEN").append(separator);
        } else if (paymentInfo.getPayerFeeType().equals("03")) {
            sb.append(":71A:SHA").append(separator);
        }
        this.logger.info("MT101\u62a5\u6587\uff1a{}", (Object)sb.toString());
        return sb.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getBankVersionID().equalsIgnoreCase("SWIFT_DC");
    }

    protected String getPayFileName(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String prefix = RequestContextUtils.getBankParameterValue((String)CitiMetaDataImpl.pay_file_name);
        String fileName = StringUtils.isNotEmpty((String)prefix) ? prefix + "_" + paymentInfo.getBankBatchSeqID() + ".xml" : paymentInfo.getBankBatchSeqID() + ".txt";
        this.logger.info("\u4ed8\u6b3e\u6587\u4ef6\u540dfileName:" + fileName);
        return fileName;
    }
}

