/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.services.detail;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.dc.utils.TCommon;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public String pack(BankDetailRequest request) {
        return this.packDetail(request);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List<DetailInfo> detailInfos = TodayDetailImpl.parseDetail(request.getAcnt().getAccNo(), responseStr);
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "STTQ0108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }

    private String packDetail(BankDetailRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        String trCode = "STTQ0108";
        Element Packet = TCommon.createCommonHead(trCode);
        Element Data = Packet.getChild("Data");
        Element Pag = JDomUtils.addChild((Element)Data, (String)"Pag");
        JDomUtils.addChild((Element)Pag, (String)"PgupOrPgdn", (String)"1");
        JDomUtils.addChild((Element)Pag, (String)"TotalNum", (String)"-1");
        JDomUtils.addChild((Element)Pag, (String)"CurrentNum", (String)"0");
        JDomUtils.addChild((Element)Pag, (String)"PageStart", (String)"0");
        JDomUtils.addChild((Element)Pag, (String)"PageEnd", (String)"0");
        JDomUtils.addChild((Element)Pag, (String)"IS_TOTAL_PAGES", (String)"0");
        Element Req = JDomUtils.addChild((Element)Data, (String)"Req");
        LocalDate startDate = rqst.getStartDate();
        LocalDate endDate = rqst.getEndDate();
        String beginDateStr = startDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        String endDateStr = endDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        String accNo = acnt.getAccNo();
        JDomUtils.addChild((Element)Req, (String)"BASE_ACCT_NO", (String)accNo);
        JDomUtils.addChild((Element)Req, (String)"ACCT_TYPE", (String)BankBusinessConfig.getAcnoType(accNo));
        JDomUtils.addChild((Element)Req, (String)"CCY", (String)rqst.getBankCurrency());
        JDomUtils.addChild((Element)Req, (String)"START_DATE", (String)beginDateStr);
        JDomUtils.addChild((Element)Req, (String)"END_DATE", (String)endDateStr);
        JDomUtils.addChild((Element)Req, (String)"REF_NO", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2String((Element)Packet, (String)encoding);
        return xmlMsg;
    }

    private static List<DetailInfo> parseDetail(String reqAccNo, String rspStr) {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element Packet = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element Data = Packet.getChild("Data");
        Element Pub = Data.getChild("Pub");
        BankResponse response = TCommon.parseBankResponse(Pub);
        if ("000305".equals(response.getResponseCode())) {
            return details;
        }
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"TodayDetailImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element Res = Data.getChild("Res");
        List list = Res.getChildren("TRAN_HIST_DETAIL");
        if (list == null || list.size() == 0) {
            logger.error("\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1aTRAN_HIST_DETAIL\u8282\u70b9\u4e3a\u7a7a");
            return details;
        }
        for (int i = 0; i < list.size(); ++i) {
            Element opResult = (Element)list.get(i);
            String accountCur = JDomUtils.getChildTextNotNull((Element)opResult, (String)"CCY");
            String amountStr = JDomUtils.getChildTextNotNull((Element)opResult, (String)"TRAN_AMT");
            String dOcFlag = JDomUtils.getChildTextNotNull((Element)opResult, (String)"CR_DR_MAINT_IND");
            String balanceStr = JDomUtils.getChildTextNotNull((Element)opResult, (String)"ACTUAL_BAL_AMT");
            String otherAcct = JDomUtils.getChildTextNotNull((Element)opResult, (String)"OTH_BASE_ACCT_NO");
            String otherAcctName = JDomUtils.getChildTextNotNull((Element)opResult, (String)"OTH_ACCT_NAME");
            String NARRATIVE = JDomUtils.getChildTextNotNull((Element)opResult, (String)"NARRATIVE");
            String TRAN_DATE = JDomUtils.getChildTextNotNull((Element)opResult, (String)"TRAN_DATE");
            String TRAN_TIME = JDomUtils.getChildTextNotNull((Element)opResult, (String)"TRAN_TIME");
            String otherSideBank = JDomUtils.getChildTextNullAsBlank((Element)opResult, (String)"OTH_BRANCH");
            String REFERENCE = JDomUtils.getChildTextNotNull((Element)opResult, (String)"REFERENCE");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setCurrency(accountCur);
            detailInfo.setOppAccNo(otherAcct);
            detailInfo.setOppAccName(otherAcctName);
            detailInfo.setOppBankName(otherSideBank);
            detailInfo.setTransTime(LocalDateTime.parse(TRAN_DATE + TRAN_TIME, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            BigDecimal amount = new BigDecimal(amountStr);
            if ("D".equalsIgnoreCase(dOcFlag)) {
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(amount);
            } else if ("C".equalsIgnoreCase(dOcFlag)) {
                detailInfo.setCreditAmount(amount);
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u51fa\u73b0\u4e86\u672a\u80fd\u8bc6\u522b\u7684\u501f\u8d37\u6807\u5fd7:%s\u3002", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), dOcFlag));
            }
            detailInfo.setBalance(new BigDecimal(balanceStr));
            detailInfo.setExplanation(NARRATIVE);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(opResult);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(REFERENCE);
            details.add(detailInfo);
        }
        logger.info("---\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f");
        return details;
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(TCommon.getHttpUrl("unsign"));
        factory.setHttpHeader("Content-Type", "text/plain");
        factory.setHttpHeader("Accept-Charset", "utf-8");
    }
}

