/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.services.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.dc.services.payment.company.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.cdb.dc.utils.BankStatusCode;
import kd.ebg.aqap.banks.cdb.dc.utils.CommonUtils;
import kd.ebg.aqap.banks.cdb.dc.utils.SignUtils;
import kd.ebg.aqap.banks.cdb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8", (String)"CompanyPaymentImpl_0", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !BankBusinessConfig.isPaymetByAuthorized();
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(TCommon.getHttpUrl("unsign"));
        factory.setHttpHeader("Content-Type", "text/plain");
        factory.setHttpHeader("Accept-Charset", "utf-8");
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        String trCode = "STCM1001";
        Element Packet = TCommon.createCommonHead(trCode);
        Element Data = Packet.getChild("Data");
        Element Req = JDomUtils.addChild((Element)Data, (String)"Req");
        JDomUtils.addChild((Element)Req, (String)"pay_acno", (String)info.getAccNo());
        JDomUtils.addChild((Element)Req, (String)"pay_cur_code", (String)info.getCurrency());
        JDomUtils.addChild((Element)Req, (String)"pay_acname", (String)info.getAccName());
        JDomUtils.addChild((Element)Req, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)Req, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)Req, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)Req, (String)"bank_flag", (String)(info.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)Req, (String)"area_flag", (String)"");
        JDomUtils.addChild((Element)Req, (String)"urgency_flag", (String)(info.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)Req, (String)"rcv_acno", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)Req, (String)"rcv_cur_code", (String)info.getCurrency());
        JDomUtils.addChild((Element)Req, (String)"rcv_acname", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)Req, (String)"rcv_bank_no", (String)info.getIncomeCnaps());
        JDomUtils.addChild((Element)Req, (String)"rcv_bank_name", (String)info.getIncomeBankName());
        JDomUtils.addChild((Element)Req, (String)"mobiles", (String)"");
        JDomUtils.addChild((Element)Req, (String)"saverecvinfo_flag", (String)"1");
        String amount = info.getAmount().setScale(2, 1).toPlainString();
        JDomUtils.addChild((Element)Req, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)Req, (String)"booking_flag", (String)"0");
        JDomUtils.addChild((Element)Req, (String)"booking_date", (String)"");
        JDomUtils.addChild((Element)Req, (String)"booking_time", (String)"");
        JDomUtils.addChild((Element)Req, (String)"purpose", (String)info.getUseCn());
        JDomUtils.addChild((Element)Req, (String)"postscript", (String)info.getExplanation());
        String encoding = RequestContextUtils.getCharset();
        String PacketMsg = JDomUtils.root2String((Element)Packet, (String)encoding);
        String signResMsg = SignUtils.sign(PacketMsg);
        Element Signature = JDomUtils.addChild((Element)Packet, (String)"Signature");
        JDomUtils.addChild((Element)Signature, (String)"DN", (String)signResMsg);
        String xmlMsg = JDomUtils.root2String((Element)Packet, (String)encoding);
        return CommonUtils.xmlToStrTrim(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element Packet = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element Data = Packet.getChild("Data");
        Element Pub = Data.getChild("Pub");
        Element Res = Data.getChild("Res");
        BankResponse response = TCommon.parseBankResponse(Pub);
        String req_no = Res.getChildTextTrim("req_no");
        String tr_acdt = Res.getChildTextTrim("tr_acdt");
        PaymentInfoSysFiled.set((PaymentInfo)info, (String)"req_no", (String)req_no);
        PaymentInfoSysFiled.set((PaymentInfo)info, (String)"tr_acdt", (String)tr_acdt);
        if ("0000".equals(response.getResponseCode()) || "000000".equals(response.getResponseCode())) {
            String result = Res.getChildTextTrim("jnl_stat");
            if ("0".equals(result) || "2".equals(result) || "3".equals(result) || "4".equals(result) || "5".equals(result) || "9".equals(result) || "A".equals(result) || "C".equals(result)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPaymentImpl_1", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)result, (String)response.getResponseMessage());
            } else if ("1".equals(result) || "6".equals(result) || "7".equals(result)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPaymentImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)result, (String)response.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPaymentImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)result, (String)response.getResponseMessage());
            }
        } else {
            String errorMsg = BankStatusCode.bankStatusCodeMap.get(response.getResponseCode());
            if (StringUtils.isEmpty((String)errorMsg)) {
                errorMsg = response.getResponseMessage();
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPaymentImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)errorMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

