/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.smbcn.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.smbcn.dc.util.PackerCommon;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/corpfe/H2HService/SC_I";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
        super.configFactory(factory);
    }

    public String pack(BankBalanceRequest request) {
        Element root = new Element("h2h");
        BankAcnt abnkacnt = (BankAcnt)request.getBankAcntList().get(0);
        PackerCommon.getBaseElement(root, "h2h.001.001", abnkacnt.getAccNo(), request.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return RspMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element respInfo = JDomUtils.getChildElement((Element)root, (String)"respInfo");
        String acceptFlag = JDomUtils.getChildText((Element)respInfo, (String)"acceptFlag");
        String respCode = JDomUtils.getChildText((Element)respInfo, (String)"respCode");
        String respMsg = JDomUtils.getChildText((Element)respInfo, (String)"respMsg");
        if ("-1".equals(acceptFlag)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)respCode, (String)respMsg));
        }
        Element resp = JDomUtils.getChildElement((Element)root, (String)"resp");
        String statusFlag = JDomUtils.getChildText((Element)resp, (String)"statusFlag");
        respCode = JDomUtils.getChildText((Element)resp, (String)"respCode");
        respMsg = JDomUtils.getChildText((Element)resp, (String)"respMsg");
        if (!"1".equals(statusFlag)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)respCode, (String)respMsg));
        }
        String Balance = JDomUtils.getChildText((Element)resp, (String)"balance");
        String Acc_balance = JDomUtils.getChildText((Element)resp, (String)"availablBalance");
        Element accPro = JDomUtils.getChildElement((Element)resp, (String)"accPro");
        String Account_num = JDomUtils.getChildText((Element)accPro, (String)"accNo");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankCurrency(balanceInfo, rqst.getBankCurrency());
        this.setCurrentBalance(balanceInfo, Balance);
        this.setAvailableBalance(balanceInfo, Acc_balance);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), Account_num);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "h2h.001.001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u63a5\u53e3", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]);
    }

    public boolean async() {
        return false;
    }
}

