/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000004_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000004_Send;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000004_SendItem;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.services.interfaces.IMiniService;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OPCB000004
implements IMiniService<Root<Header4Send, OPCB000004_Send>, Root<Header4Receive, OPCB000004_Receive>, List<PaymentInfo>, List<PaymentInfo>> {
    public static String transCode = "OPCB000004";

    public static OPCB000004 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000004_Send> getSendRoot(List<PaymentInfo> paymentInfos) throws Exception {
        Root<Header4Send, OPCB000004_Send> root = new Root<Header4Send, OPCB000004_Send>();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        OPCB000004_Send body = new OPCB000004_Send();
        ArrayList<OPCB000004_SendItem> items = new ArrayList<OPCB000004_SendItem>(1);
        body.setPAYER_ACCT_NO(paymentInfo.getAccNo());
        body.setPAYER_NAME(paymentInfo.getAccName());
        body.setBATCH_TOTAL_CNT(String.valueOf(paymentInfos.size()));
        body.setBATCH_TOTAL_AMT(Utils.getTotalAmount(paymentInfos));
        body.setBUSS_TYPE("2");
        for (PaymentInfo info : paymentInfos) {
            OPCB000004_SendItem item = new OPCB000004_SendItem();
            item.setORDERFLOW_NO(info.getDetailBizNo());
            item.setPAYEE_ACCT_NO(info.getIncomeAccNo());
            item.setPAYEE_NAME(info.getIncomeAccName());
            item.setTRAN_AMT(info.getAmount().toString());
            item.setPOSTSCRIPT(info.getExplanation());
            items.add(item);
            if (!info.getExplanation().contains(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"OPCB000004_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]))) continue;
            body.setBUSS_TYPE("1");
        }
        body.setACCT_ARRAY(items);
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000004_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000004_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public List<PaymentInfo> recvStrategy(Root<Header4Receive, OPCB000004_Receive> root, List<PaymentInfo> paymentInfos) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000004_Receive body = root.getBody();
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"body\u8282\u70b9\u4e0d\u5b58\u5728", (String)"OPCB000004_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), (String)headStatusCode, (String)headStatusMsg);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000004_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        String BATCH_NO = Utils.nullAsBlank(body.getBATCH_NO());
        String statusCode = headStatusCode;
        String statusMsg = headStatusMsg;
        if (StringUtils.isNotEmpty((String)BATCH_NO)) {
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"BATCH_NO", (String)BATCH_NO);
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"PAY_TRANSCODE", (String)this.getTransCode());
            OPCB000004.setBankRefId(paymentInfos, BATCH_NO);
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"OPCB000004_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), (String)statusCode, (String)statusMsg);
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u72b6\u6001\u672a\u77e5", (String)"OPCB000004_4", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), (String)statusCode, (String)statusMsg);
        }
        return paymentInfos;
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    public static void setBankRefId(List<PaymentInfo> paymentInfos, String bankRefId) {
        for (PaymentInfo info : paymentInfos) {
            info.setBankRefID(bankRefId);
        }
    }

    private static class Holder {
        private static final OPCB000004 instance = new OPCB000004();

        private Holder() {
        }
    }
}

