/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.cmp.services.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gxnx.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.gxnx.cmp.GxrcuMetaDataImpl;
import kd.ebg.aqap.banks.gxnx.cmp.services.utils.SignUtil;
import kd.ebg.aqap.banks.gxnx.dc.utils.GzipUtil;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.LoggerConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.net.NetUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Packer.class);

    public static String packQuerySubAcntPay(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE016");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"accountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"serialNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        String submitDate = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"beginDate", (String)submitDate);
        JDomUtils.addChild((Element)reqParam, (String)"endDate", (String)submitDate);
        JDomUtils.addChild((Element)reqParam, (String)"turnPageBgnPos", (String)"1");
        JDomUtils.addChild((Element)reqParam, (String)"turnPageShowQnt", (String)"20");
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        JDomUtils.addChild((Element)reqParam, (String)"groupId", (String)RequestContextUtils.getBankParameterValue((String)GxrcuMetaDataImpl.GROUP_NO));
        StringBuilder sb = new StringBuilder();
        sb.append(paymentInfo.getAccNo()).append("|").append(paymentInfo.getCurrency()).append("|").append(RequestContextUtils.getBankParameterValue((String)GxrcuMetaDataImpl.GROUP_NO));
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packSubAcntPay(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE013");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"serialNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)reqParam, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)reqParam, (String)"payAccountName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)reqParam, (String)"fastFlg", (String)(paymentInfo.getUrgent() != false ? "1" : "0"));
        JDomUtils.addChild((Element)reqParam, (String)"recBankType", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)reqParam, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"recBankCode", (String)(paymentInfo.is2SameBank() ? "" : paymentInfo.getIncomeCnaps()));
        JDomUtils.addChild((Element)reqParam, (String)"recBankName", (String)(paymentInfo.is2SameBank() ? "" : paymentInfo.getIncomeBankName()));
        JDomUtils.addChild((Element)reqParam, (String)"tranAmt", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)reqParam, (String)"payUse", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        JDomUtils.addChild((Element)reqParam, (String)"groupId", (String)RequestContextUtils.getBankParameterValue((String)GxrcuMetaDataImpl.GROUP_NO));
        StringBuilder sb = new StringBuilder();
        if (paymentInfo.is2SameBank()) {
            sb.append(paymentInfo.getAccNo()).append("|").append(paymentInfo.getAccName()).append("|").append(paymentInfo.getIncomeAccNo()).append("|").append(paymentInfo.getIncomeAccName()).append("|").append(paymentInfo.getAmount().toPlainString());
        } else {
            sb.append(paymentInfo.getAccNo()).append("|").append(paymentInfo.getAccName()).append("|").append(paymentInfo.getIncomeAccNo()).append("|").append(paymentInfo.getIncomeAccName()).append("|").append(paymentInfo.getIncomeCnaps()).append("|").append(paymentInfo.getAmount().toPlainString());
        }
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packQuerySalary(BankPayRequest bankPayRequest) {
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE011");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        String bankBatchSeqID = ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getBankBatchSeqID();
        JDomUtils.addChild((Element)reqParam, (String)"flowNo", (String)bankBatchSeqID);
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder sb = new StringBuilder();
        sb.append(bankBatchSeqID).append("|").append("6100");
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packSalary(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE009");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"flowNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        JDomUtils.addChild((Element)reqParam, (String)"acct", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        String busCode = BankBusinessConfig.getSalaryBusCode(((PaymentInfo)paymentInfos.get(0)).getAccNo());
        if (StringUtils.isEmpty((String)busCode)) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u94f6\u4f01\u8d26\u6237\u7684\u914d\u7f6e\u3002", (String)"Packer_3", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]));
        }
        String busName = BankBusinessConfig.getSalaryBusName(((PaymentInfo)paymentInfos.get(0)).getAccNo());
        if (StringUtils.isEmpty((String)busName)) {
            throw EBExceiptionUtil.payFailException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u534f\u8bae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u94f6\u4f01\u8d26\u6237\u7684\u914d\u7f6e\u3002", (String)"Packer_4", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)reqParam, (String)"proNo", (String)busCode);
        JDomUtils.addChild((Element)reqParam, (String)"proName", (String)busName);
        JDomUtils.addChild((Element)reqParam, (String)"totalQnt", (String)(paymentInfos.size() + ""));
        BigDecimal totalAmount = new BigDecimal("0.00");
        StringBuilder fileContent = new StringBuilder();
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(i);
            totalAmount = totalAmount.add(paymentInfo.getAmount());
            fileContent.append(paymentInfo.getBankDetailSeqID()).append(",").append(paymentInfo.getIncomeAccNo()).append(",").append(paymentInfo.getAmount().toPlainString()).append(",").append(paymentInfo.getIncomeAccName()).append(",").append(paymentInfo.getExplanation()).append("\n");
        }
        JDomUtils.addChild((Element)reqParam, (String)"totalAmt", (String)totalAmount.toPlainString());
        String defaultCode = ResManager.loadKDString((String)"0002-\u4ee3\u53d1\u5176\u4ed6", (String)"Packer_0", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]);
        String useCode = UseKeyWordService.getUseByKey((String)EBContext.getContext().getCustomID(), (String)((PaymentInfo)paymentInfos.get(0)).getUseCN(), (String)"CBE009", (String)defaultCode, (String)"GXNX_CMP");
        String[] split = useCode.split("-");
        JDomUtils.addChild((Element)reqParam, (String)"remarkCd", (String)split[0]);
        JDomUtils.addChild((Element)reqParam, (String)"remark", (String)split[1]);
        logger.info("\u4ee3\u53d1\u5185\u5bb9\uff1a{}", (Object)fileContent.toString());
        String fileCont = GzipUtil.gzipAndEncoder((String)fileContent.toString()).replaceAll("[\\t\\n\\r]", "");
        JDomUtils.addChild((Element)reqParam, (String)"fileName", (String)fileCont);
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((PaymentInfo)paymentInfos.get(0)).getAccNo()).append("|").append(totalAmount.toPlainString()).append("|").append(paymentInfos.size());
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)stringBuilder.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(stringBuilder.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packQueryPay(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE005");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"accountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"serialNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        String submitDate = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"beginDate", (String)submitDate);
        LocalDate endDate = LocalDate.parse(submitDate, DateTimeFormatter.ofPattern("yyyyMMdd")).plusDays(1L);
        JDomUtils.addChild((Element)reqParam, (String)"endDate", (String)endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder sb = new StringBuilder();
        sb.append(paymentInfo.getAccNo()).append("|").append(paymentInfo.getCurrency()).append("|").append(submitDate).append("|").append(endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packDiffBankPay(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE004");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"serialNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)reqParam, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)reqParam, (String)"payAccountName", (String)paymentInfo.getAccName());
        if (paymentInfo.getUrgent().booleanValue()) {
            JDomUtils.addChild((Element)reqParam, (String)"fastFlg", (String)"1");
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"fastFlg", (String)"0");
        }
        JDomUtils.addChild((Element)reqParam, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"recBankCode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)reqParam, (String)"recBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)reqParam, (String)"tranAmt", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)reqParam, (String)"payUse", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder sb = new StringBuilder();
        sb.append(paymentInfo.getAccNo()).append("|").append(paymentInfo.getAccName()).append("|").append(paymentInfo.getIncomeAccNo()).append("|").append(paymentInfo.getIncomeAccName()).append("|").append(paymentInfo.getIncomeCnaps()).append("|").append(paymentInfo.getAmount().toPlainString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packSameBankPay(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE003");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"serialNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)reqParam, (String)"payAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)reqParam, (String)"payAccountName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)reqParam, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"tranAmt", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)reqParam, (String)"payUse", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder sb = new StringBuilder();
        sb.append(paymentInfo.getAccNo()).append("|").append(paymentInfo.getAccName()).append("|").append(paymentInfo.getIncomeAccNo()).append("|").append(paymentInfo.getIncomeAccName()).append("|").append(paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packBalance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE002");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"accountNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder signDataStr = new StringBuilder();
        signDataStr.append(RequestContextUtils.getBankParameterValue((String)GxrcuMetaDataImpl.CUSTOM_NO)).append("|").append(acnt.getAccNo()).append("|").append("6100");
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)signDataStr.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(signDataStr.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packDetail(BankDetailRequest bankDetailRequest, String pageTag) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE006");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"accountNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)bankDetailRequest.getBankCurrency());
        String start = bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String end = bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"beginDate", (String)start);
        JDomUtils.addChild((Element)reqParam, (String)"endDate", (String)end);
        JDomUtils.addChild((Element)reqParam, (String)"turnPageBgnPos", (String)pageTag);
        JDomUtils.addChild((Element)reqParam, (String)"turnPageShowQnt", (String)String.valueOf(20));
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder sb = new StringBuilder();
        sb.append(acnt.getAccNo()).append("|").append(bankDetailRequest.getBankCurrency()).append("|").append(start).append("|").append(end);
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static Element packRoot() {
        return JDomUtils.createRoot((String)"QLBankData");
    }

    private static Element packHead(Element root, String bsnCode) {
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)bsnCode);
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)RequestContextUtils.getBankParameterValue((String)GxrcuMetaDataImpl.CUSTOM_NO));
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        JDomUtils.addChild((Element)opReq, (String)"reqMac", (String)NetUtil.getMacAddress((InetAddress)NetUtil.getLocalhost()));
        return opReq;
    }

    private static String parseSign(String returnStr) {
        Element root = JDomUtils.string2Root((String)returnStr, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String result = head.getChildText("result");
        String title = head.getChildText("title");
        if (!"0".equalsIgnoreCase(result)) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"Packer_1", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), title));
        }
        Element body = root.getChild("body");
        return body.getChildText("sign");
    }

    public static String decodeResponse(String responseStr) {
        try {
            String decode = URLDecoder.decode(responseStr, RequestContextUtils.getCharset());
            LoggerConnection.writeLogger((String)"response", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\uff1a%s", (String)"Packer_2", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), (String)decode);
            return decode;
        }
        catch (UnsupportedEncodingException e) {
            return responseStr;
        }
    }
}

