/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xib.dc.service.detail;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Packer;
import kd.ebg.aqap.banks.xib.dc.service.helper.XMB_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }

    public String getDeveloper() {
        return "HSQ";
    }

    public String getBizCode() {
        return "IESI109012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"IESI109012\uff0c\u8d26\u6237\u660e\u7ec6\u67e5\u8be2\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]);
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailList = new ArrayList(16);
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        while (!startDate.isAfter(endDate)) {
            request.setEndDate(startDate);
            startDate = startDate.plusDays(1L);
            EBBankDetailResponse ebBankDetailResponse = this.doBiz(request);
            detailList.addAll(ebBankDetailResponse.getDetails());
        }
        return new EBBankDetailResponse(detailList);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public String pack(BankDetailRequest bdr) {
        JsonObject body = new JsonObject();
        body.addProperty("accountNo", bdr.getAcnt().getAccNo());
        body.addProperty("queryDate", bdr.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String currentPage = this.getCurrentPage();
        int p = Integer.parseInt(currentPage);
        if (p == 0) {
            this.setCurrentPage(1);
            ++p;
        }
        body.addProperty("pageNo", (Number)p);
        body.addProperty("pageSize", (Number)10);
        String reqstMsg = XMB_Packer.createHeadRoot("IESI109012", body);
        return XMB_Packer.sign(reqstMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        BankAcnt bankAcnt = rqst.getAcnt();
        BankResponse rsp = XMB_Parser.paseHeadRoot(rspStr);
        if ("00000".equalsIgnoreCase(rsp.getResponseCode())) {
            List<DetailInfo> detailList = this.getDetailList(rspStr, bankAcnt);
            detailResponse.setDetails(detailList);
            return detailResponse;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s\uff1b\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-xib-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
    }

    private List<DetailInfo> getDetailList(String retMsgDecoded, BankAcnt bankAcnt) throws EBServiceException {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        JsonParser jsonParser = new JsonParser();
        retMsgDecoded = retMsgDecoded.replace("null", "\"\"");
        JsonObject jsonObject = jsonParser.parse(retMsgDecoded).getAsJsonObject();
        JsonObject body = jsonObject.get("body").getAsJsonObject();
        int totalRecord = body.get("totalRecord").getAsInt();
        if (totalRecord > 0) {
            JsonArray acctTranDetailList = body.get("acctTranDetailList").getAsJsonArray();
            if (acctTranDetailList.size() < 10) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
                String currentPage = this.getCurrentPage();
                int p = Integer.parseInt(currentPage);
                this.setCurrentPage(++p);
            }
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
            for (int i = 0; i < acctTranDetailList.size(); ++i) {
                try {
                    DetailInfo detailInfo = new DetailInfo();
                    detailInfo.setAccNo(bankAcnt.getAccNo());
                    detailInfo.setAccName(bankAcnt.getAccName());
                    JsonObject acctTranDetail = acctTranDetailList.get(i).getAsJsonObject();
                    String tranDateStr = acctTranDetail.get("tranDate").getAsString();
                    String tranTimeStr = acctTranDetail.get("tranTime").getAsString();
                    if (StringUtils.isEmpty((String)tranTimeStr)) {
                        tranTimeStr = "000000";
                    }
                    String date = tranDateStr + tranTimeStr;
                    detailInfo.setTransTime(LocalDateTime.parse(date, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                    detailInfo.setTransDate(LocalDate.parse(tranDateStr, DateTimeFormatter.ofPattern("yyyyMMdd")));
                    String currency = acctTranDetail.get("currency").getAsString();
                    detailInfo.setCurrency(currency);
                    BigDecimal debitAmt = acctTranDetail.get("debitAmt").getAsBigDecimal();
                    BigDecimal creditAmt = acctTranDetail.get("creditAmt").getAsBigDecimal();
                    detailInfo.setDebitAmount(creditAmt);
                    detailInfo.setCreditAmount(debitAmt);
                    String closingBal = acctTranDetail.get("closingBal").getAsString();
                    if (StringUtils.isNotEmpty((String)closingBal)) {
                        detailInfo.setBalance(new BigDecimal(closingBal));
                    }
                    String remarks = acctTranDetail.get("remarks").getAsString();
                    detailInfo.setUseCn(remarks);
                    detailInfo.setTransType("remarks");
                    String addtlInf = acctTranDetail.get("addtlInf").getAsString();
                    detailInfo.setExplanation(StringUtils.isEmpty((String)addtlInf) ? "" : addtlInf);
                    if (StringUtils.isNotEmpty((String)addtlInf) && addtlInf.contains("KD@")) {
                        String[] kdFlag = addtlInf.split("KD@");
                        DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)kdFlag[1]);
                        detailInfo.setExplanation(kdFlag[0]);
                    }
                    String cbsToAcctNo = acctTranDetail.get("cbsToAcctNo").getAsString();
                    detailInfo.setOppAccNo(cbsToAcctNo);
                    String cbsToAcctName = acctTranDetail.get("cbsToAcctName").getAsString();
                    detailInfo.setOppAccName(cbsToAcctName);
                    String cbsToAcctBranchNm = acctTranDetail.get("cbsToAcctBranchNm").getAsString();
                    detailInfo.setOppBankName(cbsToAcctBranchNm);
                    detailInfo.setHistory(Boolean.valueOf(true));
                    detailInfo.setJsonMap(acctTranDetail.toString());
                    detailInfo.setBankDetailNo(acctTranDetail.get("bankSerialNo").getAsString());
                    String accNo = bankAcnt.getAccNo();
                    String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                    String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, acctTranDetail.toString());
                    if (countMap.containsKey(receiptNo)) {
                        int count = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, count);
                        receiptNo = receiptNo + "-" + String.format("%04d", count);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    detailInfo.setReceiptNo(receiptNo);
                    detailList.add(detailInfo);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u5f02\u5e38\u660e\u7ec6", (Throwable)e);
                }
            }
        }
        return detailList;
    }

    public boolean isSupportPage() {
        return true;
    }
}

