/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gyb.dc.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.gyb.dc.helper.GYB_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = GYB_Parser.parserCommonInfo(root);
        if (!"0000".equals(bankResponse.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"RespondBody");
        List rowList = resBody.getChildren("RespondRecord");
        ArrayList<BalanceInfo> banBalanceInfos = new ArrayList<BalanceInfo>(1);
        for (int j = 0; j < rowList.size(); ++j) {
            String accName = JDomUtils.getChildText((Element)((Element)rowList.get(j)), (String)"AcctName");
            String amount = JDomUtils.getChildText((Element)((Element)rowList.get(j)), (String)"Balance");
            String balanceAvailable = JDomUtils.getChildText((Element)((Element)rowList.get(j)), (String)"AvialiableBalance");
            String Currrency = JDomUtils.getChildText((Element)((Element)rowList.get(j)), (String)"Currrency");
            BalanceInfo balanceInfo = new BalanceInfo();
            BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)rqst.getBankCurrency(), (String)Currrency);
            balanceInfo.setBankAcnt(rqst.getAcnt());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)amount);
            BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)balanceAvailable);
            banBalanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(banBalanceInfos);
    }
}

