/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.utils;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.balance.BalanceImpl;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Parser {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(Parser.class);
    private static final String separator = "\\|";

    public static BankResponse parseResponse(String retMsg) {
        Element root = JDomUtils.string2Root((String)retMsg, (String)EBContext.getContext().getParameter().getBankParameter("charset"));
        Element opRep = root.getChild("opRep");
        String retCode = ParserUtils.getUnNullElementTextValue((Element)opRep, (String)"retCode", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u7801", (String)"Parser_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
        String errMsg = ParserUtils.getUnNullElementTextValue((Element)opRep, (String)"errMsg", (String)ResManager.loadKDString((String)"\u9519\u8bef\u63cf\u8ff0", (String)"Parser_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
        BankResponse response = new BankResponse();
        response.setResponseCode(retCode);
        response.setResponseMessage(errMsg);
        return response;
    }

    public static boolean canSearBalance(BankDetailRequest rqst) {
        BankAcnt acnt = rqst.getHeader().getAcnt();
        String currency = rqst.getBankCurrency();
        return Parser.canSearBalance(acnt, rqst.getHeader());
    }

    private static boolean canSearBalance(BankAcnt acnt, BankHeader header) {
        try {
            BankBalanceRequest request = new BankBalanceRequest();
            request.setHeader(header);
            request.setBankAcntList((List)Lists.newArrayList((Object[])new BankAcnt[]{acnt}));
            BalanceImpl balImp = new BalanceImpl();
            balImp.balance(request);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static PaymentInfo getPaymentInfoBySerialNo(List<PaymentInfo> paymentInfos, String serailNo) {
        PaymentInfo info = null;
        for (PaymentInfo p : paymentInfos) {
            if (!serailNo.equals(PaymentInfoSysFiled.get((PaymentInfo)p, (String)"bosh_serialNo"))) continue;
            info = p;
            break;
        }
        return info;
    }
}

