/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nhb.dc.services.payment.company.outer;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nhb.dc.services.payment.company.CompanyQueryImpl;
import kd.ebg.aqap.banks.nhb.dc.services.payment.company.inner.InnerBankPaymentImpl;
import kd.ebg.aqap.banks.nhb.dc.utils.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OuterBankPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = Packer.createHead("B2ECrossBankTransfer", paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (Element)head);
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"SubmitNo", (String)paymentInfos[0].getBankBatchSeqId());
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element map = JDomUtils.addChild((Element)list, (String)"Map");
            JDomUtils.addChild((Element)map, (String)"ListNo", (String)paymentInfos[i].getBankDetailSeqId());
            JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)map, (String)"PayerSubAcType", (String)"");
            JDomUtils.addChild((Element)map, (String)"Amount", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"UnionDeptId", (String)paymentInfos[i].getIncomeCnaps());
            JDomUtils.addChild((Element)map, (String)"PayeeBankName", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)map, (String)"Remark", (String)paymentInfos[i].getExplanation());
            JDomUtils.addChild((Element)map, (String)"AttachInfo", (String)paymentInfos[i].getExplanation());
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        InnerBankPaymentImpl innerBankPayment = new InnerBankPaymentImpl();
        return innerBankPayment.parse(bankPayRequest, s);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.3.5 \u8de8\u884c\u8f6c\u8d26 \uff08\u652f\u6301\u591a\u7b14\uff09\uff08\u4ea4\u6613\u7801B2ECrossBankTransfer\uff09", (String)"OuterBankPaymentImpl_0", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getUrl(this.getBizCode()));
    }
}

