/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nhb.dc.services.payment.salary;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nhb.dc.services.payment.salary.SalaryQueryImpl;
import kd.ebg.aqap.banks.nhb.dc.utils.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = Packer.createHead("B2EAgentSubmit", paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (Element)head);
        String salaryBusiNo = RequestContextUtils.getBankParameterValue((String)"salaryBusiNo");
        String salaryProjectName = RequestContextUtils.getBankParameterValue((String)"salaryProjectName");
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"SubmitNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"BusiNo", (String)salaryBusiNo);
        JDomUtils.addChild((Element)body, (String)"ProjectName", (String)salaryProjectName);
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"TotalCount", (String)("" + paymentInfos.length));
        BigDecimal totalAmt = new BigDecimal("0.00");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < paymentInfos.length; ++i) {
            totalAmt = totalAmt.add(paymentInfos[i].getAmount());
            buffer.append(paymentInfos[i].getBankDetailSeqId()).append(',');
            buffer.append(paymentInfos[i].getIncomeAccNo()).append(",");
            buffer.append(paymentInfos[i].getIncomeAccName()).append(",");
            buffer.append(paymentInfos[i].getAmount().toString());
            buffer.append("\n");
        }
        JDomUtils.addChild((Element)body, (String)"TotalAmount", (String)totalAmt.toString());
        try {
            JDomUtils.addChild((Element)body, (String)"Contents", (String)Packer.compress(buffer.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        EBBankPayResponse eb = new EBBankPayResponse();
        Element error = root.getChild("error");
        if (null != error) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error.getTextTrim());
            eb.setPaymentInfos(bankPayRequest.getPaymentInfos());
            return eb;
        }
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)iBSReturnCode, (String)iBSReturnMsg);
            eb.setPaymentInfos(bankPayRequest.getPaymentInfos());
            return eb;
        }
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)iBSReturnCode, (String)iBSReturnMsg);
        eb.setPaymentInfos(bankPayRequest.getPaymentInfos());
        return eb;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EAgentSubmit";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.3.8 \u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\u63d0\u4ea4\u3010\u4ea4\u6613\u65b9\u5f0f\u3011\uff08\u4ea4\u6613\u7801B2EAgentSubmit\uff09", (String)"SalaryPaymentImpl_0", (String)"ebg-aqap-banks-nhb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri(Packer.getUrl(this.getBizCode()));
    }
}

